/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.method;

import org.ivml.alimo.ISub;

public class StringDistances {
    public static double subStringDistance(String string, String string2) {
        if (string == null || string2 == null) {
            return 1.0;
        }
        int n = string.length();
        int n2 = string2.length();
        if (n == 0 && n2 == 0) {
            return 0.0;
        }
        if (n == 0 || n2 == 0) {
            return 1.0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n4 = 0; n4 < n && n - n4 > n3; ++n4) {
            n5 = 0;
            while (n2 - n5 > n3) {
                int n6 = n4;
                while (n5 < n2 && string.charAt(n6) != string2.charAt(n5)) {
                    ++n5;
                }
                if (n5 == n2) continue;
                ++n5;
                ++n6;
                while (n5 < n2 && n6 < n && string.charAt(n6) == string2.charAt(n5)) {
                    ++n5;
                    ++n6;
                }
                n3 = Math.max(n3, n6 - n4);
            }
        }
        return 1.0 - 2.0 * (double)n3 / (double)(n + n2);
    }

    public static double equalDistance(String string, String string2) {
        if (string == null || string2 == null) {
            return 1.0;
        }
        if (string.equals(string2)) {
            return 0.0;
        }
        return 1.0;
    }

    public static double hammingDistance(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return 1.0;
        }
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = Math.min(n2, n3);
        int n5 = n = Math.max(n2, n3);
        for (int i = 0; i < n4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            --n5;
        }
        return (double)n5 / (double)n;
    }

    public static double jaroMeasure(String string, String string2) {
        if (string == null || string2 == null) {
            return 1.0;
        }
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2) / 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        char c = '\u0000';
        while (n4 < n || n5 < n2) {
            int n9;
            if (n5 < n2 && n6 > n7 || n4 > n) {
                for (n9 = Math.max(0, n5 - n3); n9 < Math.min(n, n5 + n3); ++n9) {
                    if (string2.charAt(n5) != string.charAt(n9)) continue;
                    ++n7;
                    if (string2.charAt(n5) == c) {
                        ++n8;
                    }
                    n9 = n;
                }
                ++n5;
                continue;
            }
            if (n4 == n) {
                c = '\u0000';
                n4 = n + 1;
                continue;
            }
            for (n9 = Math.max(0, n4 - n3); n9 < Math.min(n2, n4 + n3); ++n9) {
                if (string2.charAt(n9) != string.charAt(n4)) continue;
                ++n6;
                c = string.charAt(n4);
                n9 = n2;
            }
            ++n4;
        }
        if ((double)n6 == 0.0) {
            return 1.0;
        }
        return 1.0 - ((double)n6 / (double)n + (double)n7 / (double)n2 + (double)n8 / (double)n6) / 3.0;
    }

    public static double jaroWinklerMeasure(String string, String string2) {
        int n = 4;
        double d = StringDistances.jaroMeasure(string, string2);
        return d + (double)n * (1.0 - d) / 10.0;
    }

    public static double ngramDistance(String string, String string2) {
        int n = 3;
        if (string == null || string2 == null) {
            return 1.0;
        }
        int n2 = string.length() - n + 1;
        int n3 = string2.length() - n + 1;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5;
                for (n5 = 0; n5 < n && string.charAt(i + n5) == string2.charAt(j + n5); ++n5) {
                }
                if (n5 != n) continue;
                ++n4;
            }
        }
        return 1.0 - 2.0 * (double)n4 / (double)(n2 + n3);
    }

    public static double levenshteinDistance(String string, String string2) {
        return StringDistances.needlemanWunchDistance(string, string2, 1);
    }

    public static double needlemanWunch2Distance(String string, String string2) {
        return StringDistances.needlemanWunchDistance(string, string2, 2);
    }

    public static double needlemanWunchDistance(String string, String string2, int n) {
        int n2;
        if (string == null || string2 == null) {
            return 1.0;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return 1.0;
        }
        if (n4 == 0) {
            return 1.0;
        }
        int[] nArray = new int[n3 + 1];
        int[] nArray2 = new int[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2] = n2;
        }
        for (int i = 1; i <= n4; ++i) {
            char c = string2.charAt(i - 1);
            nArray2[0] = i;
            for (n2 = 1; n2 <= n3; ++n2) {
                int n5 = string.charAt(n2 - 1) == c ? 0 : 1;
                nArray2[n2] = Math.min(Math.min(nArray2[n2 - 1] + n, nArray[n2] + n), nArray[n2 - 1] + n5);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        int n6 = Math.min(n3, n4);
        int n7 = Math.max(n3, n4) - n6;
        return (double)nArray[n3] / (double)(n6 + n7 * n);
    }

    public static double smoaDistance(String string, String string2) {
        if (string == null || string2 == null) {
            return 1.0;
        }
        ISub iSub = new ISub();
        return 1.0 - iSub.score(string, string2);
    }
}

