/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public class COWLMappingRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;

    public COWLMappingRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof OWLAPIAlignment)) {
            throw new AlignmentException("COWLMappingRenderer: cannot render simple alignment. Turn them into OWLAlignment, by toOWLAPIAlignement()");
        }
        this.alignment = alignment;
        this.writer.print("<rdf:RDF\n");
        this.writer.print("    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n");
        this.writer.print("    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.writer.print("    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        this.writer.print("    xmlns:cowl=\"http://www.itc.it/cowl#\" \n");
        this.writer.print("    xml:base=\"http://www.itc.it/cowl#\" \n");
        this.writer.print("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n\n");
        this.writer.print("  <cowl:Mapping rdf:ID=\"\">\n");
        this.writer.print("    <cowl:sourceOntology>\n");
        this.writer.print("      <owl:Ontology rdf:about=\"" + alignment.getOntology1URI() + "\"/>\n");
        this.writer.print("    </cowl:sourceOntology>\n");
        this.writer.print("    <cowl:targetOntology>\n");
        this.writer.print("      <owl:Ontology rdf:about=\"" + alignment.getOntology2URI() + "\"/>\n");
        this.writer.print("    </cowl:targetOntology>\n");
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("  </cowl:Mapping>\n");
        this.writer.print("</rdf:RDF>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        this.writer.print("    <cowl:bridgeRule>\n");
        cell.getRelation().accept((AlignmentVisitor)this);
        this.writer.print("    </cowl:bridgeRule>\n");
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        try {
            this.writer.print("     <cowl:Equivalent>\n");
            this.writer.print("       <cowl:source>\n");
            this.printObject(this.cell.getObject1AsURI(), (OWLOntology)this.alignment.getOntology1());
            this.writer.print("       </cowl:source>\n");
            this.writer.print("       <cowl:target>\n");
            this.printObject(this.cell.getObject2AsURI(), (OWLOntology)this.alignment.getOntology2());
            this.writer.print("       </cowl:target>\n");
            this.writer.print("     </cowl:Equivalent>\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        try {
            this.writer.print("     <cowl:Into>\n");
            this.writer.print("       <cowl:source>\n");
            this.printObject(this.cell.getObject1AsURI(), (OWLOntology)this.alignment.getOntology1());
            this.writer.print("       </cowl:source>\n");
            this.writer.print("       <cowl:target>\n");
            this.printObject(this.cell.getObject2AsURI(), (OWLOntology)this.alignment.getOntology2());
            this.writer.print("       </cowl:target>\n");
            this.writer.print("     </cowl:Into>\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        try {
            this.writer.print("     <cowl:Onto>\n");
            this.writer.print("       <cowl:source>\n");
            this.printObject(this.cell.getObject1AsURI(), (OWLOntology)this.alignment.getOntology1());
            this.writer.print("       </cowl:source>\n");
            this.writer.print("       <cowl:target>\n");
            this.printObject(this.cell.getObject2AsURI(), (OWLOntology)this.alignment.getOntology2());
            this.writer.print("       </cowl:target>\n");
            this.writer.print("     </cowl:Onto>\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        try {
            this.writer.print("     <cowl:INCOMPATIBLE>\n");
            this.writer.print("       <cowl:source>\n");
            this.printObject(this.cell.getObject1AsURI(), (OWLOntology)this.alignment.getOntology1());
            this.writer.print("       </cowl:source>\n");
            this.writer.print("       <cowl:target>\n");
            this.printObject(this.cell.getObject2AsURI(), (OWLOntology)this.alignment.getOntology2());
            this.writer.print("       </cowl:target>\n");
            this.writer.print("     </cowl:INCOMPATIBLE>\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void printObject(URI uRI, OWLOntology oWLOntology) throws OWLException {
        if (oWLOntology.getClass(uRI) != null) {
            this.writer.print("         <owl:Class rdf:about=\"" + uRI.toString() + "\"/>\n");
        } else if (oWLOntology.getDataProperty(uRI) != null) {
            this.writer.print("         <owl:DataProperty rdf:about=\"" + uRI.toString() + "\"/>\n");
        } else if (oWLOntology.getObjectProperty(uRI) != null) {
            this.writer.print("         <owl:ObjectProperty rdf:about=\"" + uRI.toString() + "\"/>\n");
        } else if (oWLOntology.getIndividual(uRI) != null) {
            this.writer.print("         <owl:Individual rdf:about=\"" + uRI.toString() + "\"/>\n");
        }
    }
}

