/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import java.io.PrintWriter;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;

public class HTMLRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;

    public HTMLRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        String string;
        this.alignment = alignment;
        this.writer.print("<html>\n<head></head>\n<body>\n");
        this.writer.print("<h1></h1>\n");
        this.writer.print("<h2>Alignment metadata</h2>\n");
        this.writer.print("<table border=\"0\">\n");
        this.writer.print("<tr><td>uri1</td><td>" + alignment.getOntology1URI().toString() + "</td></tr>\n");
        this.writer.print("<tr><td>uri2</td><td>" + alignment.getOntology2URI().toString() + "</td></tr>\n");
        if (alignment.getFile1() != null) {
            this.writer.print("<tr><td>ontofile1</td><td><a href=\"" + alignment.getFile1().toString() + "\">" + alignment.getFile1().toString() + "</a></td></tr>\n");
        }
        if (alignment.getFile2() != null) {
            this.writer.print("<tr><td>ontofile2</td><td><a href=\"" + alignment.getFile2().toString() + "\">" + alignment.getFile2().toString() + "</a></td></tr>\n");
        }
        this.writer.print("<tr><td>level</td><td>" + alignment.getLevel() + "</td></tr>\n");
        this.writer.print("<tr><td>type</td><td>" + alignment.getType() + "</td></tr>\n");
        Enumeration enumeration = alignment.getExtensions().getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.writer.print("<tr><td>" + string + "</td><td>" + alignment.getExtension(string) + "</td></tr>\n");
        }
        this.writer.print("</table>\n");
        this.writer.print("<h2>Correspondences</h2>\n");
        this.writer.print("<table><tr><td>object1</td><td>relation</td><td>strength</td><td>object2</td><td>Id</td></tr>\n");
        enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            string = (Cell)enumeration.nextElement();
            string.accept((AlignmentVisitor)this);
        }
        this.writer.print("</table>\n");
        this.writer.print("</body>\n</html>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        this.writer.print("  <tr>");
        this.writer.print("<td>" + cell.getObject1AsURI().toString() + "</td><td>");
        cell.getRelation().accept((AlignmentVisitor)this);
        this.writer.print("</td><td>" + cell.getStrength() + "</td>");
        this.writer.print("<td>" + cell.getObject2AsURI().toString() + "</td>");
        if (cell.getId() != null) {
            String string = cell.getId();
            if (string.startsWith(this.alignment.getExtension("id"))) {
                this.writer.print("<td>" + string.substring(string.indexOf(35)) + "</td>");
            } else {
                this.writer.print("<td>" + string + "</td>");
            }
        } else {
            this.writer.print("<td></td>");
        }
        this.writer.println("</tr>");
    }

    public void visit(Relation relation) {
        relation.write(this.writer);
    }
}

