/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public class OWLAxiomsRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;

    public OWLAxiomsRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof OWLAPIAlignment)) {
            throw new AlignmentException("OWLAxiomsRenderer: cannot render simple alignment. Turn them into OWLAlignment, by toOWLAPIAlignement()");
        }
        this.alignment = alignment;
        this.writer.print("<rdf:RDF\n");
        this.writer.print("    xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n");
        this.writer.print("    xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n");
        this.writer.print("    xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" \n");
        this.writer.print("    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n\n");
        this.writer.print("  <owl:Ontology rdf:about=\"\">\n");
        this.writer.print("    <rdfs:comment>Matched ontologies</rdfs:comment>\n");
        this.writer.print("    <owl:imports rdf:resource=\"" + alignment.getOntology1URI().toString() + "\"/>\n");
        this.writer.print("    <owl:imports rdf:resource=\"" + alignment.getOntology2URI().toString() + "\"/>\n");
        this.writer.print("  </owl:Ontology>\n\n");
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print("</rdf:RDF>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        OWLOntology oWLOntology = null;
        URI uRI = null;
        try {
            if (cell.getRelation() instanceof SubsumedRelation) {
                oWLOntology = (OWLOntology)this.alignment.getOntology2();
                uRI = cell.getObject2AsURI();
            } else {
                oWLOntology = (OWLOntology)this.alignment.getOntology1();
                uRI = cell.getObject1AsURI();
            }
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.print("  <owl:Class rdf:about=\"" + uRI.toString() + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("  </owl:Class>\n");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.print("  <owl:DatatypeProperty rdf:about=\"" + uRI.toString() + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("  </owl:DatatypeProperty>\n");
            } else if (oWLOntology.getObjectProperty(uRI) != null) {
                this.writer.print("  <owl:ObjectProperty rdf:about=\"" + uRI.toString() + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("  </owl:ObjectProperty>\n");
            } else if (oWLOntology.getIndividual(uRI) != null) {
                this.writer.print("  <owl:Thing rdf:about=\"" + uRI.toString() + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("  </owl:Thing>\n");
            }
            this.writer.print("\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        OWLOntology oWLOntology = (OWLOntology)this.alignment.getOntology2();
        try {
            URI uRI = this.cell.getObject2AsURI();
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.print("    <owl:equivalentClass rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.print("    <owl:equivalentProperty rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getObjectProperty(uRI) != null) {
                this.writer.print("    <owl:equivalentProperty rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getIndividual(uRI) != null) {
                this.writer.print("    <owl:sameAs rdf:resource=\"" + uRI.toString() + "\"/>\n");
            }
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        OWLOntology oWLOntology = (OWLOntology)this.alignment.getOntology2();
        try {
            URI uRI = this.cell.getObject2AsURI();
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.print("    <rdfs:subClassOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getObjectProperty(uRI) != null) {
                this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            }
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        OWLOntology oWLOntology = (OWLOntology)this.alignment.getOntology1();
        try {
            URI uRI = this.cell.getObject1AsURI();
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.print("    <rdfs:subClassOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            } else if (oWLOntology.getObjectProperty(uRI) != null) {
                this.writer.print("    <rdfs:subPropertyOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
            }
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        URI uRI = this.cell.getObject2AsURI();
        this.writer.print("    <owl:inverseOf rdf:resource=\"" + uRI.toString() + "\"/>\n");
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

