/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import java.io.PrintWriter;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;

public class RDFRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;

    public RDFRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        String string;
        this.alignment = alignment;
        this.writer.print("<?xml version='1.0' encoding='utf-8");
        this.writer.print("' standalone='no'?>\n");
        this.writer.print("<rdf:RDF xmlns='http://knowledgeweb.semanticweb.org/heterogeneity/alignment'\n         xml:base='http://knowledgeweb.semanticweb.org/heterogeneity/alignment'\n         xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'\n         xmlns:xsd='http://www.w3.org/2001/XMLSchema#'>\n");
        this.writer.print("<Alignment>\n  <xml>yes</xml>\n");
        this.writer.print("  <level>");
        this.writer.print(alignment.getLevel());
        this.writer.print("</level>\n  <type>");
        this.writer.print(alignment.getType());
        this.writer.print("</type>\n");
        Enumeration enumeration = alignment.getExtensions().getNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.writer.print("  <" + string + ">" + alignment.getExtension(string) + "</" + string + ">\n");
        }
        if (alignment.getFile1() != null) {
            this.writer.print("  <onto1>" + alignment.getFile1().toString() + "</onto1>\n");
        }
        if (alignment.getFile2() != null) {
            this.writer.print("  <onto2>" + alignment.getFile2().toString() + "</onto2>\n");
        }
        this.writer.print("  <uri1>");
        this.writer.print(alignment.getOntology1URI().toString());
        this.writer.print("</uri1>\n");
        this.writer.print("  <uri2>");
        this.writer.print(alignment.getOntology2URI().toString());
        this.writer.print("</uri2>\n");
        enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            string = (Cell)enumeration.nextElement();
            string.accept((AlignmentVisitor)this);
        }
        this.writer.print("</Alignment>\n");
        this.writer.print("</rdf:RDF>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        if (cell.getObject1AsURI() != null && cell.getObject2AsURI() != null) {
            this.writer.print("  <map>\n");
            this.writer.print("    <Cell");
            if (cell.getId() != null) {
                this.writer.print(" rdf:about=\"" + cell.getId() + "\"");
            }
            this.writer.print(">\n      <entity1 rdf:resource='");
            this.writer.print(cell.getObject1AsURI().toString());
            this.writer.print("'/>\n      <entity2 rdf:resource='");
            this.writer.print(cell.getObject2AsURI().toString());
            this.writer.print("'/>\n      <relation>");
            cell.getRelation().accept((AlignmentVisitor)this);
            this.writer.print("</relation>\n");
            this.writer.print("      <measure rdf:datatype='http://www.w3.org/2001/XMLSchema#float'>");
            this.writer.print(cell.getStrength());
            this.writer.print("</measure>\n");
            if (cell.getSemantics() != null && !cell.getSemantics().equals("") && !cell.getSemantics().equals("first-order")) {
                this.writer.print("      <semantics>" + cell.getSemantics() + "</semantics>\n");
            }
        }
        if (cell.getExtensions() != null) {
            Enumeration enumeration = cell.getExtensions().getNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.writer.print("      <" + string + ">" + cell.getExtension(string) + "</" + string + ">\n");
            }
        }
        this.writer.print("    </Cell>\n  </map>\n");
    }

    public void visit(Relation relation) {
        relation.write(this.writer);
    }
}

