/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import java.util.Random;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public class SEKTMappingRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;
    Random generator = null;

    public SEKTMappingRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
        this.generator = new Random();
    }

    public void visit(Alignment alignment) throws AlignmentException {
        this.alignment = alignment;
        if (!(alignment instanceof OWLAPIAlignment)) {
            throw new AlignmentException("SEKTMappingRenderer: cannot render simple alignment. Turn them into OWLAlignment, by toOWLAPIAlignement()");
        }
        this.writer.print("MappingDocument(<\"\">\n");
        this.writer.print("  source(<\"" + alignment.getOntology1URI().toString() + "\">)\n");
        this.writer.print("  target(<\"" + alignment.getOntology2URI().toString() + "\">)\n");
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.print(")\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        String string = "s" + this.generator.nextInt(100000);
        OWLOntology oWLOntology = (OWLOntology)this.alignment.getOntology1();
        try {
            URI uRI = cell.getObject1AsURI();
            URI uRI2 = cell.getObject2AsURI();
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.print("  classMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + uRI.toString() + "\">\n");
                this.writer.print("    <\"" + uRI2.toString() + "\">\n");
                this.writer.print("  )\n");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.print("  relationMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + uRI.toString() + "\">\n");
                this.writer.print("    <\"" + uRI2.toString() + "\">\n");
                this.writer.print("  )\n");
            } else if (oWLOntology.getObjectProperty(uRI) != null) {
                this.writer.print("  attributeMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + uRI.toString() + "\">\n");
                this.writer.print("    <\"" + uRI2.toString() + "\">\n");
                this.writer.print("  )\n");
            } else if (oWLOntology.getIndividual(uRI) != null) {
                this.writer.print("  instanceMapping( <\"#" + string + "\">\n");
                cell.getRelation().accept((AlignmentVisitor)this);
                this.writer.print("    <\"" + uRI.toString() + "\">\n");
                this.writer.print("    <\"" + uRI2.toString() + "\">\n");
                this.writer.print("  )\n");
            }
            this.writer.print("\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        this.writer.print("    bidirectional\n");
    }

    public void visit(SubsumeRelation subsumeRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(SubsumedRelation subsumedRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(IncompatRelation incompatRelation) throws AlignmentException {
        this.writer.print("    unidirectional\n");
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

