/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;

public class SWRLRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;

    public SWRLRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        if (!(alignment instanceof OWLAPIAlignment)) {
            throw new AlignmentException("SWRLRenderer: cannot render simple alignment. Turn them into OWLAlignment, by toOWLAPIAlignement()");
        }
        this.alignment = alignment;
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.println("<swrlx:Ontology swrlx:name=\"generatedAl\"");
        this.writer.println("                xmlns:swrlx=\"http://www.w3.org/2003/11/swrlx#\"");
        this.writer.println("                xmlns:owlx=\"http://www.w3.org/2003/05/owl-xml\"");
        this.writer.println("                xmlns:ruleml=\"http://www.w3.org/2003/11/ruleml#\">");
        this.writer.println("  <owlx:Imports rdf:resource=\"" + alignment.getOntology1URI().toString() + "\"/>\n");
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            cell.accept((AlignmentVisitor)this);
        }
        this.writer.println("</swrlx:Ontology>");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        URI uRI = cell.getObject1AsURI();
        cell.getRelation().accept((AlignmentVisitor)this);
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        try {
            this.writer.println("  <ruleml:imp>");
            this.writer.println("    <ruleml:_body>");
            OWLOntology oWLOntology = (OWLOntology)this.alignment.getOntology1();
            URI uRI = this.cell.getObject1AsURI();
            if (oWLOntology.getClass(uRI) != null) {
                this.writer.println("      <swrl:classAtom>");
                this.writer.println("        <owllx:Class owllx:name=\"" + uRI.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("      </swrl:classAtom>");
            } else if (oWLOntology.getDataProperty(uRI) != null) {
                this.writer.println("      <swrl:datavaluedPropertyAtom swrlx:property=\"" + uRI.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("        <ruleml:var>y</ruleml:var>");
                this.writer.println("      <swrl:datavaluedPropertyAtom>");
            } else {
                this.writer.println("      <swrl:individualPropertyAtom swrlx:property=\"" + uRI.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("        <ruleml:var>y</ruleml:var>");
                this.writer.println("      </swrl:individualPropertyAtom>");
            }
            this.writer.println("    </ruleml:_body>");
            this.writer.println("    <ruleml:_head>");
            OWLOntology oWLOntology2 = (OWLOntology)this.alignment.getOntology2();
            URI uRI2 = this.cell.getObject2AsURI();
            if (oWLOntology2.getClass(uRI2) != null) {
                this.writer.println("      <swrlx:classAtom>");
                this.writer.println("        <owllx:Class owllx:name=\"" + uRI2.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("      </swrl:classAtom>");
            } else if (oWLOntology2.getDataProperty(uRI2) != null) {
                this.writer.println("      <swrl:datavaluedPropertyAtom swrlx:property=\"" + uRI2.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("        <ruleml:var>y</ruleml:var>");
                this.writer.println("      </swrl:datavaluedPropertyAtom>");
            } else {
                this.writer.println("      <swrl:individualPropertyAtom swrlx:property=\"" + uRI2.toString() + "\"/>");
                this.writer.println("        <ruleml:var>x</ruleml:var>");
                this.writer.println("        <ruleml:var>y</ruleml:var>");
                this.writer.println("      </swrl:individualPropertyAtom>");
            }
            this.writer.println("    </ruleml:_head>");
            this.writer.println("  </ruleml:imp>\n");
        }
        catch (OWLException oWLException) {
            throw new AlignmentException("getURI problem", (Exception)((Object)oWLException));
        }
    }

    public void visit(SubsumeRelation subsumeRelation) {
    }

    public void visit(SubsumedRelation subsumedRelation) {
    }

    public void visit(IncompatRelation incompatRelation) {
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

