/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import java.io.PrintWriter;
import java.util.Enumeration;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.semanticweb.owl.align.Relation;

public class XMLMetadataRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;

    public XMLMetadataRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    public void visit(Alignment alignment) throws AlignmentException {
        this.writer.print("<?xml version='1.0' encoding='utf-8' standalone='yes'?>\n");
        this.writer.println("<Alignment>");
        this.writer.print("  <level>");
        this.writer.print(alignment.getLevel());
        this.writer.print("</level>\n  <type>");
        this.writer.print(alignment.getType());
        this.writer.print("</type>\n");
        if (alignment.getFile1() != null) {
            this.writer.print("  <onto1>" + alignment.getFile1().toString() + "</onto1>\n");
        }
        if (alignment.getFile2() != null) {
            this.writer.print("  <onto2>" + alignment.getFile2().toString() + "</onto2>\n");
        }
        this.writer.print("  <uri1>");
        this.writer.print(alignment.getOntology1URI().toString());
        this.writer.print("</uri1>\n");
        this.writer.print("  <uri2>");
        this.writer.print(alignment.getOntology2URI().toString());
        this.writer.print("</uri2>\n");
        Parameters parameters = alignment.getExtensions();
        Enumeration enumeration = parameters.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.writer.println("  <" + string + ">" + parameters.getParameter(string) + "</" + string + ">");
        }
        this.writer.println("</Alignment>");
    }

    public void visit(Cell cell) {
    }

    public void visit(Relation relation) {
    }
}

