/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.impl.renderer;

import fr.inrialpes.exmo.align.impl.rel.EquivRelation;
import fr.inrialpes.exmo.align.impl.rel.IncompatRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumeRelation;
import fr.inrialpes.exmo.align.impl.rel.SubsumedRelation;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Relation;

public class XSLTRendererVisitor
implements AlignmentVisitor {
    PrintWriter writer = null;
    Alignment alignment = null;
    Cell cell = null;
    Hashtable namespaces = null;
    int nsrank = 0;

    public XSLTRendererVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
        this.namespaces = new Hashtable();
        this.namespaces.put("http://www.w3.org/1999/XSL/Transform", "xsl");
        this.namespaces.put("http://www.w3.org/2002/07/owl#", "owl");
        this.namespaces.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "rdf");
        this.namespaces.put("http://www.w3.org/2000/01/rdf-schema#", "rdfs");
    }

    public void visit(Alignment alignment) throws AlignmentException {
        Object object;
        Enumeration enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            this.collectURIs((Cell)enumeration.nextElement());
        }
        this.alignment = alignment;
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.println("<xsl:stylesheet version=\"1.0\"");
        enumeration = this.namespaces.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            this.writer.println("    xmlns:" + this.namespaces.get(object) + "=\"" + object + "\"");
        }
        this.writer.println("  >\n");
        enumeration = alignment.getElements();
        while (enumeration.hasMoreElements()) {
            object = (Cell)enumeration.nextElement();
            object.accept((AlignmentVisitor)this);
        }
        this.writer.println("  <!-- Copying the root -->");
        this.writer.println("  <xsl:template match=\"/\">");
        this.writer.println("    <xsl:apply-templates/>");
        this.writer.println("  </xsl:template>");
        this.writer.println("");
        this.writer.println("  <!-- Copying all elements and attributes -->");
        this.writer.println("  <xsl:template match=\"*|@*|text()\">");
        this.writer.println("    <xsl:copy>");
        this.writer.println("      <xsl:apply-templates select=\"*|@*|text()\"/>");
        this.writer.println("    </xsl:copy>");
        this.writer.println("  </xsl:template>");
        this.writer.println("");
        this.writer.print("</xsl:stylesheet>\n");
    }

    public void visit(Cell cell) throws AlignmentException {
        this.cell = cell;
        cell.getRelation().accept((AlignmentVisitor)this);
    }

    private void collectURIs(Cell cell) throws AlignmentException {
        String string;
        URI uRI = cell.getObject1AsURI();
        URI uRI2 = cell.getObject2AsURI();
        if (uRI != null && this.namespaces.get(string = uRI.getScheme() + ":" + uRI.getSchemeSpecificPart() + "#") == null) {
            this.namespaces.put(string, "ns" + this.nsrank++);
        }
        if (uRI2 != null && this.namespaces.get(string = uRI2.getScheme() + ":" + uRI2.getSchemeSpecificPart() + "#") == null) {
            this.namespaces.put(string, "ns" + this.nsrank++);
        }
    }

    public void visit(EquivRelation equivRelation) throws AlignmentException {
        this.writer.println("  <xsl:template match=\"" + this.namespacify(this.cell.getObject1AsURI()) + "\">");
        this.writer.println("    <xsl:element name=\"" + this.namespacify(this.cell.getObject2AsURI()) + "\">");
        this.writer.println("      <xsl:apply-templates select=\"*|@*|text()\"/>");
        this.writer.println("    </xsl:element>");
        this.writer.println("  </xsl:template>\n");
    }

    private String namespacify(URI uRI) {
        String string = uRI.getScheme() + ":" + uRI.getSchemeSpecificPart() + "#";
        return this.namespaces.get(string) + ":" + uRI.getFragment();
    }

    public void visit(SubsumeRelation subsumeRelation) {
    }

    public void visit(SubsumedRelation subsumedRelation) {
    }

    public void visit(IncompatRelation incompatRelation) {
    }

    public void visit(Relation relation) throws AlignmentException {
        try {
            Method method = null;
            if (Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.EquivRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumeRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.SubsumedRelation"));
            } else if (Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation").isInstance(relation)) {
                method = this.getClass().getMethod("visit", Class.forName("fr.inrialpes.exmo.align.impl.rel.IncompatRelation"));
            }
            if (method != null) {
                method.invoke((Object)this, relation);
            }
        }
        catch (Exception exception) {
            throw new AlignmentException("Dispatching problem ", exception);
        }
    }
}

