/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.parser;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.Cell;
import org.semanticweb.owl.align.Parameters;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AlignmentParser
extends DefaultHandler {
    protected int debugMode = 0;
    protected String uri = null;
    Object onto1 = null;
    Object onto2 = null;
    protected URIAlignment alignment = null;
    protected String content = null;
    protected Object cl1 = null;
    protected Object cl2 = null;
    protected Cell cell = null;
    protected String relation = null;
    protected String id = null;
    protected String sem = null;
    protected Parameters extensions = null;
    protected String measure = null;
    protected SAXParser parser = null;
    protected int parselevel = 0;

    public AlignmentParser(int n) throws ParserConfigurationException, SAXException {
        this.debugMode = n;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        if (n > 0) {
            sAXParserFactory.setValidating(true);
        } else {
            sAXParserFactory.setValidating(false);
        }
        sAXParserFactory.setNamespaceAware(true);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public Alignment parse(String string, Hashtable hashtable) throws SAXException, IOException {
        return this.parse(string);
    }

    public Alignment parse(String string) throws SAXException, IOException {
        this.uri = string;
        this.parser.parse(string, (DefaultHandler)this);
        return this.alignment;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.debugMode > 2) {
            System.err.println("startElement AlignmentParser : " + string2);
        }
        ++this.parselevel;
        if (string.equals("http://knowledgeweb.semanticweb.org/heterogeneity/alignment")) {
            if (!(string2.equals("relation") || string2.equals("semantics") || string2.equals("measure"))) {
                if (string2.equals("entity2")) {
                    if (this.debugMode > 2) {
                        System.err.println(" resource = " + attributes.getValue("rdf:resource"));
                    }
                    try {
                        this.cl2 = new URI(attributes.getValue("rdf:resource"));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new SAXException("Malformed URI: " + attributes.getValue("rdf:resource"));
                    }
                } else if (string2.equals("entity1")) {
                    if (this.debugMode > 2) {
                        System.err.println(" resource = " + attributes.getValue("rdf:resource"));
                    }
                    try {
                        this.cl1 = new URI(attributes.getValue("rdf:resource"));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new SAXException("Malformed URI: " + attributes.getValue("rdf:resource"));
                    }
                } else if (string2.equals("Cell")) {
                    if (this.alignment == null) {
                        throw new SAXException("No alignment provided");
                    }
                    if (attributes.getValue("rdf:ID") != null) {
                        this.id = attributes.getValue("rdf:ID");
                    } else if (attributes.getValue("rdf:about") != null) {
                        this.id = attributes.getValue("rdf:about");
                    }
                    this.sem = null;
                    this.measure = null;
                    this.relation = null;
                    this.extensions = null;
                    this.cl1 = null;
                    this.cl2 = null;
                } else if (string2.equals("map")) {
                    try {
                        this.alignment.setOntology2(this.onto2);
                        this.alignment.setOntology1(this.onto1);
                    }
                    catch (AlignmentException alignmentException) {
                        throw new SAXException("Catched alignment exception", (Exception)((Object)alignmentException));
                    }
                } else if (!(string2.equals("onto2") || string2.equals("onto1") || string2.equals("uri2") || string2.equals("uri1") || string2.equals("type") || string2.equals("level") || string2.equals("xml"))) {
                    if (string2.equals("Alignment")) {
                        this.alignment = new URIAlignment();
                    } else if (this.debugMode > 0) {
                        System.err.println("[AlignmentParser] Unknown element name : " + string2);
                    }
                }
            }
        } else if (string.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            if (!string2.equals("RDF")) {
                throw new SAXException("[AlignmentParser] unknown element name: " + string2);
            }
        } else if (this.parselevel != 2) {
            throw new SAXException("[AlignmentParser] Unknown namespace : " + string);
        }
    }

    private Object getEntity(Object object, String string) throws SAXException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SAXException("[AlignmentParser] bad URI syntax : " + string);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.content = new String(cArray, n, n2);
        if (this.debugMode > 2) {
            System.err.println("content AlignmentParser : " + this.content);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endElement(String var1_1, String var2_2, String var3_3) throws SAXException {
        if (this.debugMode > 2) {
            System.err.println("endElement AlignmentParser : " + var2_2);
        }
        if (var1_1.equals("http://knowledgeweb.semanticweb.org/heterogeneity/alignment")) {
            try {
                if (var2_2.equals("relation")) {
                    this.relation = this.content;
                }
                if (var2_2.equals("measure")) {
                    this.measure = this.content;
                }
                if (var2_2.equals("semantics")) {
                    this.sem = this.content;
                }
                if (var2_2.equals("entity2") || var2_2.equals("entity1")) ** GOTO lbl89
                if (var2_2.equals("Cell")) {
                    if (this.debugMode > 1) {
                        System.err.print(" " + this.cl1);
                        System.err.print(" " + this.cl2);
                        System.err.print(" " + this.relation);
                        System.err.println(" " + Double.parseDouble(this.measure));
                    }
                    if (this.cl1 == null || this.cl2 == null) {
                        System.err.println("Warning (cell voided), missing entity " + this.cl1 + " " + this.cl2);
                    } else {
                        this.cell = this.measure == null || this.relation == null ? this.alignment.addAlignCell(this.cl1, this.cl2) : this.alignment.addAlignCell(this.cl1, this.cl2, this.relation, Double.parseDouble(this.measure));
                    }
                    if (this.id != null) {
                        this.cell.setId(this.id);
                    }
                    if (this.sem != null) {
                        this.cell.setSemantics(this.sem);
                    }
                    if (this.extensions == null) ** GOTO lbl89
                    this.cell.setExtensions(this.extensions);
                }
                if (var2_2.equals("map")) ** GOTO lbl89
                if (var2_2.equals("uri1")) {
                    try {
                        this.onto1 = new URI(this.content);
                    }
                    catch (URISyntaxException var4_4) {
                        throw new SAXException("uri1: malformed URI");
                    }
                }
                if (var2_2.equals("uri2")) {
                    try {
                        this.onto2 = new URI(this.content);
                    }
                    catch (URISyntaxException var4_5) {
                        throw new SAXException("uri2: malformed URI");
                    }
                }
                if (var2_2.equals("onto2")) {
                    try {
                        this.alignment.setFile2(new URI(this.content));
                    }
                    catch (URISyntaxException var4_6) {
                        throw new SAXException("onto2: malformed URI");
                    }
                }
                if (var2_2.equals("onto1")) {
                    try {
                        this.alignment.setFile1(new URI(this.content));
                    }
                    catch (URISyntaxException var4_7) {
                        throw new SAXException("onto1: malformed URI");
                    }
                }
                if (var2_2.equals("type")) {
                    this.alignment.setType(this.content);
                }
                if (var2_2.equals("level")) {
                    this.alignment.setLevel(this.content);
                }
                if (var2_2.equals("xml") || var2_2.equals("Alignment")) ** GOTO lbl89
                if (this.parselevel == 3) {
                    this.alignment.setExtension(var2_2, this.content);
                }
                if (this.parselevel == 5) {
                    if (this.extensions == null) {
                        this.extensions = new BasicParameters();
                    }
                    this.extensions.setParameter(var2_2, (Object)this.content);
                }
                System.err.println("[AlignmentParser] Unknown element name : " + var2_2);
            }
            catch (AlignmentException var4_8) {
                throw new SAXException("[AlignmentParser] OWLException raised");
            }
        } else if (var1_1.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            if (!var2_2.equals("RDF")) {
                throw new SAXException("[AlignmentParser] unknown element name: " + var2_2);
            }
        } else if (this.parselevel == 3) {
            this.alignment.setExtension(var2_2, this.content);
        } else if (this.parselevel == 5) {
            if (this.extensions == null) {
                this.extensions = new BasicParameters();
            }
            this.extensions.setParameter(var2_2, (Object)this.content);
        } else {
            throw new SAXException("[AlignmentParser] Unknown namespace : " + var1_1);
        }
lbl89:
        // 20 sources

        --this.parselevel;
    }
}

