/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.OntologyCache;
import fr.inrialpes.exmo.align.impl.eval.PRGraphEvaluator;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.Parameters;

public class GenPlot {
    int STEP = 10;
    Parameters params = null;
    Vector listAlgo;
    String fileNames = "";
    String outFile = null;
    String type = "tsv";
    int debug = 0;
    OntologyCache loaded = null;
    PrintWriter output = null;

    public static void main(String[] stringArray) {
        try {
            new GenPlot().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        LongOpt[] longOptArray = new LongOpt[8];
        this.loaded = new OntologyCache();
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[3] = new LongOpt("type", 1, null, 116);
        longOptArray[4] = new LongOpt("debug", 2, null, 100);
        longOptArray[6] = new LongOpt("list", 1, null, 108);
        Getopt getopt = new Getopt("", stringArray, "ho:d::l:t:", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.outFile = getopt.getOptarg();
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 108: {
                    this.fileNames = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string = getopt.getOptarg();
                    this.debug = string != null ? Integer.parseInt(string.trim()) : 4;
                }
            }
        }
        this.listAlgo = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(this.fileNames, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.listAlgo.add(stringTokenizer.nextToken());
        }
        this.params = new BasicParameters();
        if (this.debug > 0) {
            this.params.setParameter("debug", (Object)new Integer(this.debug - 1));
        }
        this.params.setParameter("step", (Object)new Integer(this.STEP));
        OutputStream outputStream = this.outFile == null ? System.out : new FileOutputStream(this.outFile);
        this.output = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), true);
        if (this.type.equals("tsv")) {
            this.printTSV(this.iterateDirectories());
        } else if (this.type.equals("tex")) {
            this.printPGFTex(this.iterateDirectories());
        } else {
            System.err.println("Flag -t " + this.type + " : not implemented yet");
        }
    }

    public double[][] iterateDirectories() {
        int n;
        int n2;
        File[] fileArray = null;
        try {
            fileArray = new File(System.getProperty("user.dir")).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        double[][] dArray = new double[this.listAlgo.size()][this.STEP + 1];
        for (n2 = 0; n2 < this.listAlgo.size(); ++n2) {
            for (n = 0; n <= this.STEP; ++n) {
                dArray[n2][n] = 0.0;
            }
        }
        n2 = 0;
        for (n = fileArray.length - 1; n >= 0; --n) {
            if (!fileArray[n].isDirectory()) continue;
            this.iterateAlignments(fileArray[n], dArray);
            ++n2;
        }
        for (n = 0; n < this.listAlgo.size(); ++n) {
            for (int i = 0; i <= this.STEP; ++i) {
                dArray[n][i] = dArray[n][i] / (double)n2;
            }
        }
        return dArray;
    }

    public void iterateAlignments(File file, double[][] dArray) {
        String string = file.toURI().toString() + "/";
        int n = 0;
        if (this.debug > 0) {
            System.err.println("Directory : " + file);
        }
        Enumeration enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            PRGraphEvaluator pRGraphEvaluator;
            String string2 = (String)enumeration.nextElement();
            if (this.debug > 0) {
                System.err.println("  Considering result " + string2 + " (" + n + ")");
            }
            if ((pRGraphEvaluator = this.eval(string + "refalign.rdf", string + string2 + ".rdf")) != null) {
                for (int i = 0; i <= this.STEP; ++i) {
                    dArray[n][i] = dArray[n][i] + pRGraphEvaluator.getPrecision(i);
                }
            }
            ++n;
        }
        this.loaded.clear();
    }

    public PRGraphEvaluator eval(String string, String string2) {
        PRGraphEvaluator pRGraphEvaluator = null;
        try {
            int n = this.debug < 2 ? 0 : this.debug - 2;
            AlignmentParser alignmentParser = new AlignmentParser(n);
            Alignment alignment = alignmentParser.parse(string);
            if (this.debug > 1) {
                System.err.println(" Alignment structure1 parsed");
            }
            AlignmentParser alignmentParser2 = new AlignmentParser(n);
            Alignment alignment2 = alignmentParser2.parse(string2);
            if (this.debug > 1) {
                System.err.println(" Alignment structure2 parsed");
            }
            pRGraphEvaluator = new PRGraphEvaluator(alignment, alignment2);
            this.params.setParameter("debug", (Object)new Integer(n));
            pRGraphEvaluator.eval(this.params, this.loaded);
            this.loaded.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pRGraphEvaluator;
    }

    public void printPGFTex(double[][] dArray) {
        int n = 0;
        String[] stringArray = new String[]{"+", "*", "x", "-", "|", "o", "asterisk", "star", "oplus", "oplus*", "otimes", "otimes*", "square", "square*", "triangle", "triangle*", "diamond", "diamond*", "pentagon", "pentagon*"};
        String[] stringArray2 = new String[]{"black", "red", "green", "blue", "cyan", "magenta", "yellow"};
        this.output.println("\\documentclass[11pt]{book}");
        this.output.println();
        this.output.println("\\usepackage{pgf}");
        this.output.println("\\usepackage{tikz}");
        this.output.println("\\usepackage{pgflibraryplotmarks}");
        this.output.println();
        this.output.println("\\begin{document}");
        this.output.println("\\date{today}");
        this.output.println("");
        this.output.println("\n%% Plot generated by GenPlot of alignapi");
        this.output.println("\\begin{tikzpicture}[cap=round]");
        this.output.println("% Draw grid");
        this.output.println("\\draw[step=" + this.STEP / 10 + "cm,very thin,color=gray] (-0.2,-0.2) grid (" + this.STEP + "," + this.STEP + ");");
        this.output.println("\\draw[->] (-0.2,0) -- (10.2,0);");
        this.output.println("\\draw (5,-0.3) node {$recall$}; ");
        this.output.println("\\draw (0,-0.3) node {0.}; ");
        this.output.println("\\draw (10,-0.3) node {1.}; ");
        this.output.println("\\draw[->] (0,-0.2) -- (0,10.2);");
        this.output.println("\\draw (-0.3,0) node {0.}; ");
        this.output.println("\\draw (-0.3,5) node[rotate=90] {$precision$}; ");
        this.output.println("\\draw (-0.3,10) node {1.}; ");
        this.output.println("% Plots");
        Enumeration enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            this.output.println("\\draw[" + stringArray2[n % 7] + "] plot[mark=" + stringArray[n % 19] + ",smooth] file {" + (String)enumeration.nextElement() + ".table};");
            ++n;
        }
        this.output.println("% Legend");
        n = 0;
        enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            this.output.println("\\draw[" + stringArray2[n % 7] + "] plot[mark=" + stringArray[n % 19] + ",smooth] coordinates {(" + (n % 3 * 3 + 1) + "," + ((double)(-(n / 3)) * 0.8 - 1.0) + ") (" + (n % 3 * 3 + 3) + "," + ((double)(-(n / 3)) * 0.8 - 1.0) + ")};");
            this.output.println("\\draw[" + stringArray2[n % 7] + "] (" + (n % 3 * 3 + 2) + "," + ((double)(-(n / 3)) * 0.8 - 0.8) + ") node {" + (String)enumeration.nextElement() + "};");
            ++n;
        }
        this.output.println("\\end{tikzpicture}");
        this.output.println();
        this.output.println("\\end{document}");
        n = 0;
        enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                PrintWriter printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string + ".table"), "UTF-8")), true);
                printWriter.println("#Curve 0, " + (this.STEP + 1) + " points");
                printWriter.println("#x y type");
                printWriter.println("%% Plot generated by GenPlot of alignapi");
                printWriter.println("%% Include in PGF tex by:\n");
                printWriter.println("%% \\begin{tikzpicture}[cap=round]");
                printWriter.println("%% \\draw[step=" + this.STEP / 10 + "cm,very thin,color=gray] (-0.2,-0.2) grid (" + this.STEP + "," + this.STEP + ");");
                printWriter.println("%% \\draw[->] (-0.2,0) -- (10.2,0) node[right] {$recall$}; ");
                printWriter.println("%% \\draw[->] (0,-0.2) -- (0,10.2) node[above] {$precision$}; ");
                printWriter.println("%% \\draw plot[mark=+,smooth] file {" + string + ".table};");
                printWriter.println("%% \\end{tikzpicture}");
                printWriter.println();
                for (int i = 0; i <= this.STEP; ++i) {
                    printWriter.print((double)i * 10.0 / (double)this.STEP);
                    printWriter.println(" " + dArray[n][i] * 10.0);
                }
                printWriter.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n;
        }
    }

    public void printTSV(double[][] dArray) {
        Enumeration enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            this.output.print("\t" + (String)enumeration.nextElement());
        }
        this.output.println();
        for (int i = 0; i <= this.STEP; ++i) {
            this.output.print((double)i / (double)this.STEP);
            for (int j = 0; j < this.listAlgo.size(); ++j) {
                this.output.print("\t" + dArray[j][i]);
            }
            this.output.println();
        }
    }

    public void usage() {
        System.out.println("usage: GenPlot [options]");
        System.out.println("options are:");
        System.out.println("\t--type=tsv|tex|(html|xml) -t tsv|tex|(html|xml)\tSpecifies the output format");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
    }
}

