/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.BasicParameters;
import fr.inrialpes.exmo.align.impl.OntologyCache;
import fr.inrialpes.exmo.align.impl.eval.PRecEvaluator;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.Evaluator;
import org.semanticweb.owl.align.Parameters;

public class GenTriangle {
    Parameters params = null;
    String filename = null;
    String reference = "refalign.rdf";
    String format = "pr";
    int fsize = 2;
    String type = "html";
    boolean embedded = false;
    String dominant = "s";
    Vector listAlgo = null;
    int debug = 0;
    String color = null;
    OntologyCache loaded = null;
    String ontoDir = null;

    public static void main(String[] stringArray) {
        try {
            new GenTriangle().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        String string = "";
        LongOpt[] longOptArray = new LongOpt[10];
        this.loaded = new OntologyCache();
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[2] = new LongOpt("format", 1, null, 102);
        longOptArray[3] = new LongOpt("type", 1, null, 116);
        longOptArray[4] = new LongOpt("debug", 2, null, 100);
        longOptArray[5] = new LongOpt("sup", 1, null, 115);
        longOptArray[6] = new LongOpt("list", 1, null, 108);
        longOptArray[7] = new LongOpt("color", 2, null, 99);
        longOptArray[8] = new LongOpt("reference", 1, null, 114);
        longOptArray[9] = new LongOpt("directory", 1, null, 119);
        Getopt getopt = new Getopt("", stringArray, "ho:a:d::l:f:t:r:w:c::", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 111: {
                    this.filename = getopt.getOptarg();
                    break;
                }
                case 114: {
                    this.reference = getopt.getOptarg();
                    break;
                }
                case 102: {
                    this.format = getopt.getOptarg();
                    break;
                }
                case 116: {
                    this.type = getopt.getOptarg();
                    break;
                }
                case 115: {
                    this.dominant = getopt.getOptarg();
                    break;
                }
                case 99: {
                    String string2 = getopt.getOptarg();
                    if (string2 != null) {
                        this.color = string2.trim();
                        break;
                    }
                    this.color = "lightblue";
                    break;
                }
                case 108: {
                    string = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string2 = getopt.getOptarg();
                    if (string2 != null) {
                        this.debug = Integer.parseInt(string2.trim());
                        break;
                    }
                    this.debug = 4;
                    break;
                }
                case 119: {
                    String string2 = getopt.getOptarg();
                    this.ontoDir = string2 != null ? getopt.getOptarg() : null;
                }
            }
        }
        this.listAlgo = new Vector();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            this.listAlgo.add(stringTokenizer.nextToken());
        }
        this.params = new BasicParameters();
        if (this.debug > 0) {
            this.params.setParameter("debug", (Object)new Integer(this.debug - 1));
        }
        this.print(this.iterateDirectories());
    }

    public Vector iterateDirectories() {
        Vector<Vector> vector = null;
        File[] fileArray = null;
        try {
            fileArray = this.ontoDir == null ? new File(System.getProperty("user.dir")).listFiles() : new File(this.ontoDir).listFiles();
        }
        catch (Exception exception) {
            System.err.println("Cannot stat dir " + exception.getMessage());
            this.usage();
        }
        int n = fileArray.length;
        vector = new Vector<Vector>(n);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Vector vector2;
            if (!fileArray[i].isDirectory()) continue;
            if (this.debug > 0) {
                System.err.println("\nEntering directory " + fileArray[i]);
            }
            if ((vector2 = this.iterateAlignments(fileArray[i])) == null) continue;
            vector.add(n2, vector2);
            ++n2;
        }
        return vector;
    }

    public Vector iterateAlignments(File file) {
        String string = file.toURI().toString() + "/";
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        vector.add(0, file.getName().toString());
        int n = 1;
        Enumeration enumeration = this.listAlgo.elements();
        while (enumeration.hasMoreElements()) {
            Evaluator evaluator;
            if (this.debug > 2) {
                System.err.println("  Considering result " + n);
            }
            if ((evaluator = this.eval(string + this.reference, string + (String)enumeration.nextElement() + ".rdf")) != null) {
                bl = true;
            }
            vector.add(n, (String)evaluator);
            ++n;
        }
        this.loaded.clear();
        if (bl) {
            return vector;
        }
        return null;
    }

    public Evaluator eval(String string, String string2) {
        PRecEvaluator pRecEvaluator = null;
        try {
            int n = this.debug < 2 ? 0 : this.debug - 2;
            AlignmentParser alignmentParser = new AlignmentParser(n);
            Alignment alignment = alignmentParser.parse(string);
            if (this.debug > 2) {
                System.err.println(" Alignment structure1 parsed");
            }
            AlignmentParser alignmentParser2 = new AlignmentParser(n);
            Alignment alignment2 = alignmentParser2.parse(string2);
            if (this.debug > 2) {
                System.err.println(" Alignment structure2 parsed");
            }
            pRecEvaluator = new PRecEvaluator(alignment, alignment2);
            this.params.setParameter("debug", (Object)new Integer(n));
            pRecEvaluator.eval(this.params, this.loaded);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return pRecEvaluator;
    }

    public void print(Vector vector) {
        if (this.type.equals("html")) {
            this.printHTML(vector);
        } else if (this.type.equals("tex")) {
            this.printLATEX(vector);
        }
    }

    public void printLATEX(Vector vector) {
    }

    public void printHTML(Vector vector) {
        int n = 0;
        PrintStream printStream = null;
        this.fsize = this.format.length();
        try {
            int n2;
            printStream = this.filename == null ? System.out : new PrintStream(new FileOutputStream(this.filename));
            if (!this.embedded) {
                printStream.println("<html><head></head><body>");
            }
            printStream.println("<table border='2' frame='sides' rules='groups'>");
            printStream.println("<colgroup align='center' />");
            Enumeration enumeration = this.listAlgo.elements();
            while (enumeration.hasMoreElements()) {
                printStream.println("<colgroup align='center' span='" + this.fsize + "' />");
                enumeration.nextElement();
            }
            printStream.println("<thead valign='top'><tr><th>algo</th>");
            enumeration = this.listAlgo.elements();
            while (enumeration.hasMoreElements()) {
                printStream.println("<th colspan='" + this.fsize + "'>" + (String)enumeration.nextElement() + "</th>");
            }
            printStream.println("</tr></thead><tbody><tr><td>test</td>");
            enumeration = this.listAlgo.elements();
            while (enumeration.hasMoreElements()) {
                for (int i = 0; i < this.fsize; ++i) {
                    printStream.print("<td>");
                    if (this.format.charAt(i) == 'p') {
                        printStream.print("Prec.");
                    } else if (this.format.charAt(i) == 'r') {
                        printStream.print("Rec.");
                    } else if (this.format.charAt(i) == 'f') {
                        printStream.print("Fall.");
                    } else if (this.format.charAt(i) == 'm') {
                        printStream.print("FMeas.");
                    } else if (this.format.charAt(i) == 'o') {
                        printStream.print("Over.");
                    } else if (this.format.charAt(i) == 't') {
                        printStream.print("Time");
                    }
                    printStream.println("</td>");
                }
                enumeration.nextElement();
            }
            printStream.println("</tr></tbody><tbody>");
            int[] nArray = new int[this.listAlgo.size()];
            int[] nArray2 = new int[this.listAlgo.size()];
            long[] lArray = new long[this.listAlgo.size()];
            double[] dArray = new double[this.listAlgo.size()];
            double[] dArray2 = new double[this.listAlgo.size()];
            for (n2 = this.listAlgo.size() - 1; n2 >= 0; --n2) {
                nArray[n2] = 0;
                nArray2[n2] = 0;
                lArray[n2] = 0L;
                dArray[n2] = 1.0;
                dArray2[n2] = 1.0;
            }
            n2 = 0;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                int n3 = -1;
                int n4 = 0;
                Vector vector2 = (Vector)enumeration2.nextElement();
                if (n2 == 1 && this.color != null) {
                    n2 = 0;
                    printStream.println("<tr bgcolor=\"" + this.color + "\">");
                } else {
                    n2 = 1;
                    printStream.println("<tr>");
                }
                printStream.println("<td>" + (String)vector2.get(0) + "</td>");
                Enumeration enumeration3 = vector2.elements();
                enumeration3.nextElement();
                int n5 = 0;
                while (enumeration3.hasMoreElements()) {
                    PRecEvaluator pRecEvaluator = (PRecEvaluator)enumeration3.nextElement();
                    if (pRecEvaluator != null) {
                        if (n3 == -1) {
                            n3 = pRecEvaluator.getExpected();
                            n4 = n;
                            n = n4 + n3;
                        }
                        int n6 = pRecEvaluator.getFound();
                        int n7 = nArray[n5];
                        nArray[n5] = n7 + n6;
                        int n8 = pRecEvaluator.getCorrect();
                        int n9 = nArray2[n5];
                        nArray2[n5] = n9 + n8;
                        int n10 = n5;
                        lArray[n10] = lArray[n10] + pRecEvaluator.getTime();
                        for (int i = 0; i < this.fsize; ++i) {
                            printStream.print("<td>");
                            if (this.format.charAt(i) == 'p') {
                                this.printFormat(printStream, pRecEvaluator.getPrecision());
                            } else if (this.format.charAt(i) == 'r') {
                                this.printFormat(printStream, pRecEvaluator.getRecall());
                            } else if (this.format.charAt(i) == 'f') {
                                this.printFormat(printStream, pRecEvaluator.getFallout());
                            } else if (this.format.charAt(i) == 'm') {
                                this.printFormat(printStream, pRecEvaluator.getFmeasure());
                            } else if (this.format.charAt(i) == 'o') {
                                this.printFormat(printStream, pRecEvaluator.getOverall());
                            } else if (this.format.charAt(i) == 't') {
                                if (pRecEvaluator.getTime() == 0L) {
                                    printStream.print("-");
                                } else {
                                    this.printFormat(printStream, pRecEvaluator.getTime());
                                }
                            }
                            printStream.println("</td>");
                        }
                    } else {
                        printStream.println("<td>n/a</td><td>n/a</td>");
                    }
                    ++n5;
                }
                printStream.println("</tr>");
            }
            printStream.print("<tr bgcolor=\"yellow\"><td>H-mean</td>");
            int n11 = 0;
            Enumeration enumeration4 = this.listAlgo.elements();
            while (enumeration4.hasMoreElements()) {
                enumeration4.nextElement();
                double d = (double)nArray2[n11] / (double)nArray[n11];
                double d2 = (double)nArray2[n11] / (double)n;
                for (int i = 0; i < this.fsize; ++i) {
                    printStream.print("<td>");
                    if (this.format.charAt(i) == 'p') {
                        this.printFormat(printStream, d);
                    } else if (this.format.charAt(i) == 'r') {
                        this.printFormat(printStream, d2);
                    } else if (this.format.charAt(i) == 'f') {
                        this.printFormat(printStream, (double)(nArray[n11] - nArray2[n11]) / (double)nArray[n11]);
                    } else if (this.format.charAt(i) == 'm') {
                        this.printFormat(printStream, 2.0 * d * d2 / (d + d2));
                    } else if (this.format.charAt(i) == 'o') {
                        this.printFormat(printStream, d2 * (2.0 - 1.0 / d));
                    } else if (this.format.charAt(i) == 't') {
                        if (lArray[n11] == 0L) {
                            printStream.print("-");
                        } else {
                            this.printFormat(printStream, lArray[n11]);
                        }
                    }
                    printStream.println("</td>");
                }
                ++n11;
            }
            printStream.println("</tr>");
            printStream.println("</tbody></table>");
            if (!this.embedded) {
                printStream.println("</body></html>");
            }
            printStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void printFormat(PrintStream printStream, double d) {
        if (d != d) {
            printStream.print("NaN");
        } else {
            int n = (int)(d * 100.0);
            int n2 = n % 100;
            if ((int)(d * 1000.0) % 10 >= 5) {
                ++n2;
            }
            printStream.print("" + (n /= 100) + ".");
            if (n2 < 10) {
                printStream.print("0");
            }
            printStream.print("" + n2);
        }
    }

    public void usage() {
        System.out.println("usage: GroupEval [options]");
        System.out.println("options are:");
        System.out.println("\t--format=prfmot -r prfmot\tSpecifies the output order (precision/recall/fallout/f-measure/overall/time)");
        System.out.println("\t--output=filename -o filename\tSpecifies a file to which the output will go");
        System.out.println("\t--reference=filename -r filename\tSpecifies the name of the reference alignment file (default: refalign.rdf)");
        System.out.println("\t--type=html|xml|tex|ascii -t html|xml|tex|ascii\tSpecifies the output format");
        System.out.println("\t--list=algo1,...,algon -l algo1,...,algon\tSequence of the filenames to consider");
        System.out.println("\t--color=color -c color\tSpecifies if the output must color even lines of the output");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level n");
        System.out.println("\t--help -h\t\t\tPrint this message");
    }
}

