/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.exmo.align.util;

import fr.inrialpes.exmo.align.impl.OWLAPIAlignment;
import fr.inrialpes.exmo.align.impl.URIAlignment;
import fr.inrialpes.exmo.align.impl.renderer.RDFRendererVisitor;
import fr.inrialpes.exmo.align.parser.AlignmentParser;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.semanticweb.owl.align.Alignment;
import org.semanticweb.owl.align.AlignmentException;
import org.semanticweb.owl.align.AlignmentVisitor;

public class ParserPrinter {
    public static void main(String[] stringArray) {
        try {
            new ParserPrinter().run(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void run(String[] stringArray) throws Exception {
        int n;
        Alignment alignment = null;
        String string = null;
        String string2 = null;
        PrintWriter printWriter = null;
        RDFRendererVisitor rDFRendererVisitor = null;
        LongOpt[] longOptArray = new LongOpt[7];
        int n2 = 0;
        String string3 = null;
        boolean bl = false;
        double d = 0.0;
        String string4 = "hard";
        longOptArray[0] = new LongOpt("help", 0, null, 104);
        longOptArray[1] = new LongOpt("output", 1, null, 111);
        longOptArray[2] = new LongOpt("debug", 2, null, 100);
        longOptArray[3] = new LongOpt("renderer", 1, null, 114);
        longOptArray[4] = new LongOpt("inverse", 0, null, 105);
        longOptArray[5] = new LongOpt("threshold", 1, null, 116);
        longOptArray[6] = new LongOpt("cutmethod", 1, null, 84);
        Getopt getopt = new Getopt("", stringArray, "hio:t:T:d::r:", longOptArray);
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 104: {
                    this.usage();
                    return;
                }
                case 105: {
                    bl = true;
                    break;
                }
                case 111: {
                    string2 = getopt.getOptarg();
                    break;
                }
                case 114: {
                    string3 = getopt.getOptarg();
                    break;
                }
                case 116: {
                    d = Double.parseDouble(getopt.getOptarg());
                    break;
                }
                case 84: {
                    string4 = getopt.getOptarg();
                    break;
                }
                case 100: {
                    String string5 = getopt.getOptarg();
                    n2 = string5 != null ? Integer.parseInt(string5.trim()) : 4;
                }
            }
        }
        int n3 = getopt.getOptind();
        if (stringArray.length <= n3) {
            System.out.println("Require the alignement filename");
            this.usage();
            return;
        }
        string = stringArray[n3];
        if (n2 > 1) {
            System.err.println(" Filename" + string);
        }
        try {
            AlignmentParser alignmentParser = new AlignmentParser(n2);
            alignment = alignmentParser.parse(string);
            if (n2 > 0) {
                System.err.println(" Alignment structure parsed");
            }
            OutputStream outputStream = string2 == null ? System.out : new FileOutputStream(string2);
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8")), true);
            if (bl) {
                alignment = alignment.inverse();
            }
            if (d != 0.0) {
                alignment.cut(string4, d);
            }
            if (string3 == null) {
                rDFRendererVisitor = new RDFRendererVisitor(printWriter);
            } else {
                try {
                    Object[] objectArray = new Object[]{printWriter};
                    Constructor<?>[] constructorArray = Class.forName(string3).getConstructors();
                    rDFRendererVisitor = (AlignmentVisitor)constructorArray[0].newInstance(objectArray);
                }
                catch (Exception exception) {
                    System.err.println("Cannot create renderer " + string3 + "\n" + exception.getMessage());
                    this.usage();
                    return;
                }
            }
            try {
                alignment.render((AlignmentVisitor)rDFRendererVisitor);
            }
            catch (AlignmentException alignmentException) {
                alignment = OWLAPIAlignment.toOWLAPIAlignment((URIAlignment)alignment, null);
                alignment.render((AlignmentVisitor)rDFRendererVisitor);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void usage() {
        System.out.println("usage: ParserPrinter [options] URI");
        System.out.println("options are:");
        System.out.println("\t--debug[=n] -d [n]\t\tReport debug info at level ,");
        System.out.println("\t--renderer=className -r\t\tUse the given class for output.");
        System.out.println("\t--inverse -i\t\tInverse first and second ontology");
        System.out.println("\t--output=filename -o filename\tOutput the alignment in filename");
        System.out.println("\t--help -h\t\t\tPrint this message");
    }
}

