/*
 * Decompiled with CFR 0.152.
 */
package com.lre.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    public static final long ONE_YEAR = 31449600000L;

    public static String getRandomString() {
        return Util.getRandomString(15);
    }

    public static String getRandomString(int numChars) {
        Random r = new Random(System.currentTimeMillis());
        int chars = r.nextInt(numChars);
        while (chars == 0) {
            chars = r.nextInt(numChars);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < chars; ++i) {
            int index = 97 + r.nextInt(26);
            char c = (char)index;
            sb.append(c);
        }
        return sb.toString();
    }

    public static Hashtable mergeHashtables(Hashtable one, Hashtable two) {
        Hashtable newHash = (Hashtable)one.clone();
        Enumeration e = two.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (newHash.containsKey(key)) continue;
            newHash.put(key, two.get(key));
        }
        return newHash;
    }

    public static boolean isInArray(String elem, String[] array) {
        if (elem == null || array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(elem)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInArray(int elem, int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != elem) continue;
            return true;
        }
        return false;
    }

    public static int[] addToIntArray(int elem, int[] intList) {
        int[] temp = null;
        if (intList == null) {
            temp = new int[]{elem};
        } else {
            temp = new int[intList.length + 1];
            System.arraycopy(intList, 0, temp, 0, intList.length);
            temp[intList.length] = elem;
        }
        return temp;
    }

    public static Object[] addToObjectArray(Object elem, Object[] arr) {
        Object[] temp = null;
        if (arr == null) {
            temp = new Object[]{elem};
        } else {
            temp = new Object[arr.length + 1];
            System.arraycopy(arr, 0, temp, 0, arr.length);
            temp[arr.length] = elem;
        }
        return temp;
    }

    public static String[] addToStringArray(String elem, String[] arr) {
        String[] temp = null;
        if (arr == null) {
            temp = new String[]{elem};
        } else {
            temp = new String[arr.length + 1];
            System.arraycopy(arr, 0, temp, 0, arr.length);
            temp[arr.length] = elem;
        }
        return temp;
    }

    public static Class[] addToClassArray(Class elem, Class[] arr) {
        Class[] temp = null;
        if (arr == null) {
            temp = new Class[]{elem};
        } else {
            temp = new Class[arr.length + 1];
            System.arraycopy(arr, 0, temp, 0, arr.length);
            temp[arr.length] = elem;
        }
        return temp;
    }

    public static int[] readDelimitedIntegers(String str, String delims) throws NumberFormatException {
        int[] intList = null;
        if (str == null || str.equals("")) {
            return new int[0];
        }
        StringTokenizer toke = new StringTokenizer(str, delims);
        while (toke.hasMoreTokens()) {
            String num = toke.nextToken();
            int col = -1;
            try {
                if (num.indexOf("-") != -1) {
                    StringTokenizer st = new StringTokenizer(num, "-");
                    int startInt = Integer.parseInt(st.nextToken());
                    int endInt = Integer.parseInt(st.nextToken());
                    for (int i = startInt; i <= endInt; ++i) {
                        intList = Util.addToIntArray(i, intList);
                    }
                    continue;
                }
                col = Integer.parseInt(num);
                intList = Util.addToIntArray(col, intList);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Invalid format in exclude param.  Type \"int,int ... \" expected.");
                throw nfe;
            }
        }
        return intList;
    }

    public static Hashtable invertHashtable(Hashtable h) {
        Enumeration e = h.keys();
        Hashtable hash = new Hashtable();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            hash.put(h.get(key), key);
        }
        return hash;
    }

    public static String replace(String host, String oldchar, String newchar) {
        int index = 0;
        while (host.indexOf(oldchar, index) != -1) {
            index = host.indexOf(oldchar, index);
            host = host.substring(0, index) + newchar + host.substring(index + oldchar.length(), host.length());
            index += newchar.length();
        }
        return host;
    }

    public static void printHashtable(Hashtable h) {
        Util.printHashtable(h, System.out);
    }

    public static void printHashtable(Hashtable h, PrintStream out) {
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String value = h.get(key).toString();
            out.println(key + " ==> " + value);
        }
    }

    public static void printVector(Vector v) {
        Util.printVector(v, System.out);
    }

    public static void printVector(Vector v, PrintStream out) {
        for (int i = 0; i < v.size(); ++i) {
            out.println(v.elementAt(i));
        }
    }

    public static String getFileAsString(String fn) throws IOException, FileNotFoundException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuffer theFile = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            theFile.append(line + "\n");
            line = reader.readLine();
        }
        reader.close();
        return theFile.toString();
    }

    public static void saveStringToFile(String toSave, String fn) throws IOException, FileNotFoundException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fn)));
        StringTokenizer st = new StringTokenizer(toSave, "\n", true);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                writer.newLine();
                continue;
            }
            writer.write(s);
        }
        writer.flush();
        writer.close();
    }

    public static String getURLAsString(URL theURL) throws IOException {
        StringBuffer content = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(theURL.openStream()));
        String line = reader.readLine();
        while (line != null) {
            content.append(line + "\n");
            line = reader.readLine();
        }
        reader.close();
        return content.toString();
    }

    public static Object createObject(String className, Class[] paramTypes, Object[] params) throws Exception {
        Class<?> theClass = Class.forName(className);
        Constructor<?> cons = theClass.getConstructor(paramTypes);
        return cons.newInstance(params);
    }

    public static Vector cloneStringVector(Vector stringVector) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < stringVector.size(); ++i) {
            v.addElement(new String(stringVector.elementAt(i).toString()));
        }
        return v;
    }

    public static Image getTranslucentVersionOf(Image img) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            return img;
        }
        for (int i = pix.length - 1; i >= 0; --i) {
            pix[i] = 0x99000000 | pix[i] & 0xFFFFFF;
        }
        MemoryImageSource mis = new MemoryImageSource(w, h, pix, 0, w);
        return Toolkit.getDefaultToolkit().createImage(mis);
    }

    public static String getLocalName(String uri) {
        return uri.substring(uri.indexOf("#") + 1);
    }

    public static String getFileUri(String uri) {
        return uri.substring(0, uri.indexOf("#"));
    }

    public static String[] split(String s, String token) {
        Vector<String> result = new Vector<String>();
        int length = token.length();
        int pos = s.indexOf(token);
        int lastPos = 0;
        while (pos >= 0) {
            result.addElement(s.substring(lastPos, pos));
            lastPos = pos + length;
            pos = s.indexOf(token, lastPos);
        }
        if (lastPos < s.length()) {
            result.addElement(s.substring(lastPos));
        }
        Object[] r = new String[result.size()];
        result.copyInto(r);
        return r;
    }

    public static String convertToUnicodeString(char ch) {
        if (Character.getNumericValue((char)ch) != -1) {
            return String.valueOf((char)ch);
        }
        String val = "\\u";
        int intVal = ch;
        int bit4 = (int)((double)intVal / Math.pow(16.0, 3.0));
        intVal = (int)((double)intVal - (double)bit4 * Math.pow(16.0, 3.0));
        int bit3 = (int)((double)intVal / Math.pow(16.0, 2.0));
        intVal = (int)((double)intVal - (double)bit3 * Math.pow(16.0, 2.0));
        int bit2 = (int)((double)intVal / Math.pow(16.0, 1.0));
        intVal = (int)((double)intVal - (double)bit2 * Math.pow(16.0, 1.0));
        int bit1 = (int)((double)intVal / Math.pow(16.0, 0.0));
        if ((intVal = (int)((double)intVal - (double)bit1 * Math.pow(16.0, 0.0))) != 0) {
            System.err.println("SHIT");
        }
        return val + Character.toUpperCase(Integer.toHexString(bit4).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit3).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit2).charAt(0)) + Character.toUpperCase(Integer.toHexString(bit1).charAt(0));
    }

    public static void main(String[] args) {
        System.err.println("LRE Utility Classes Test Package...");
    }
}

