/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;

public class ABox {
    public static boolean DEBUG = false;
    public static Boolean UNKNOWN = null;
    private static final Individual TOP_NODE = new Individual(ATermUtils.TOP);
    private static final Individual BOTTOM_NODE = new Individual(ATermUtils.BOTTOM);
    protected static final String ANON_PREFIX = "anon";
    protected int anonCount = 0;
    public long satisfiabilityCount = 0L;
    public long consistencyCount = 0L;
    int treeDepth = 0;
    protected DatatypeReasoner dtReasoner;
    protected Map nodes;
    protected List nodeList;
    boolean changed = false;
    private boolean doExplanation;
    protected Map cache;
    private ABox pseudoModel;
    ABox lastCompletion;
    private boolean isComplete = false;
    private Clash clash;
    private int branch;
    private List branches;
    Map disjBranchStats;
    private boolean initialized = false;
    private KnowledgeBase kb;

    public ABox() {
        this(new KnowledgeBase());
    }

    public ABox(KnowledgeBase kb) {
        this.kb = kb;
        this.nodes = new HashMap();
        this.nodeList = new ArrayList();
        this.clash = null;
        this.doExplanation = true;
        this.dtReasoner = new DatatypeReasoner();
        this.clearCaches(true);
        this.branch = 0;
        this.branches = new ArrayList();
        this.disjBranchStats = new HashMap();
    }

    public ABox(ABox abox) {
        this(abox, null);
    }

    public ABox(ABox abox, ATermAppl extraIndividual) {
        boolean hasNominal;
        this.kb = abox.kb;
        Timer timer = this.kb.timers.startTimer("cloneABox");
        this.initialized = abox.initialized;
        this.changed = abox.changed;
        this.anonCount = abox.anonCount;
        this.dtReasoner = abox.dtReasoner;
        this.cache = abox.cache;
        this.clash = abox.clash;
        this.dtReasoner = abox.dtReasoner;
        this.doExplanation = abox.doExplanation;
        this.disjBranchStats = abox.disjBranchStats;
        int extra = extraIndividual == null ? 0 : 1;
        int nodeCount = abox.nodes.size() + extra;
        this.nodes = new HashMap(nodeCount);
        this.nodeList = new ArrayList(nodeCount);
        if (extraIndividual != null) {
            Individual n = new Individual(extraIndividual, this);
            n.branch = this.branch;
            n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
            this.nodes.put(extraIndividual, n);
            this.nodeList.add(extraIndividual);
            this.applyUC(n);
        }
        Timer t = this.kb.timers.startTimer("copyIndividuals");
        boolean checkingConceptSatisfiabilty = extra != 0;
        if (this.shouldCopyIndividuals(checkingConceptSatisfiabilty, hasNominal = abox.getKB().getExpressivity().hasNominal())) {
            for (int i = 0; i < nodeCount - extra; ++i) {
                ATerm x = (ATerm)abox.nodeList.get(i);
                Node node = abox.getNode(x);
                Node copyNode = node.copyTo(this);
                this.nodes.put(x, copyNode);
                this.nodeList.add(x);
            }
        }
        t.stop();
        t = this.kb.timers.startTimer("updateNodeReferences");
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.updateNodeReferences();
        }
        t.stop();
        t = this.kb.timers.startTimer("copyBranches");
        this.branch = abox.branch;
        this.branches = new ArrayList(abox.branches.size());
        int n = abox.branches.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Branch branch = (Branch)abox.branches.get(i2);
            Branch copy = branch.copyTo(this);
            copy.nodeCount = branch.nodeCount + extra;
            this.branches.add(copy);
        }
        t.stop();
        timer.stop();
    }

    private boolean shouldCopyIndividuals(boolean checkingConceptSatisfiabilty, boolean hasNominal) {
        return !checkingConceptSatisfiabilty || this.kb instanceof EconnectedKB || hasNominal && !PelletOptions.USE_PSEUDO_NOMINALS;
    }

    public ABox copy() {
        return new ABox(this);
    }

    public ABox copy(ATermAppl extraIndividual) {
        return new ABox(this, extraIndividual);
    }

    public void clearCaches(boolean clearSatCache) {
        this.pseudoModel = null;
        this.lastCompletion = null;
        if (clearSatCache) {
            this.cache = new HashMap();
            this.addCached(ATermUtils.TOP, TOP_NODE, DependencySet.INDEPENDENT);
            this.addCached(ATermUtils.BOTTOM, BOTTOM_NODE, DependencySet.INDEPENDENT);
        }
    }

    private boolean isCached(ATermAppl c) {
        return this.cache.containsKey(c);
    }

    private Individual getCached(ATermAppl c) {
        return ((Edge)this.cache.get(c)).getFrom();
    }

    private DependencySet getCacheDependency(ATermAppl c) {
        return ((Edge)this.cache.get(c)).getDepends();
    }

    public void cacheUnsatConcept(ATermAppl c) {
        ATermAppl notC = ATermUtils.negate(c);
        this.addCached(c, BOTTOM_NODE, DependencySet.INDEPENDENT);
        this.addCached(notC, TOP_NODE, DependencySet.INDEPENDENT);
    }

    private void addCached(ATerm name, Individual node, DependencySet ds) {
        this.cache.put(name, new Edge(null, node, null, ds));
    }

    private Boolean mergable(Individual root1, Individual root2) {
        Individual[] roots = new Individual[]{root1, root2};
        if (roots[0] == BOTTOM_NODE || roots[1] == BOTTOM_NODE) {
            if (DEBUG) {
                System.out.println("(1) true ");
            }
            return Boolean.FALSE;
        }
        if (roots[0] == TOP_NODE && roots[1] != BOTTOM_NODE) {
            if (DEBUG) {
                System.out.println("(2) false ");
            }
            return Boolean.TRUE;
        }
        if (roots[1] == TOP_NODE && roots[0] != BOTTOM_NODE) {
            if (DEBUG) {
                System.out.println("(3) false ");
            }
            return Boolean.TRUE;
        }
        for (int root = 0; root < 2; ++root) {
            int otherRoot = 1 - root;
            List[] negatedTypes = new List[]{roots[root].getTypes(Node.ATOM), roots[root].getTypes(Node.SOME), roots[root].getTypes(Node.OR), roots[root].getTypes(Node.MAX)};
            for (int j = 0; j < negatedTypes.length; ++j) {
                int n = negatedTypes[j].size();
                for (int i = 0; i < n; ++i) {
                    ATermAppl notA;
                    ATermAppl a = (ATermAppl)negatedTypes[j].get(i);
                    if (a.getArity() == 0 || !roots[otherRoot].hasType(notA = (ATermAppl)a.getArgument(0))) continue;
                    return UNKNOWN;
                }
            }
            Iterator i = roots[root].getTypes(Node.ALL).iterator();
            while (i.hasNext()) {
                ATermAppl av = (ATermAppl)i.next();
                ATerm r = av.getArgument(0);
                if (!roots[otherRoot].hasRNeighbor(this.getRole(r))) continue;
                return UNKNOWN;
            }
            i = roots[root].getTypes(Node.MAX).iterator();
            while (i.hasNext()) {
                int n2;
                ATermAppl mc = (ATermAppl)i.next();
                mc = (ATermAppl)mc.getArgument(0);
                Role r = this.getRole(mc.getArgument(0));
                int n = ((ATermInt)mc.getArgument(1)).getInt() - 1;
                int n1 = roots[root].getOutEdges().getEdges(r).getFilteredNeighbors(roots[root]).size();
                if (n1 + (n2 = roots[otherRoot].getOutEdges().getEdges(r).getFilteredNeighbors(roots[otherRoot]).size()) <= n) continue;
                return UNKNOWN;
            }
        }
        return Boolean.TRUE;
    }

    public boolean isObviousSubclassOf(ATermAppl c1, ATermAppl c2) {
        if (this.isCached(c1)) {
            Individual node = this.getCached(c1);
            return this.isObviousType(node, c2, this.getCacheDependency(c1));
        }
        return false;
    }

    public boolean isPossibleSubclassOf(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.negate(c2);
        if (this.isCached(c1) && this.isCached(notC2)) {
            Individual pNode = this.getCached(c1);
            return this.isPossibleType(pNode, c2);
        }
        return true;
    }

    public boolean isSubclassOf(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2);
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        c1 = ATermUtils.normalize(c1);
        c2 = ATermUtils.normalize(c2);
        ATermAppl notC2 = ATermUtils.negate(c2);
        if (DEBUG) {
            String name1 = URIUtils.getLocalName(c1.getName());
            String name2 = URIUtils.getLocalName(c2.getName());
            System.out.println("Subsumption for " + name1 + " and " + name2);
        }
        if (this.isObviousSubclassOf(c1, c2)) {
            return true;
        }
        if (!this.isPossibleSubclassOf(c1, c2)) {
            return false;
        }
        return !this.isSatisfiable(ATermUtils.makeAnd(c1, notC2));
    }

    public boolean isSatisfiable(ATermAppl c) {
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.print("Satisfiablity for " + c);
        }
        if (PelletOptions.USE_CACHING && this.isCached(c)) {
            boolean satisfiable;
            boolean bl = satisfiable = this.getCached(c) != BOTTOM_NODE;
            if (DEBUG) {
                System.out.println("Cached sat for " + c + " is " + satisfiable);
            }
            if (satisfiable || !this.doExplanation) {
                return satisfiable;
            }
        }
        ++this.satisfiabilityCount;
        ++this.consistencyCount;
        ATermAppl x = ATermUtils.makeTermAppl(DEBUG ? "x" + new UID() : "Any member of " + c.toString());
        ABox abox = PelletOptions.USE_PSEUDO_MODEL ? this.pseudoModel.copy(x) : this.copy(x);
        Individual ind = abox.getIndividual(x);
        abox.addType(x, c);
        abox.applyUC(ind);
        boolean isConsistent = abox.isConsistent(false);
        this.lastCompletion = abox.lastCompletion;
        if (PelletOptions.USE_CACHING) {
            boolean isPrimitive = ATermUtils.isPrimitive(c);
            ATermAppl negation = ATermUtils.getNegatedPrimitive(c);
            if (isPrimitive || negation != null) {
                if (isConsistent) {
                    ABox lastABox = abox.lastCompletion;
                    Individual rootNode = lastABox.getIndividual(x);
                    DependencySet ds = rootNode.getMergeDependency();
                    rootNode = (Individual)rootNode.getMergedTo();
                    if (DEBUG) {
                        abox.printNode(rootNode, new HashSet(), "");
                    }
                    Individual copyNode = (Individual)rootNode.copy();
                    this.addCached(c, copyNode, ds);
                } else {
                    if (negation == null) {
                        negation = ATermUtils.makeNot(c);
                    }
                    if (DEBUG) {
                        System.out.println(c + " is not satisfiable");
                        System.out.println(negation + " is TOP");
                    }
                    this.addCached(c, BOTTOM_NODE, DependencySet.INDEPENDENT);
                    this.addCached(negation, TOP_NODE, DependencySet.INDEPENDENT);
                }
            }
        }
        return isConsistent;
    }

    public boolean isObviousType(ATermAppl x, ATermAppl c) {
        Individual pNode = this.pseudoModel.getIndividual(x);
        pNode = pNode.mergedAt() > 0 ? this.getIndividual(x) : (Individual)pNode.getMergedTo();
        return this.isObviousType(pNode, c, pNode.getMergeDependency());
    }

    private boolean isObviousType(Individual pNode, ATermAppl c, DependencySet mergeDepends) {
        DependencySet ds = pNode.getDepends(c);
        return ds != null && ds.max() == 0 && (mergeDepends == null || mergeDepends.max() == 0);
    }

    public boolean isPossibleType(ATermAppl x, ATermAppl c) {
        Individual pNode = this.pseudoModel.getIndividual(x);
        pNode = pNode.mergedAt() > 0 ? this.getIndividual(x) : (Individual)pNode.getMergedTo();
        return this.isPossibleType(pNode, c);
    }

    public boolean isPossibleType(Individual pNode, ATermAppl c) {
        Boolean mergable;
        ATermAppl notC = ATermUtils.negate(c);
        if (this.isCached(notC) && (mergable = this.mergable(pNode, this.getCached(notC))) != null) {
            return mergable == false;
        }
        return !this.isObviousType(pNode, notC, DependencySet.INDEPENDENT);
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        boolean isType;
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.println("Checking type " + c + " for individual " + x);
        }
        if (this.isObviousType(x, c)) {
            return true;
        }
        if (!this.isPossibleType(x, c)) {
            return false;
        }
        ++this.consistencyCount;
        ABox abox = PelletOptions.USE_PSEUDO_MODEL ? this.pseudoModel.copy() : this.copy();
        ATermAppl notC = ATermUtils.negate(c);
        abox.addType(x, notC);
        boolean bl = isType = !abox.isConsistent(false);
        if (DEBUG) {
            System.out.println("Type " + isType + " " + c + " for individual " + x);
        }
        return isType;
    }

    public boolean isType(List inds, ATermAppl c) {
        c = ATermUtils.normalize(c);
        if (DEBUG) {
            System.out.println("Checking type " + c + " for individuals " + inds);
        }
        ++this.consistencyCount;
        ABox abox = PelletOptions.USE_PSEUDO_MODEL ? this.pseudoModel.copy() : this.copy();
        ATermAppl notC = ATermUtils.negate(c);
        Iterator i = inds.iterator();
        while (i.hasNext()) {
            ATermAppl x = (ATermAppl)i.next();
            abox.addType(x, notC);
        }
        boolean isType = !abox.isConsistent(false);
        this.lastCompletion = abox.lastCompletion;
        if (DEBUG) {
            System.out.println("Type " + isType + " " + c + " for individuals " + inds);
        }
        return isType;
    }

    public Boolean hasObviousPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Role prop = this.getRole(p);
        if (prop.isDatatypeRole()) {
            Object value = o == null ? null : this.dtReasoner.getValue(o);
            return this.hasObviousDataPropertyValue(s, p, value);
        }
        if (o == null) {
            return this.hasObviousObjectProperty(s, p);
        }
        return this.hasObviousObjectPropertyValue(s, p, o);
    }

    public Boolean hasObviousDataPropertyValue(ATermAppl s, ATermAppl p, Object value) {
        Individual subj = this.pseudoModel.getIndividual(s);
        Role prop = this.getRole(p);
        boolean onlyPositive = false;
        if (subj.mergedAt() > 0) {
            onlyPositive = true;
            subj = this.getIndividual(s);
        } else {
            subj = (Individual)subj.getMergedTo();
        }
        Boolean hasValue = subj.hasDataPropertyValue(prop, value);
        if (onlyPositive && hasValue != null && !hasValue.booleanValue()) {
            return null;
        }
        return hasValue;
    }

    public Boolean hasObviousObjectPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Individual subj = this.pseudoModel.getIndividual(s);
        Individual obj = this.pseudoModel.getIndividual(o);
        Role prop = this.getRole(p);
        boolean onlyPositive = prop.isTransitive();
        if (subj.mergedAt() > 0 || obj.mergedAt() > 0) {
            onlyPositive = true;
            subj = this.getIndividual(s);
            obj = this.getIndividual(s);
        } else {
            subj = (Individual)subj.getMergedTo();
            obj = (Individual)obj.getMergedTo();
        }
        Boolean hasValue = subj.hasObjectPropertyValue(prop, obj);
        if (onlyPositive && hasValue != null && !hasValue.booleanValue()) {
            return null;
        }
        return hasValue;
    }

    public Boolean hasObviousObjectProperty(ATermAppl s, ATermAppl p) {
        Individual subj = this.pseudoModel.getIndividual(s);
        Role prop = this.getRole(p);
        Boolean hasValue = (subj = subj.mergedAt() > 0 ? this.getIndividual(s) : (Individual)subj.getMergedTo()).hasObjectPropertyValue(prop, null);
        if (hasValue != null && !hasValue.booleanValue()) {
            return null;
        }
        return hasValue;
    }

    public boolean hasProperty(ATermAppl s, ATermAppl p) {
        Boolean hasObviousValue = this.hasObviousPropertyValue(s, p, null);
        if (hasObviousValue != null) {
            return hasObviousValue;
        }
        return false;
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        Boolean hasObviousValue = this.hasObviousPropertyValue(s, p, o);
        if (hasObviousValue != null) {
            return hasObviousValue;
        }
        ATermAppl c = null;
        if (o == null) {
            c = ATermUtils.makeMin(p, 1);
        } else {
            ATermAppl valueO = ATermUtils.makeValue(o);
            c = ATermUtils.makeSomeValues(p, valueO);
        }
        return this.isType(s, c);
    }

    public List getObviousDataPropertyValues(ATermAppl s, Role prop) {
        Individual subj = this.pseudoModel.getIndividual(s);
        subj = subj.mergedAt() > 0 ? this.getIndividual(s) : (Individual)subj.getMergedTo();
        ArrayList<Literal> values = new ArrayList<Literal>();
        EdgeList edges = subj.getRSuccessorEdges(prop);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (literalValue == null || ds.max() != 0) continue;
            values.add(literal);
        }
        return values;
    }

    public boolean isConsistent() {
        return this.isConsistent(true);
    }

    private boolean isConsistent(boolean copyFirst) {
        boolean consistent;
        boolean saveOption = PelletOptions.USE_PSEUDO_NOMINALS;
        if (this.pseudoModel == null && copyFirst) {
            PelletOptions.USE_PSEUDO_NOMINALS = false;
        }
        ABox abox = copyFirst ? this.copy() : this;
        Timer timer = this.kb.timers.startTimer("consistency");
        if (DEBUG) {
            System.out.println("Consistency check starts");
        }
        CompletionStrategy strategy = this.kb.chooseStrategy(abox);
        this.lastCompletion = strategy.complete();
        if (this.pseudoModel == null && copyFirst) {
            this.pseudoModel = this.lastCompletion;
        }
        timer.stop();
        PelletOptions.USE_PSEUDO_NOMINALS = saveOption;
        if (DEBUG) {
            System.out.println("Tree depth: " + this.lastCompletion.treeDepth + " size: " + this.lastCompletion.getNodes().size());
        }
        boolean bl = consistent = !this.lastCompletion.isClosed();
        if (!consistent) {
            if (copyFirst) {
                this.setClash(this.lastCompletion.clash);
            }
            if (DEBUG) {
                System.out.println(this.getClash().detailedString());
            }
        }
        ++this.consistencyCount;
        return consistent;
    }

    public void initialize() {
        Timer timer = this.kb.timers.startTimer("abox.init");
        this.branch = this.branches.size() + 1;
        this.treeDepth = 1;
        this.changed = true;
        this.isComplete = false;
        this.initialized = true;
        IndividualIterator i = this.getIndIterator();
        while (i.hasNext()) {
            Individual n = (Individual)i.next();
            n.setChanged(true);
            this.applyUC(n);
            EdgeList allEdges = n.getOutEdges();
            for (int e = 0; e < allEdges.size(); ++e) {
                Edge edge = allEdges.edgeAt(e);
                this.applyDomainRange(edge);
                this.applyFunctionalRole(edge);
                this.applyAllValues(edge);
            }
            if (!n.isMerged()) continue;
            n.mergeTo(n.getMergedTo(), n.getMergeDependency());
        }
        timer.stop();
    }

    private void applyUC(Individual node) {
        ATermList UC = this.kb.getTBox().getUC();
        if (UC != null) {
            ATermList t = UC;
            while (!t.isEmpty()) {
                ATermAppl c = (ATermAppl)t.getFirst();
                node.addType(c, DependencySet.INDEPENDENT);
                t = t.getNext();
            }
        }
    }

    void applyFunctionalRole(Edge edge) {
        Role r = edge.getRole();
        if (r.isFunctional()) {
            this.applyFunctionalMaxRule(edge.getFrom(), r, DependencySet.INDEPENDENT);
        }
        if (r.isInverseFunctional() && r.isObjectRole()) {
            this.applyFunctionalMaxRule((Individual)edge.getTo(), r.getInverse(), DependencySet.INDEPENDENT);
        }
    }

    protected void applyFunctionalMaxRule(Individual x, Role s, DependencySet ds) {
        Role[] functionalSupers = s.getFunctionalSupers();
        if (functionalSupers == null) {
            return;
        }
        block0: for (int j = 0; j < functionalSupers.length; ++j) {
            Set neighbors;
            Role r = functionalSupers[j];
            EdgeList edges = x.getRNeighborEdges(r);
            if (edges.size() <= 1 || (neighbors = edges.getFilteredNeighbors(x)).size() <= 1) continue;
            Iterator i = neighbors.iterator();
            Node head = (Node)i.next();
            ds = ds.union(edges.getEdgesContaining(head).edgeAt(0).getDepends());
            while (i.hasNext()) {
                Node next = (Node)i.next();
                ds = ds.union(edges.getEdgesContaining(next).edgeAt(0).getDepends());
                if (next.isDifferent(head)) {
                    ds = ds.union(next.getDifferenceDependency(head));
                    if (r.isFunctional()) {
                        this.setClash(Clash.functionalCardinality(x, ds, r.getName()));
                        continue block0;
                    }
                    this.setClash(Clash.maxCardinality(x, ds, r.getName(), 1));
                    continue block0;
                }
                if (head.isRoot() || next.isLeaf() || next.hasAncestor((Individual)head)) {
                    if (DEBUG) {
                        System.out.println("Apply max rule to  " + x + " for prop " + r + " merge " + next + " -> " + head);
                    }
                    next.mergeTo(head, ds);
                } else {
                    if (DEBUG) {
                        System.out.println("Apply max rule to  " + x + " for prop " + r + " merge " + head + " -> " + next);
                    }
                    head.mergeTo(next, ds);
                    head = next;
                }
                if (!this.isClosed()) continue;
                return;
            }
        }
    }

    void applyDomainRange(Edge edge) {
        Role r = edge.getRole();
        ATermAppl domain = r.getDomain();
        ATermAppl range = r.getRange();
        if (domain != null) {
            Individual from = edge.getFrom();
            if (DEBUG && !from.hasType(domain)) {
                System.out.println("DOM : " + edge + " " + domain);
            }
            ((Node)from).addType(domain, edge.getDepends());
        }
        if (range != null) {
            Node to = edge.getTo();
            if (DEBUG && !to.hasType(range)) {
                System.out.println("RAN : " + edge + " " + range);
            }
            to.addType(range, edge.getDepends());
        }
    }

    void applyAllValues(Individual x) {
        List allValues = x.getTypes(Node.ALL);
        Iterator i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = (ATermAppl)i.next();
            DependencySet avDepends = x.getDepends(av);
            this.applyAllValues(x, av, avDepends);
        }
    }

    void applyAllValues(Individual x, ATermAppl av, DependencySet avDepends) {
        Role s = this.kb.getRole(av.getArgument(0));
        ATermAppl c = (ATermAppl)av.getArgument(1);
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            this.applyAllValues(x, s, c, edgeToY, avDepends);
        }
    }

    void applyAllValues(Individual x, Role r, ATermAppl c, Edge edgeToY, DependencySet avDepends) {
        ATermAppl allRC;
        DependencySet ds = null;
        Node y = edgeToY.getNeighbor(x);
        if (!y.hasType(c)) {
            ds = avDepends.union(edgeToY.getDepends());
            if (DEBUG) {
                System.out.println("ALL :  " + x + " -> " + y + " {" + r + "} " + c + " " + ds + " " + this.getBranch());
            }
            y.addType(c, ds);
        }
        if (r.isTransitive() && !y.hasType(allRC = ATermUtils.makeAllValues(r.getName(), c))) {
            if (ds == null) {
                ds = avDepends.union(edgeToY.getDepends());
            }
            y.addType(allRC, ds);
            if (DEBUG) {
                System.out.println("ALLT:  " + x + " -> " + y + " {" + r + "} " + c + " " + allRC + " " + ds + " " + this.getBranch());
            }
        }
    }

    void applyAllValues(Edge edge) {
        Individual x = edge.getFrom();
        Role r = edge.getRole();
        List allValues = x.getTypes(Node.ALL);
        Iterator i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = (ATermAppl)i.next();
            Role s = this.getRole(av.getArgument(0));
            if (!r.isSubRoleOf(s)) continue;
            ATermAppl c = (ATermAppl)av.getArgument(1);
            DependencySet avDepends = x.getDepends(av);
            this.applyAllValues(x, s, c, edge, avDepends);
        }
        if (r.isObjectRole()) {
            Individual y = (Individual)edge.getTo();
            r = r.getInverse();
            allValues = y.getTypes(Node.ALL);
            i = allValues.iterator();
            while (i.hasNext()) {
                ATermAppl av = (ATermAppl)i.next();
                Role s = this.getRole(av.getArgument(0));
                if (!r.isSubRoleOf(s)) continue;
                ATermAppl c = (ATermAppl)av.getArgument(1);
                DependencySet avDepends = y.getDepends(av);
                this.applyAllValues(y, s, c, edge, avDepends);
            }
        }
    }

    public EdgeList getInEdges(ATerm x) {
        return this.getNode(x).getInEdges();
    }

    public EdgeList getOutEdges(ATerm x) {
        Node node = this.getNode(x);
        if (node instanceof Literal) {
            return new EdgeList();
        }
        return ((Individual)node).getOutEdges();
    }

    public Individual getIndividual(ATerm x) {
        return (Individual)this.nodes.get(x);
    }

    public Literal getLiteral(ATerm x) {
        return (Literal)this.nodes.get(x);
    }

    public Node getNode(ATerm x) {
        return (Node)this.nodes.get(x);
    }

    public void addType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        int remember = this.branch;
        this.branch = -1;
        Node node = this.getNode(x);
        if (node.isMerged()) {
            node = node.getMergedTo();
        }
        node.addType(c, DependencySet.INDEPENDENT);
        this.branch = remember;
    }

    public void removeType(ATermAppl x, ATermAppl c) {
        c = ATermUtils.normalize(c);
        Node node = this.getNode(x);
        node.removeType(c);
    }

    public Literal addLiteral() {
        return this.createLiteral(null);
    }

    public Literal addLiteral(ATermAppl dataValue) {
        if (dataValue == null || !ATermUtils.isLiteral(dataValue)) {
            throw new InternalReasonerException("Invalid value to create a literal. Value: " + dataValue);
        }
        return this.createLiteral(dataValue);
    }

    private Literal createLiteral(ATermAppl value) {
        ATermAppl name = this.createUniqueName();
        Literal lit = new Literal(name, value, this);
        lit.addType(ATermUtils.makeTermAppl("http://www.w3.org/2000/01/rdf-schema#Literal"), DependencySet.INDEPENDENT);
        this.nodes.put(name, lit);
        this.nodeList.add(name);
        return lit;
    }

    public Individual addIndividual(ATermAppl x) {
        return this.addIndividual(x, this.branch);
    }

    private Individual addIndividual(ATermAppl x, int branch) {
        if (this.nodes.containsKey(x)) {
            throw new RuntimeException("adding a node twice " + x);
        }
        this.changed = true;
        Individual n = new Individual(x, this);
        n.branch = branch;
        n.addType(ATermUtils.TOP, DependencySet.INDEPENDENT);
        this.nodes.put(x, n);
        this.nodeList.add(x);
        if (n.isRoot()) {
            ATermAppl valueX = ATermUtils.makeValue(x);
            if (this.isInitialized()) {
                n.addType(valueX, new DependencySet(branch));
            } else {
                n.addType(valueX, DependencySet.INDEPENDENT);
            }
        } else {
            this.applyUC(n);
        }
        return n;
    }

    public void addSame(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ind1.setSame(ind2, DependencySet.INDEPENDENT);
    }

    public void addDifferent(ATermAppl x, ATermAppl y) {
        Individual ind1 = this.getIndividual(x);
        Individual ind2 = this.getIndividual(y);
        ind1.setDifferent(ind2, DependencySet.INDEPENDENT);
    }

    public boolean isNode(ATerm x) {
        return this.getNode(x) != null;
    }

    public final ATermAppl createUniqueName() {
        return ATermUtils.makeTermAppl(ANON_PREFIX + ++this.anonCount);
    }

    public final Collection getNodes() {
        return this.nodes.values();
    }

    final Map getNodeMap() {
        return this.nodes;
    }

    public final List getNodeNames() {
        return this.nodeList;
    }

    public final IndividualIterator getIndIterator() {
        return new IndividualIterator(this);
    }

    public final IndividualIterator getSingletonIterator(Individual x) {
        int index = this.nodeList.indexOf(x.getName());
        return new IndividualIterator(this, index, index + 1);
    }

    public String toString() {
        return "[size: " + this.nodes.size() + " freeMemory: " + (double)Runtime.getRuntime().freeMemory() / 1000000.0 + "mb]";
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.dtReasoner;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    void setComplete(boolean isComplete) {
        this.isComplete = isComplete;
    }

    public boolean isClosed() {
        return this.clash != null;
    }

    public Clash getClash() {
        return this.clash;
    }

    public void setClash(Clash clash) {
        if (clash != null && this.clash != null) {
            if (DEBUG) {
                System.out.println("Clash was already set \nExisting: " + this.clash + "\nNew     : " + clash);
            }
            if (this.clash.depends.max() < clash.depends.max()) {
                return;
            }
        }
        this.clash = clash;
    }

    public KnowledgeBase getKB() {
        return this.kb;
    }

    public Role getRole(ATerm r) {
        return this.kb.getRole(r);
    }

    public RBox getRBox() {
        return this.kb.getRBox();
    }

    public TBox getTBox() {
        return this.kb.getTBox();
    }

    int getBranch() {
        return this.branch;
    }

    void setBranch(int branch) {
        this.branch = branch;
    }

    void incrementBranch() {
        ++this.branch;
    }

    public boolean isInitialized() {
        return this.initialized && !this.kb.isChanged();
    }

    public final boolean doExplanation() {
        return this.doExplanation || DEBUG;
    }

    public void setDoExplanation(boolean doExplanation) {
        this.doExplanation = doExplanation;
    }

    public String getExplanation() {
        Clash lastClash;
        Clash clash = lastClash = this.lastCompletion != null ? this.lastCompletion.getClash() : null;
        if (lastClash == null) {
            return "No inconsistency was found! There is no explanation generated.";
        }
        return lastClash.detailedString();
    }

    public List getBranches() {
        return this.branches;
    }

    public void validate() {
        IndividualIterator n = this.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            if (!node.isRoot() || node.isMerged()) continue;
            this.validate(node);
        }
    }

    private void validate(Individual node) {
        EdgeList edges = node.getOutEdges();
        for (int e = 0; e < edges.size(); ++e) {
            Edge edge = edges.edgeAt(e);
            Node succ = edge.getTo();
            if (succ.getInEdges().hasEdge(edge)) continue;
            throw new InternalReasonerException("Invalid edge found: " + edge);
        }
    }

    void printTree() {
    }

    private void printNode(Individual node, Set printed, String indent) {
        if (printed.contains(node)) {
            System.out.println(" " + node.getNameStr());
            return;
        }
        printed.add(node);
        if (node.isMerged()) {
            System.out.println(" -> " + node.getMergedTo().getNameStr());
            return;
        }
        System.out.println(node.debugString());
        indent = indent + "  ";
        Iterator i = node.getSuccessors().iterator();
        while (i.hasNext()) {
            Node succ = (Node)i.next();
            EdgeList edges = node.getEdgesTo(succ);
            System.out.print(indent + "[");
            for (int e = 0; e < edges.size(); ++e) {
                if (e > 0) {
                    System.out.print(", ");
                }
                System.out.print(edges.edgeAt(e).getRole());
            }
            System.out.print("] ");
            if (succ instanceof Individual) {
                this.printNode((Individual)succ, printed, indent);
                continue;
            }
            System.out.println(" (Literal) " + succ.getName() + " " + succ.getTypes());
        }
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }
}

