/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.utils.SetUtils;

public abstract class Blocking {
    protected boolean subset(Individual x, Individual y) {
        Set xTypes = x.getTypes();
        Set yTypes = y.getTypes();
        return SetUtils.subset(xTypes, yTypes);
    }

    protected boolean equals(Individual x, Individual y) {
        Set xTypes = x.getTypes();
        Set yTypes = y.getTypes();
        return SetUtils.equals(xTypes, yTypes);
    }

    public boolean isBlocked(Individual x) {
        if (x.isRoot()) {
            return x.isMerged();
        }
        if (x.isMerged()) {
            return true;
        }
        Set ancestors = x.getAncestors();
        boolean isBlocked = this.isIndirectlyBlocked(x, ancestors) || this.isDirectlyBlocked(x, ancestors);
        return isBlocked;
    }

    private boolean isAncestorBlocked(Individual x, Set ancestors) {
        Iterator i = ancestors.iterator();
        while (i.hasNext()) {
            Individual ancestor = (Individual)i.next();
            if (ancestor.equals(x) || !this.isDirectlyBlocked(ancestor, ancestor.getAncestors())) continue;
            return true;
        }
        return false;
    }

    public boolean isIndirectlyBlocked(Individual x) {
        if (x.isRoot()) {
            return x.isMerged();
        }
        if (x.isMerged()) {
            return true;
        }
        return this.isIndirectlyBlocked(x, x.getAncestors());
    }

    public boolean isIndirectlyBlocked(Individual x, Set ancestors) {
        return this.isAncestorBlocked(x, ancestors);
    }

    public abstract boolean isDirectlyBlocked(Individual var1, Set var2);
}

