/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;

abstract class Branch {
    ABox abox;
    int branch;
    int tryCount;
    int tryNext;
    Individual node;
    DependencySet termDepends;
    DependencySet[] prevDS;
    int anonCount;
    int nodeCount;
    Map info;

    Branch(ABox abox, Individual x, DependencySet ds, int s) {
        this.abox = abox;
        this.node = x;
        this.termDepends = ds;
        this.tryCount = s;
        this.prevDS = new DependencySet[this.tryCount];
        this.tryNext = 0;
        this.branch = abox.getBranch();
        this.anonCount = abox.anonCount;
        this.nodeCount = abox.nodes.size();
    }

    public boolean tryNext() {
        if (this.abox.isClosed()) {
            return false;
        }
        boolean openBranch = this.tryBranch();
        if (openBranch) {
            this.abox.setClash(null);
        } else {
            this.abox.getClash().depends.remove(this.branch);
        }
        return openBranch;
    }

    protected abstract Branch copyTo(ABox var1);

    protected abstract boolean tryBranch();

    public void restore() {
        this.abox.setBranch(this.branch);
        this.abox.setClash(null);
        this.abox.anonCount = this.anonCount;
        List nodeList = this.abox.getNodeNames();
        Map nodes = this.abox.getNodeMap();
        if (ABox.DEBUG) {
            System.out.println("Remove nodes " + nodeList.subList(this.nodeCount, nodeList.size()));
        }
        for (int i = 0; i < nodeList.size(); ++i) {
            ATerm x = (ATerm)nodeList.get(i);
            Node node = this.abox.getNode(x);
            if (node == null) {
                System.out.print("");
            }
            if (i >= this.nodeCount) {
                nodes.remove(x);
                continue;
            }
            node.restore(this.branch);
        }
        nodeList.subList(this.nodeCount, nodeList.size()).clear();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            this.abox.applyAllValues(ind);
        }
    }

    void put(String key, Object obj) {
        if (this.info == null) {
            this.info = new HashMap();
        }
        this.info.put(key, obj);
    }

    Object get(String key) {
        return this.info.get(key);
    }

    public String toString() {
        return "Branch " + this.branch;
    }
}

