/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Blocking;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public abstract class CompletionStrategy {
    protected ABox abox;
    protected Blocking blocking;
    protected Timers timers;
    protected Timer completionTimer;

    public CompletionStrategy(ABox abox, Blocking blocking) {
        this.abox = abox;
        this.blocking = blocking;
        this.timers = abox.getKB().timers;
        this.completionTimer = this.timers.createTimer("complete");
    }

    abstract ABox complete();

    public String toString() {
        String name = this.getClass().getName();
        int lastIndex = name.lastIndexOf(46);
        return name.substring(lastIndex + 1);
    }

    List findMergeNodes(Set neighbors) {
        Timer t = this.timers.startTimer("findMergeNodes");
        ArrayList<NodeMerge> pairs = new ArrayList<NodeMerge>();
        ArrayList nodes = new ArrayList(neighbors);
        for (int i = 0; i < nodes.size(); ++i) {
            Node y = (Node)nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                Node z = (Node)nodes.get(j);
                if (y.isDifferent(z)) continue;
                if (y.isLeaf() && z.isLeaf()) {
                    pairs.add(new NodeMerge(y, z));
                    continue;
                }
                if (y.isRoot() && z.isRoot()) {
                    if (z.isBnode()) {
                        pairs.add(new NodeMerge(z, y));
                        continue;
                    }
                    pairs.add(new NodeMerge(y, z));
                    continue;
                }
                if (!y.isRoot() && !z.hasAncestor((Individual)y)) {
                    pairs.add(new NodeMerge(y, z));
                    continue;
                }
                if (!z.isRoot() && !y.hasAncestor((Individual)z)) {
                    pairs.add(new NodeMerge(z, y));
                    continue;
                }
                System.err.println("DEBUG: Cannot determine how to merge nodes " + y + " " + z);
            }
        }
        t.stop();
        return pairs;
    }

    void printBlocked() {
        int blockedCount = 0;
        String blockedNodes = "";
        IndividualIterator n = this.abox.getIndIterator();
        while (n.hasNext()) {
            Individual node = (Individual)n.next();
            ATermAppl x = node.getName();
            if (!this.blocking.isBlocked(node)) continue;
            ++blockedCount;
            blockedNodes = blockedNodes + x + " ";
        }
        System.out.println("Blocked nodes " + blockedCount + " [" + blockedNodes + "]");
    }
}

