/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermList;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.XSDDecimal;
import org.mindswap.pellet.exceptions.TimeoutException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.SetUtils;

public class DLTest {
    public static boolean DEBUG = false;
    public static boolean PRINT_TIME = false;
    public static int SAT_LIMIT = 10;
    public static int TBOX_LIMIT = 100;
    public static int ABOX_LIMIT = 200;
    public static boolean FAST = false;
    public static FilenameFilter kbFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            if (DEBUG) {
                System.out.println("Filtering file " + dir + File.separatorChar + name);
            }
            return name.endsWith(".tree");
        }
    };
    public KnowledgeBase kb;

    public void assertTrue(boolean b) {
        if (!b) {
            throw new RuntimeException("assert error");
        }
    }

    public void parseToken(StreamTokenizer in, int token) throws Exception {
        this.assertTrue(token == in.nextToken());
    }

    public void skipToken(StreamTokenizer in) throws Exception {
        in.nextToken();
    }

    public boolean peekToken(StreamTokenizer in, int token) throws Exception {
        int next = in.nextToken();
        in.pushBack();
        return token == next;
    }

    public String getToken(StreamTokenizer in) throws Exception {
        in.nextToken();
        return in.sval;
    }

    public int getInt(StreamTokenizer in) throws Exception {
        in.nextToken();
        return (int)in.nval;
    }

    public double getNumber(StreamTokenizer in) throws Exception {
        in.nextToken();
        return in.nval;
    }

    public ATermAppl getTerm(StreamTokenizer in) throws Exception {
        return ATermUtils.makeTermAppl(this.getToken(in).toUpperCase());
    }

    public ATermAppl term(String str) throws Exception {
        return ATermUtils.makeTermAppl(str);
    }

    public StreamTokenizer initTokenizer(String file) throws Exception {
        StreamTokenizer in = new StreamTokenizer(new FileReader(file));
        in.commentChar(59);
        in.wordChars(47, 47);
        in.wordChars(95, 95);
        in.wordChars(42, 42);
        in.wordChars(63, 63);
        in.wordChars(37, 37);
        in.wordChars(62, 62);
        in.wordChars(60, 60);
        in.wordChars(61, 61);
        in.quoteChar(124);
        return in;
    }

    public KnowledgeBase initKB(long timeout) {
        KnowledgeBase kb = new KnowledgeBase();
        kb = new KnowledgeBase();
        kb.setTimeout(timeout * 1000L);
        return kb;
    }

    ATermAppl[] parseExprList(StreamTokenizer in) throws Exception {
        int count = 0;
        while (this.peekToken(in, 40)) {
            this.skipToken(in);
            ++count;
        }
        ArrayList<ATermAppl> terms = new ArrayList<ATermAppl>();
        while (true) {
            if (this.peekToken(in, 41)) {
                if (count == 0) break;
                this.skipToken(in);
                if (--count != 0) continue;
                break;
            }
            if (this.peekToken(in, 40)) {
                this.skipToken(in);
                ++count;
                continue;
            }
            terms.add(this.parseExpr(in));
        }
        return terms.toArray(new ATermAppl[terms.size()]);
    }

    ATermAppl parseExpr(StreamTokenizer in) throws Exception {
        ATermAppl a = null;
        int token = in.nextToken();
        String s = in.sval;
        if (token == 40) {
            token = in.nextToken();
            this.assertTrue(token == -3);
            s = in.sval;
            if (s.equalsIgnoreCase("NOT")) {
                ATermAppl c = this.parseExpr(in);
                a = ATermUtils.makeNot(c);
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
            } else if (s.equalsIgnoreCase("AND")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekToken(in, 41)) {
                    ATermAppl c = this.parseExpr(in);
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeAnd(list);
            } else if (s.equalsIgnoreCase("OR")) {
                ATermList list = ATermUtils.EMPTY_LIST;
                while (!this.peekToken(in, 41)) {
                    ATermAppl c = this.parseExpr(in);
                    if (ATermUtils.isPrimitive(c)) {
                        this.kb.addClass(c);
                    }
                    list = list.insert(c);
                }
                a = ATermUtils.makeOr(list);
            } else if (s.equalsIgnoreCase("ALL")) {
                ATermAppl r = this.parseExpr(in);
                this.kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr(in);
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeAllValues(r, c);
            } else if (s.equalsIgnoreCase("SOME")) {
                ATermAppl r = this.parseExpr(in);
                this.kb.addObjectProperty(r);
                ATermAppl c = this.parseExpr(in);
                if (ATermUtils.isPrimitive(c)) {
                    this.kb.addClass(c);
                }
                a = ATermUtils.makeSomeValues(r, c);
            } else if (s.equalsIgnoreCase("AT-LEAST")) {
                int n = this.getInt(in);
                ATermAppl r = this.parseExpr(in);
                this.kb.addObjectProperty(r);
                a = ATermUtils.makeMin(r, n);
            } else if (s.equalsIgnoreCase("AT-MOST")) {
                int n = this.getInt(in);
                ATermAppl r = this.parseExpr(in);
                this.kb.addObjectProperty(r);
                a = ATermUtils.makeMax(r, n);
            } else if (s.equalsIgnoreCase("A")) {
                ATermAppl r = this.getTerm(in);
                this.kb.addProperty(r);
                this.kb.addFunctionalProperty(r);
                a = ATermUtils.makeMin(r, 1);
            } else if (s.equalsIgnoreCase("MIN") || s.equals(">=")) {
                ATermAppl r = this.getTerm(in);
                this.kb.addDatatypeProperty(r);
                String val = this.getNumber(in) + "";
                DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
                Datatype dt = XSDDecimal.instance.deriveByRestriction("minExclusive", val);
                String dtName = dtReasoner.defineDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else if (s.equalsIgnoreCase("MAX") || s.equals("<=")) {
                ATermAppl r = this.getTerm(in);
                this.kb.addDatatypeProperty(r);
                String val = this.getNumber(in) + "";
                DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
                Datatype dt = XSDDecimal.instance.deriveByRestriction("maxExclusive", val);
                String dtName = dtReasoner.defineDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else if (s.equals("=")) {
                ATermAppl r = this.getTerm(in);
                this.kb.addDatatypeProperty(r);
                String val = this.getNumber(in) + "";
                DatatypeReasoner dtReasoner = this.kb.getDatatypeReasoner();
                XSDDecimal dt = (XSDDecimal)XSDDecimal.instance.deriveByRestriction("minExclusive", val);
                dt = (XSDDecimal)dt.deriveByRestriction("maxExclusive", val);
                String dtName = dtReasoner.defineDatatype(dt);
                ATermAppl datatype = ATermUtils.makeTermAppl(dtName);
                a = ATermUtils.makeAllValues(r, datatype);
            } else if (s.equalsIgnoreCase("EXACTLY")) {
                int n = this.getInt(in);
                ATermAppl r = this.parseExpr(in);
                this.kb.addObjectProperty(r);
                a = ATermUtils.makeAnd(ATermUtils.makeMax(r, n), ATermUtils.makeMin(r, n));
            } else if (s.equalsIgnoreCase("INV")) {
                ATermAppl r = this.parseExpr(in);
                a = this.kb.getProperty(r).getInverse().getName();
            } else {
                throw new RuntimeException("Unknown expression " + s);
            }
            if (in.nextToken() != 41) {
                if (s.equalsIgnoreCase("AT-LEAST") || s.equalsIgnoreCase("AT-MOST")) {
                    throw new UnsupportedFeatureException("Qualified cardinality restrictions");
                }
                throw new RuntimeException("Parse exception at term " + s);
            }
        } else {
            a = token == -1 ? null : (s.equalsIgnoreCase("TOP") || s.equalsIgnoreCase("*TOP*") ? ATermUtils.TOP : (s.equalsIgnoreCase("BOTTOM") || s.equalsIgnoreCase("*BOTTOM*") ? ATermUtils.BOTTOM : ATermUtils.makeTermAppl(s.toUpperCase())));
        }
        return a;
    }

    public void readTBox(StreamTokenizer in) throws Exception {
        int token = in.nextToken();
        while (token != -1 && token != 41) {
            ATermAppl c;
            if (token == 35) {
                in.ordinaryChar(124);
                token = in.nextToken();
                while (token != 35) {
                    token = in.nextToken();
                }
                in.quoteChar(124);
                token = in.nextToken();
                if (token == -1) break;
            }
            this.assertTrue(token == 40);
            String str = this.getToken(in);
            if (str.equalsIgnoreCase("DEFINE-PRIMITIVE-ROLE") || str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMROLE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE")) {
                ATermAppl r = this.getTerm(in);
                this.kb.addObjectProperty(r);
                if (str.equalsIgnoreCase("DEFINE-PRIMITIVE-ATTRIBUTE") || str.equalsIgnoreCase("DEFPRIMATTRIBUTE")) {
                    this.kb.addFunctionalProperty(r);
                    if (DEBUG) {
                        System.out.println("DEFINE-PRIMITIVE-ATTRIBUTE " + r);
                    }
                } else if (DEBUG) {
                    System.out.println("DEFINE-PRIMITIVE-ROLE " + r);
                }
                while (!this.peekToken(in, 41)) {
                    String cmd;
                    if (this.peekToken(in, 58)) {
                        this.parseToken(in, 58);
                        cmd = this.getToken(in);
                        if (cmd.equalsIgnoreCase("parents")) {
                            ATermAppl s;
                            boolean paren = this.peekToken(in, 40);
                            if (paren) {
                                this.parseToken(in, 40);
                                while (!this.peekToken(in, 41)) {
                                    s = this.getTerm(in);
                                    this.kb.addObjectProperty(s);
                                    this.kb.addSubProperty(r, s);
                                    if (!DEBUG) continue;
                                    System.out.println("PARENT-ROLE " + r + " " + s);
                                }
                                this.parseToken(in, 41);
                                continue;
                            }
                            s = this.getTerm(in);
                            if (s.toString().equalsIgnoreCase("NIL")) continue;
                            this.kb.addObjectProperty(s);
                            this.kb.addSubProperty(r, s);
                            if (!DEBUG) continue;
                            System.out.println("PARENT-ROLE " + r + " " + s);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("transitive")) {
                            this.assertTrue(this.getToken(in).equalsIgnoreCase("T"));
                            this.kb.addTransitiveProperty(r);
                            if (!DEBUG) continue;
                            System.out.println("TRANSITIVE-ROLE " + r);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("range")) {
                            ATermAppl range = this.parseExpr(in);
                            this.kb.addClass(range);
                            this.kb.addRange(r, range);
                            if (!DEBUG) continue;
                            System.out.println("RANGE " + r + " " + range);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("domain")) {
                            ATermAppl domain = this.parseExpr(in);
                            this.kb.addClass(domain);
                            this.kb.addDomain(r, domain);
                            if (!DEBUG) continue;
                            System.out.println("DOMAIN " + r + " " + domain);
                            continue;
                        }
                        if (cmd.equalsIgnoreCase("inverse")) {
                            ATermAppl inv = this.getTerm(in);
                            this.kb.addInverseProperty(r, inv);
                            if (!DEBUG) continue;
                            System.out.println("INVERSE " + r + " " + inv);
                            continue;
                        }
                        throw new RuntimeException("Invalid role spec " + cmd);
                    }
                    if (!this.peekToken(in, 40)) continue;
                    this.parseToken(in, 40);
                    cmd = this.getToken(in);
                    if (cmd.equalsIgnoreCase("domain-range")) {
                        ATermAppl domain = this.getTerm(in);
                        ATermAppl range = this.getTerm(in);
                        this.kb.addDomain(r, domain);
                        this.kb.addRange(r, range);
                        if (DEBUG) {
                            System.out.println("DOMAIN-RANGE " + r + " " + domain + " " + range);
                        }
                    } else {
                        throw new RuntimeException("Invalid role spec");
                    }
                    this.parseToken(in, 41);
                }
            } else if (str.equalsIgnoreCase("DEFINE-PRIMITIVE-CONCEPT") || str.equalsIgnoreCase("DEFPRIMCONCEPT")) {
                c = this.getTerm(in);
                this.kb.addClass(c);
                ATermAppl expr = null;
                if (!this.peekToken(in, 41)) {
                    expr = this.parseExpr(in);
                    this.kb.addClass(expr);
                    this.kb.addSubClass(c, expr);
                }
                if (DEBUG) {
                    System.out.println("DEFINE-PRIMITIVE-CONCEPT " + c + " " + (expr == null ? "" : expr.toString()));
                }
            } else if (str.equalsIgnoreCase("DEFINE-DISJOINT-PRIMITIVE-CONCEPT")) {
                c = this.getTerm(in);
                this.kb.addClass(c);
                this.parseToken(in, 40);
                while (!this.peekToken(in, 41)) {
                    ATermAppl expr = this.parseExpr(in);
                    if (ATermUtils.isPrimitive(expr)) {
                        this.kb.addClass(expr);
                    }
                    List tboxAxioms = this.kb.getTBox().getAxioms();
                    int size = tboxAxioms.size();
                    for (int i = 0; i < size; ++i) {
                        ATermAppl axiom = (ATermAppl)tboxAxioms.get(i);
                        if (!axiom.getAFun().equals(ATermUtils.SUBFUN)) continue;
                        ATermAppl d = (ATermAppl)axiom.getArgument(0);
                        ATermAppl e = (ATermAppl)axiom.getArgument(1);
                        if (!e.equals(expr)) continue;
                        tboxAxioms.add(ATermUtils.makeSub(c, ATermUtils.makeNot(d)));
                        if (!DEBUG) continue;
                        System.out.println("DEFINE-DISJOINT-CONCEPT " + c + " " + d);
                    }
                }
                this.parseToken(in, 41);
                ATermAppl expr = this.parseExpr(in);
                this.kb.addSubClass(c, expr);
                if (DEBUG) {
                    System.out.println("DEFINE-DISJOINT-PRIMITIVE-CONCEPT " + c + " " + expr);
                }
            } else if (str.equalsIgnoreCase("DEFINE-CONCEPT") || str.equalsIgnoreCase("DEFCONCEPT")) {
                c = this.getTerm(in);
                this.kb.addClass(c);
                ATermAppl expr = this.parseExpr(in);
                this.kb.addSameClass(c, expr);
                if (DEBUG) {
                    System.out.println("DEFINE-CONCEPT " + c + " " + expr);
                }
            } else if (str.equalsIgnoreCase("IMPLIES")) {
                ATermAppl c1 = this.parseExpr(in);
                ATermAppl c2 = this.parseExpr(in);
                this.kb.addClass(c1);
                this.kb.addClass(c2);
                this.kb.addSubClass(c1, c2);
                if (DEBUG) {
                    System.out.println("IMPLIES " + c1 + " " + c2);
                }
            } else if (str.equalsIgnoreCase("DISJOINT")) {
                ATermAppl[] list = this.parseExprList(in);
                for (int i = 0; i < list.length - 1; ++i) {
                    ATermAppl c1 = list[i];
                    for (int j = i + 1; j < list.length; ++j) {
                        ATermAppl c2 = list[j];
                        this.kb.addDisjointClass(c1, c2);
                        if (!DEBUG) continue;
                        System.out.println("DISJOINT " + c1 + " " + c2);
                    }
                }
            } else {
                throw new RuntimeException("Unknown command " + str);
            }
            this.parseToken(in, 41);
            token = in.nextToken();
        }
    }

    public void doAllTBoxTests(String dirName) throws Exception {
        File dir = new File(dirName);
        String[] files = dir.list(kbFilter);
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") ");
            int index = files[i].indexOf(46);
            String file = files[i].substring(0, index);
            try {
                this.doTBoxTest(dirName + file);
                continue;
            }
            catch (TimeoutException e) {
                System.out.println(" ** Timeout: " + e.getMessage() + " ** ");
                continue;
            }
            catch (UnsupportedFeatureException e) {
                System.out.println(" ** Unsupported: " + e.getMessage() + " ** ");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ** Out of Memory ** ");
                continue;
            }
            catch (StackOverflowError e) {
                System.out.println(" ** Stack Overflow ** ");
                continue;
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public void doTBoxTest(String file) throws Exception {
        long time = System.currentTimeMillis();
        int index = file.indexOf(46);
        if (index != -1) {
            file = file.substring(0, index);
        }
        String displayName = (index = file.lastIndexOf(File.separator)) == -1 ? file : file.substring(index + 1);
        this.kb = this.initKB(TBOX_LIMIT);
        StreamTokenizer in = this.initTokenizer(file + ".tkb");
        System.out.print(displayName + " ");
        this.readTBox(in);
        System.out.print("preparing...");
        this.kb.prepare();
        System.out.print("classifying...");
        this.kb.classify();
        if (DEBUG) {
            this.kb.printClassTree();
        }
        System.out.print("verifying...");
        this.verifyTBox(this.initTokenizer(file + ".tree"));
        System.out.print("done ");
        time = System.currentTimeMillis() - time;
        System.out.println(time);
        if (PRINT_TIME) {
            this.kb.timers.print();
        }
    }

    public void verifyTBox(StreamTokenizer in) throws Exception {
        int verifiedCount = 0;
        int token = in.nextToken();
        while (token != 41 && token != -1) {
            ATermAppl t;
            int i;
            ATermAppl[] terms;
            this.assertTrue(token == 40);
            ++verifiedCount;
            ATermAppl c = null;
            if (this.peekToken(in, 40)) {
                ATermAppl[] list = this.parseExprList(in);
                c = list[0];
            } else {
                c = this.parseExpr(in);
            }
            Set supers = SetUtils.union(this.kb.getSuperClasses(c, true));
            Set subs = SetUtils.union(this.kb.getSubClasses(c, true));
            if (DEBUG) {
                System.out.println("Verify " + c + " " + supers + " " + subs);
            }
            if (this.peekToken(in, 40)) {
                terms = this.parseExprList(in);
                for (i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (supers.contains(t)) continue;
                    throw new RuntimeException(t + " is not a superclass of " + c);
                }
            } else {
                this.skipToken(in);
            }
            if (this.peekToken(in, 40)) {
                terms = this.parseExprList(in);
                for (i = 0; i < terms.length; ++i) {
                    t = terms[i];
                    if (subs.contains(t)) continue;
                    HashSet temp = new HashSet(subs);
                    Set sames = this.kb.getEquivalentClasses(t);
                    temp.retainAll(sames);
                    if (temp.size() != 0) continue;
                    throw new RuntimeException(t + " is not a subclass of " + c);
                }
            }
            this.skipToken(in);
            token = in.nextToken();
        }
        this.assertTrue(in.nextToken() == -1);
    }

    public void doAllSatTests(String dirName) throws Exception {
        File dir = new File(dirName);
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") " + files[i] + " ");
            try {
                int count = this.doSatTest(dirName + files[i]);
                System.out.println(count);
                continue;
            }
            catch (TimeoutException e) {
                System.out.println(" ** Timeout ** ");
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ** Out of Memory ** ");
                System.out.println();
                continue;
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public int doSatTest(String file) throws Exception {
        StreamTokenizer in = this.initTokenizer(file);
        boolean result = file.endsWith("_n.alc");
        for (int count = 0; count < 21; ++count) {
            this.kb = this.initKB(SAT_LIMIT);
            ATermAppl c = this.parseExpr(in);
            long time = System.currentTimeMillis();
            boolean sat = this.kb.isSatisfiable(c);
            time = System.currentTimeMillis() - time;
            if (sat != result) {
                throw new RuntimeException("Consistency error");
            }
            System.out.print("(" + (count + 1) + ":" + time + ")");
        }
        return 21;
    }

    public void readABox(StreamTokenizer in) throws Exception {
        int token = in.nextToken();
        while (token != -1 && token != 41) {
            ATermAppl x;
            this.assertTrue(token == 40);
            String str = this.getToken(in);
            if (str.equalsIgnoreCase("INSTANCE")) {
                x = this.getTerm(in);
                ATermAppl c = this.parseExpr(in);
                this.kb.addIndividual(x);
                this.kb.addType(x, c);
                if (DEBUG) {
                    System.out.println("INSTANCE " + x + " " + c);
                }
            } else if (str.equalsIgnoreCase("RELATED")) {
                x = this.getTerm(in);
                ATermAppl y = this.getTerm(in);
                ATermAppl r = this.getTerm(in);
                this.kb.addIndividual(x);
                this.kb.addIndividual(y);
                this.kb.addObjectPropertyValue(r, x, y);
                if (DEBUG) {
                    System.out.println("RELATED " + x + " - " + r + " -> " + y);
                }
            } else {
                throw new RuntimeException("Unknown command " + str);
            }
            this.parseToken(in, 41);
            token = in.nextToken();
        }
    }

    public int doABoxTest(String file) throws Exception {
        return this.doABoxTest(file, -1);
    }

    public int doABoxTest(String file, int skipExcept) throws Exception {
        int count;
        StreamTokenizer in = this.initTokenizer(file);
        this.parseToken(in, 40);
        int index = file.indexOf(46);
        if (index != -1) {
            file = file.substring(0, index);
        }
        String displayName = (index = file.lastIndexOf(File.separator)) == -1 ? file : file.substring(index + 1);
        System.out.print(displayName + " ");
        for (count = 0; count < 21; ++count) {
            boolean skip = skipExcept != -1 && count == skipExcept;
            this.kb = this.initKB(ABOX_LIMIT);
            if (skip) break;
            this.parseToken(in, 40);
            this.parseToken(in, 40);
            this.readTBox(in);
            this.parseToken(in, 40);
            this.readABox(in);
            long time = System.currentTimeMillis();
            if (!skip && !FAST) {
                this.kb.realize();
            }
            if (DEBUG) {
                this.kb.printClassTree();
            }
            this.parseToken(in, 40);
            int token = in.nextToken();
            while (token != -1 && token != 41) {
                this.assertTrue(token == 40);
                String str = this.getToken(in);
                if (str.equalsIgnoreCase("INDIVIDUAL-INSTANCE?")) {
                    ATermAppl x = this.getTerm(in);
                    ATermAppl c = this.parseExpr(in);
                    if (DEBUG) {
                        System.out.println("INDIVIDUAL-INSTANCE? " + x + " " + c);
                    }
                    if (c.getName().equals("C24")) {
                        System.out.print("");
                    }
                    if (!skip && !this.kb.isType(x, c)) {
                        throw new RuntimeException("Individual " + x + " is not an instance of " + c);
                    }
                } else {
                    throw new RuntimeException("Unknown command " + str);
                }
                this.parseToken(in, 41);
                token = in.nextToken();
            }
            this.parseToken(in, 41);
            time = System.currentTimeMillis() - time;
            System.out.print("(" + (count + 1) + ": " + (double)time / 1000.0 + ")");
        }
        System.out.println("done.");
        return count;
    }

    public void doAllABoxTests(String dirName) throws Exception {
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
        for (int i = 0; i < files.length; ++i) {
            System.out.print(i + 1 + ") ");
            try {
                int count = this.doABoxTest(files[i].getAbsolutePath(), -1);
                System.out.println(count);
                continue;
            }
            catch (TimeoutException e) {
                System.out.println(" ***** Timeout ***** ");
                System.out.println();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.out.println();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.out.println(" ***** Out of Memory ***** ");
                System.out.println();
                continue;
            }
            catch (Error e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void usage() {
        System.out.println("DLTest - Run the tests in DL-benchmark suite");
        System.out.println("");
        System.out.println("Usage: java DLTest <input> <type>");
        System.out.println("   input    A single file or a directory that contains");
        System.out.println("            a set of test files");
        System.out.println("   type     Type of the test, one of [sat, tbox, abox]");
    }

    public static final void main(String[] args) throws Exception {
        if (args.length != 2) {
            DLTest.usage();
            return;
        }
        String in = args[0];
        String type = args[1];
        File file = new File(in);
        boolean singleTest = file.isFile();
        DLTest test = new DLTest();
        if (type.equals("abox")) {
            if (singleTest) {
                test.doSatTest(in);
            } else {
                test.doAllSatTests(in);
            }
        } else if (type.equals("tbox")) {
            if (singleTest) {
                test.doTBoxTest(in);
            } else {
                test.doAllTBoxTests(in);
            }
        } else if (type.equals("sat")) {
            if (singleTest) {
                test.doABoxTest(in);
            } else {
                test.doAllABoxTests(in);
            }
        } else {
            DLTest.usage();
        }
    }
}

