/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.BitSet;

public class DependencySet {
    public static final int NO_BRANCH = -1;
    public static final DependencySet EMPTY = new DependencySet();
    public static final DependencySet INDEPENDENT = new DependencySet(0);
    private BitSet depends;
    int branch = -1;

    private DependencySet() {
        this.depends = new BitSet();
    }

    public DependencySet(int branch) {
        this.depends = new BitSet();
        this.depends.set(branch);
    }

    public DependencySet(BitSet depends) {
        this.depends = depends;
    }

    public DependencySet copy() {
        return new DependencySet(this.depends);
    }

    public boolean contains(int b) {
        return this.depends.get(b);
    }

    public void add(int b) {
        this.depends.set(b);
    }

    public void remove(int b) {
        this.depends.clear(b);
    }

    public int size() {
        return this.depends.cardinality();
    }

    public int max() {
        return this.depends.length() - 1;
    }

    public boolean isEmpty() {
        return this.depends.isEmpty();
    }

    public DependencySet union(DependencySet ds) {
        BitSet newDepends = (BitSet)this.depends.clone();
        newDepends.or(ds.depends);
        return new DependencySet(newDepends);
    }

    public String toString() {
        return "[" + this.branch + "-" + this.depends.toString() + "]";
    }
}

