/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

class DisjunctionBranch
extends Branch {
    ATermAppl disjunction;
    ATerm[] disj;
    int[] order;

    DisjunctionBranch(ABox abox, Individual x, ATermAppl disjunction, DependencySet ds, ATerm[] disj) {
        super(abox, x, ds, disj.length);
        this.disjunction = disjunction;
        this.disj = disj;
        this.order = new int[disj.length];
        for (int i = 0; i < disj.length; ++i) {
            this.order[i] = i;
        }
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual(this.node.getName());
        DisjunctionBranch b = new DisjunctionBranch(abox, x, this.disjunction, this.termDepends, this.disj);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tryBranch() {
        this.abox.incrementBranch();
        int[] stats = (int[])this.abox.disjBranchStats.get(this.disjunction);
        if (this.tryNext > 0) {
            if (stats == null) {
                stats = new int[this.disj.length];
                for (int i = 0; i < this.disj.length; ++i) {
                    stats[i] = 0;
                }
                this.abox.disjBranchStats.put(this.disjunction, stats);
            }
            int n = this.order[this.tryNext - 1];
            stats[n] = stats[n] + 1;
        }
        if (stats != null) {
            int minIndex = this.tryNext;
            int minValue = stats[this.tryNext];
            for (int i = this.tryNext + 1; i < stats.length; ++i) {
                if (stats[i] >= minValue) continue;
                minIndex = i;
                minValue = stats[i];
            }
            if (minIndex != this.tryNext) {
                ATerm selDisj = this.disj[minIndex];
                this.disj[minIndex] = this.disj[this.tryNext];
                this.disj[this.tryNext] = selDisj;
                this.order[minIndex] = this.tryNext;
                this.order[this.tryNext] = minIndex;
            }
        }
        while (this.tryNext < this.tryCount) {
            ATermAppl d = (ATermAppl)this.disj[this.tryNext];
            if (ABox.DEBUG) {
                System.out.println("DISJ: (" + (this.tryNext + 1) + "/" + this.tryCount + ") at branch (" + this.branch + ") " + this.node.getName() + " " + d + " " + this.disjunction);
            }
            if (PelletOptions.USE_SEMANTIC_BRANCHING) {
                for (int m = 0; m < this.tryNext; ++m) {
                    this.node.addType(ATermUtils.negate((ATermAppl)this.disj[m]), this.prevDS[m]);
                }
            }
            DependencySet ds = null;
            if (this.tryNext == this.tryCount - 1) {
                ds = this.termDepends;
                for (int m = 0; m < this.tryNext; ++m) {
                    ds = ds.union(this.prevDS[m]);
                }
                ds.remove(this.branch);
            } else {
                ds = new DependencySet(this.branch);
            }
            ATermAppl notD = ATermUtils.negate(d);
            DependencySet clashDepends = this.node.getDepends(notD);
            if (clashDepends == null) {
                this.node.addType(d, ds);
                if (this.abox.isClosed()) {
                    clashDepends = this.abox.getClash().depends;
                }
            } else {
                clashDepends = clashDepends.union(ds);
            }
            if (clashDepends == null) return true;
            if (ABox.DEBUG) {
                System.out.println("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!");
            }
            if (stats == null) {
                stats = new int[this.disj.length];
                for (int i = 0; i < this.disj.length; ++i) {
                    stats[i] = 0;
                }
                this.abox.disjBranchStats.put(this.disjunction, stats);
            }
            int n = this.order[this.tryNext];
            stats[n] = stats[n] + 1;
            if (this.tryNext < this.tryCount - 1 && clashDepends.contains(this.branch)) {
                if (this.abox.isClosed()) {
                    this.restore();
                    this.abox.incrementBranch();
                }
            } else {
                if (this.abox.doExplanation()) {
                    ATermAppl positive = ATermUtils.isNot(notD) ? d : notD;
                    this.abox.setClash(Clash.atomic(this.node, clashDepends.union(ds), positive));
                    return false;
                } else {
                    this.abox.setClash(Clash.atomic(this.node, clashDepends.union(ds)));
                }
                return false;
            }
            this.prevDS[this.tryNext] = clashDepends;
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }
}

