/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Blocking;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;

public class EconnDoubleBlocking
extends Blocking {
    private ABox abox;

    public EconnDoubleBlocking(ABox a) {
        this.abox = a;
    }

    public boolean isDirectlyBlocked(Individual x, Set ancestors) {
        EdgeList l = x.getInEdges();
        boolean linkSuccessor = false;
        if (!l.isEmpty()) {
            Edge e = l.edgeAt(0);
            linkSuccessor = e.getRole().isLinkRole();
        }
        Iterator i = ancestors.iterator();
        Iterator predecessors = x.getPredecessors().iterator();
        if (linkSuccessor) {
            while (i.hasNext()) {
                Individual y = (Individual)i.next();
                if (y.isRoot() || !this.linkBlockingCondition(x, y)) continue;
                return true;
            }
        } else if (((EconnectedKB)this.abox.getKB()).getEconnExpressivity().getInverses().get(x.getOntology()) == Boolean.FALSE) {
            while (i.hasNext()) {
                Individual y = (Individual)i.next();
                if (y.isRoot() || x.equals(y) || !this.blockingCondition5(x, y)) continue;
                return true;
            }
        } else if (((EconnectedKB)this.abox.getKB()).getEconnExpressivity().getCardinality().get(x.getOntology()) == Boolean.FALSE) {
            while (i.hasNext()) {
                Individual y = (Individual)i.next();
                if (y.isRoot() || !this.blockingCondition1(x, y)) continue;
                return true;
            }
        } else {
            while (predecessors.hasNext()) {
                Individual x1 = (Individual)predecessors.next();
                while (i.hasNext()) {
                    Individual y = (Individual)i.next();
                    if (y.isRoot()) continue;
                    Iterator y1s = y.getPredecessors().iterator();
                    while (y1s.hasNext()) {
                        Individual y1 = (Individual)y1s.next();
                        if (x.equals(y) || y.equals(y1) || !this.blockCondition2(x, x1, y, y1) || !this.blockCondition3(x, x1, y, y1) || !this.blockCondition4(x, x1, y, y1)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean linkBlockingCondition(Individual x, Individual y) {
        return this.equals(x, y);
    }

    protected boolean blockingCondition1(Individual x, Individual y) {
        return this.equals(x, y);
    }

    protected boolean blockingCondition5(Individual x, Individual y) {
        return this.subset(x, y);
    }

    protected boolean blockCondition2(Individual x, Individual x1, Individual y, Individual y1) {
        return this.equals(x, y) && this.equals(y1, x1);
    }

    protected boolean blockCondition4(Individual x, Individual x1, Individual y, Individual y1) {
        return x.getOntology() == y.getOntology() && x1.getOntology() == y1.getOntology();
    }

    protected boolean blockCondition3(Individual x, Individual x1, Individual y, Individual y1) {
        EdgeList xEdges = x1.getEdgesTo(x);
        EdgeList yEdges = y1.getEdgesTo(y);
        for (int i = 0; i < xEdges.size(); ++i) {
            if (yEdges.hasEdge(xEdges.edgeAt(i).getRole())) continue;
            return false;
        }
        return true;
    }
}

