/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TgBox;
import org.mindswap.pellet.TuBox;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;

public class EconnExpressivity {
    EconnectedKB kb;
    Map hasInverse;
    Map hasCardinality;
    Map hasFunctionality;
    Map hasTransitivity;
    Map hasRoleHierarchy;
    Map hasDatatype;
    Map hasNominal;
    Map hasNegation;
    Map hasUnion;
    Map hasInverseLink;
    Map hasCardinalityOnLink;
    Map hasLinkHierarchy;
    Map hasLinkFunctionality;
    String currOnt;
    public Set allNominals;
    Visitor visitor;

    EconnExpressivity(EconnectedKB kb) {
        this.kb = kb;
        this.hasInverse = new HashMap();
        this.hasCardinality = new HashMap();
        this.hasFunctionality = new HashMap();
        this.hasTransitivity = new HashMap();
        this.hasRoleHierarchy = new HashMap();
        this.hasDatatype = new HashMap();
        this.hasNominal = new HashMap();
        this.hasNegation = new HashMap();
        this.hasUnion = new HashMap();
        this.hasInverseLink = new HashMap();
        this.hasCardinalityOnLink = new HashMap();
        this.hasLinkHierarchy = new HashMap();
        this.hasLinkFunctionality = new HashMap();
        this.allNominals = new HashSet();
        this.currOnt = null;
    }

    public void init() {
        Iterator i = this.kb.getTBoxes().keySet().iterator();
        while (i.hasNext()) {
            String ontology = (String)i.next();
            this.hasInverse.put(ontology, Boolean.FALSE);
            this.hasDatatype.put(ontology, Boolean.FALSE);
            this.hasCardinality.put(ontology, Boolean.FALSE);
            this.hasFunctionality.put(ontology, Boolean.FALSE);
            this.hasTransitivity.put(ontology, Boolean.FALSE);
            this.hasRoleHierarchy.put(ontology, Boolean.FALSE);
            this.hasNegation.put(ontology, Boolean.FALSE);
            this.hasUnion.put(ontology, Boolean.FALSE);
            this.hasInverseLink.put(ontology, Boolean.FALSE);
            this.hasCardinalityOnLink.put(ontology, Boolean.FALSE);
            this.hasLinkHierarchy.put(ontology, Boolean.FALSE);
            this.hasLinkFunctionality.put(ontology, Boolean.FALSE);
        }
        this.visitor = new Visitor();
    }

    public void compute() {
        this.init();
        this.processClasses();
        this.processRoles();
    }

    protected void processRoles() {
        Iterator iter = this.kb.getRBoxes().keySet().iterator();
        while (iter.hasNext()) {
            this.currOnt = (String)iter.next();
            this.kb.setOntology(this.currOnt);
            RBox t = this.kb.getRBox();
            Iterator i = t.getRoles().iterator();
            while (i.hasNext()) {
                Role r = (Role)i.next();
                if (r.isDatatypeRole()) {
                    this.hasDatatype.put(this.currOnt, Boolean.TRUE);
                }
                if (!r.isAnon() && r.hasNamedInverse()) {
                    if (r.isObjectRole()) {
                        this.hasInverse.put(this.currOnt, Boolean.TRUE);
                    }
                    if (r.isLinkRole()) {
                        this.hasInverseLink.put(this.currOnt, Boolean.TRUE);
                    }
                }
                if (r.isAnon() && r.isFunctional()) {
                    if (r.isObjectRole()) {
                        this.hasInverse.put(this.currOnt, Boolean.TRUE);
                    }
                    if (r.isLinkRole()) {
                        this.hasInverseLink.put(this.currOnt, Boolean.TRUE);
                    }
                }
                if (r.isFunctional()) {
                    if (r.isObjectRole()) {
                        this.hasFunctionality.put(this.currOnt, Boolean.TRUE);
                    }
                    if (r.isLinkRole()) {
                        this.hasLinkFunctionality.put(this.currOnt, Boolean.TRUE);
                    }
                }
                if (r.isTransitive()) {
                    this.hasTransitivity.put(this.currOnt, Boolean.TRUE);
                }
                if (r.getSubRoles().size() <= 1) continue;
                if (r.isObjectRole()) {
                    this.hasRoleHierarchy.put(this.currOnt, Boolean.TRUE);
                }
                if (!r.isLinkRole()) continue;
                this.hasLinkHierarchy.put(this.currOnt, Boolean.TRUE);
            }
        }
    }

    protected void processClasses() {
        Iterator iter = this.kb.getTBoxes().keySet().iterator();
        while (iter.hasNext()) {
            this.currOnt = (String)iter.next();
            this.kb.setOntology(this.currOnt);
            TBox t = this.kb.getTBox();
            TgBox Tg = t.Tg;
            TuBox Tu = t.Tu;
            if (!Tg.isEmpty()) {
                this.hasNegation.put(this.currOnt, Boolean.TRUE);
                ATermList list = Tg.getUC();
                while (!list.isEmpty()) {
                    this.visitor.visit((ATermAppl)list.getFirst());
                    list = list.getNext();
                }
            }
            Iterator i = Tu.normalizedMap.values().iterator();
            while (i.hasNext() && (this.hasNegation.get(this.currOnt).equals(Boolean.FALSE) || this.hasCardinality.get(this.currOnt).equals(Boolean.FALSE))) {
                ATermAppl term = (ATermAppl)i.next();
                this.visitor.visit(term);
            }
        }
    }

    public String toString() {
        HashMap<String, String> dl = new HashMap<String, String>();
        String result = "";
        if (this.kb.getTBoxes().size() > 1) {
            result = "C(";
        }
        String link = "";
        boolean inverselink = false;
        boolean linkhierarchy = false;
        boolean linkcardinality = false;
        boolean linkfunctionality = false;
        Iterator i = this.kb.getTBoxes().keySet().iterator();
        while (i.hasNext()) {
            String aux;
            String ontology = (String)i.next();
            String s = this.hasNegation.get(ontology) == Boolean.TRUE || this.hasUnion.get(ontology) == Boolean.TRUE ? "ALC" : "AL";
            dl.put(ontology, s);
            if (this.hasTransitivity.get(ontology) == Boolean.TRUE) {
                String str = "R+";
                aux = (String)dl.get(ontology);
                aux = aux + "R+";
                dl.put(ontology, aux);
            }
            if (this.hasRoleHierarchy.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "H";
                dl.put(ontology, aux);
            }
            if (this.hasInverse.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "I";
                dl.put(ontology, aux);
            }
            if (this.hasNominal.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "O";
                dl.put(ontology, aux);
            }
            if (this.hasCardinality.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "N";
                dl.put(ontology, aux);
            } else if (this.hasFunctionality.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "F";
                dl.put(ontology, aux);
            }
            if (this.hasDatatype.get(ontology) == Boolean.TRUE) {
                aux = (String)dl.get(ontology);
                aux = aux + "(D)";
                dl.put(ontology, aux);
            }
            if (((String)dl.get(ontology)).startsWith("ALCR+")) {
                aux = (String)dl.get(ontology);
                int index = aux.lastIndexOf("+");
                aux = aux.substring(index + 1);
                String str = "S";
                aux = str.concat(aux);
                dl.put(ontology, aux);
            }
            if (this.hasInverseLink.get(ontology) == Boolean.TRUE) {
                inverselink = true;
            }
            if (this.hasLinkHierarchy.get(ontology) == Boolean.TRUE) {
                linkhierarchy = true;
            }
            if (this.hasCardinalityOnLink.get(ontology) == Boolean.TRUE) {
                linkcardinality = true;
            }
            if (this.hasLinkFunctionality.get(ontology) == Boolean.TRUE) {
                linkfunctionality = true;
            }
            result = result + dl.get(ontology);
            if (i.hasNext()) {
                result = result + ",";
            }
            if (!KnowledgeBase.DEBUG) continue;
            System.out.println("Expressivity of the component ontology " + ontology + " is: " + dl.get(ontology));
        }
        if (this.kb.getTBoxes().size() > 1) {
            result = result + ")";
        }
        if (inverselink) {
            link = link + "I";
        }
        if (linkhierarchy) {
            link = link + "H";
        }
        if (linkcardinality) {
            link = link + "N";
        } else if (linkfunctionality) {
            link = link + "F";
        }
        if (KnowledgeBase.DEBUG) {
            System.out.println("Expressivity of the links is: " + link);
        }
        result = result.concat(link);
        return result;
    }

    public boolean hasInverses() {
        return this.hasInverseLink.containsValue(Boolean.TRUE);
    }

    public boolean hasLinkNumberRestrictions() {
        return this.hasCardinalityOnLink.containsValue(Boolean.TRUE);
    }

    public boolean hasLinkFunctionalRestrictions() {
        return this.hasLinkFunctionality.containsValue(Boolean.TRUE);
    }

    public Map getNominals() {
        return this.hasNominal;
    }

    public Map getInverses() {
        return this.hasInverse;
    }

    public Map getCardinality() {
        return this.hasCardinality;
    }

    public void setHasNominal(String foreignOnt) {
        this.hasNominal.put(foreignOnt, Boolean.TRUE);
    }

    public void setHasTransitivity(String ont) {
        this.hasTransitivity.put(ont, Boolean.TRUE);
    }

    public boolean hasNominal(String ontology) {
        return this.hasNominal.get(ontology) == Boolean.TRUE;
    }

    public void setHasNegation(String ont) {
        this.hasNegation.put(ont, Boolean.TRUE);
    }

    public void setHasUnion(String ont) {
        this.hasUnion.put(ont, Boolean.TRUE);
    }

    class Visitor
    extends ATermBaseVisitor
    implements ATermVisitor {
        Visitor() {
        }

        public void visitTerm(ATermAppl term) {
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitOr(ATermAppl term) {
            EconnExpressivity.this.hasNegation.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitNot(ATermAppl term) {
            EconnExpressivity.this.hasNegation.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitSome(ATermAppl term) {
            ATermAppl aux = (ATermAppl)term.getArgument(0);
            if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                Role r = EconnExpressivity.this.kb.getRole(aux);
                EconnExpressivity.this.currOnt = r.getForeignOntology();
            }
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitAll(ATermAppl term) {
            ATermAppl aux = (ATermAppl)term.getArgument(0);
            if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                Role r = EconnExpressivity.this.kb.getRole(aux);
                EconnExpressivity.this.currOnt = r.getForeignOntology();
            }
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitMin(ATermAppl term) {
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl aux = (ATermAppl)term.getArgument(0);
            if (cardinality > 2) {
                if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                    EconnExpressivity.this.hasCardinalityOnLink.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                } else {
                    EconnExpressivity.this.hasCardinality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                }
            } else if (cardinality > 0) {
                if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                    EconnExpressivity.this.hasLinkFunctionality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                } else {
                    EconnExpressivity.this.hasFunctionality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                }
            }
        }

        public void visitMax(ATermAppl term) {
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            ATermAppl aux = (ATermAppl)term.getArgument(0);
            if (cardinality > 1) {
                if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                    EconnExpressivity.this.hasCardinalityOnLink.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                } else {
                    EconnExpressivity.this.hasCardinality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                }
            } else if (cardinality > 0) {
                if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                    EconnExpressivity.this.hasLinkFunctionality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                } else {
                    EconnExpressivity.this.hasFunctionality.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
                }
            }
        }

        public void visitHasValue(ATermAppl term) {
            ATermAppl aux = (ATermAppl)term.getArgument(0);
            if (EconnExpressivity.this.kb.isLinkProperty(aux)) {
                Role r = EconnExpressivity.this.kb.getRole(aux);
                EconnExpressivity.this.currOnt = r.getForeignOntology();
            }
            EconnExpressivity.this.hasNominal.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
        }

        public void visitValue(ATermAppl term) {
        }

        public void visitOneOf(ATermAppl term) {
            EconnExpressivity.this.hasNegation.put(EconnExpressivity.this.currOnt, Boolean.TRUE);
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitSubClass(ATermAppl term) {
        }
    }
}

