/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.EconnExpressivity;
import org.mindswap.pellet.EconnSHIONStrategy;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PECSHIONStrategy;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyBuilder;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.utils.ATermUtils;

public class EconnectedKB
extends KnowledgeBase {
    private Map tboxes = new HashMap();
    private Map rboxes = new HashMap();
    Map classif = new HashMap();
    boolean checkAll;
    private Set numberRestrictions;
    private EconnExpressivity expressive = new EconnExpressivity(this);

    public EconnectedKB() {
        this.expressive.init();
        this.classif = new HashMap();
        this.checkAll = true;
        this.numberRestrictions = new HashSet();
    }

    public TBox getTBox(String ont) {
        return (TBox)this.tboxes.get(ont);
    }

    public RBox getRBox(String ont) {
        return (RBox)this.rboxes.get(ont);
    }

    public Map getTBoxes() {
        return this.tboxes;
    }

    public boolean getCheckAll() {
        return this.checkAll;
    }

    public Map getRBoxes() {
        return this.rboxes;
    }

    public EconnExpressivity getEconnExpressivity() {
        this.prepare();
        return this.expressive;
    }

    public void setOntology(String ont) {
        if (!this.tboxes.containsKey(ont)) {
            throw new InternalReasonerException("Ontology " + ont + " does not exist in the EconnectedKB!");
        }
        super.setOntology(ont);
        this.setTBox((TBox)this.tboxes.get(ont));
        this.setRBox((RBox)this.rboxes.get(ont));
        this.taxonomy = (Taxonomy)this.classif.get(ont);
    }

    public void addOntology(String ont) {
        TBox t = new TBox(this);
        RBox r = new RBox();
        this.tboxes.put(ont, t);
        this.rboxes.put(ont, r);
    }

    public void addLinkProperty(ATerm p) {
        this.status = 4;
        this.rbox.addLinkRole((ATermAppl)p);
        if (DEBUG) {
            System.out.println("link-prop " + p);
        }
    }

    public boolean isLinkProperty(ATerm p) {
        return this.getPropertyType(p) == 5;
    }

    public boolean isProperty(ATerm p) {
        boolean result = false;
        Iterator i = this.rboxes.values().iterator();
        while (i.hasNext()) {
            RBox rbox = (RBox)i.next();
            if (!rbox.isRole(p)) continue;
            result = true;
        }
        return result;
    }

    public void addInverseLink(Role roleS, Role roleR) {
        this.status |= 4;
        roleR.setInverse(roleS);
        roleS.setInverse(roleR);
        if (DEBUG) {
            System.out.println("inv-prop " + roleR.getName() + " " + roleS.getName());
        }
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            throw new UnsupportedFeatureException(c1 + " is not a valid class expression");
        }
        if (!this.isClass(c2)) {
            throw new UnsupportedFeatureException(c2 + " is not a valid class expression");
        }
        if (c1.equals(c2)) {
            return true;
        }
        if (this.isClassified() && ATermUtils.isPrimitive(c1) && ATermUtils.isPrimitive(c2)) {
            return this.taxonomy.isSubClassOf(c1, c2);
        }
        return this.abox.isSubClassOf(c1, c2);
    }

    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            throw new UnsupportedFeatureException(t1 + " is not an individual!");
        }
        if (ind2 == null) {
            throw new UnsupportedFeatureException(t2 + " is not an individual!");
        }
        if (ind1.getOntology() != ind2.getOntology()) {
            return false;
        }
        if (ind1.isSame(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(t2));
        return !this.isType(t1, c);
    }

    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            throw new UnsupportedFeatureException(t1 + " is not an individual!");
        }
        if (ind2 == null) {
            throw new UnsupportedFeatureException(t2 + " is not an individual!");
        }
        if (ind1.getOntology() != ind2.getOntology()) {
            return true;
        }
        if (ind1.isDifferent(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeValue(t2);
        return !this.isType(t1, c);
    }

    public void prepare() {
        if (!this.isChanged()) {
            return;
        }
        Iterator it = this.tboxes.keySet().iterator();
        while (it.hasNext()) {
            String ont = (String)it.next();
            TBox t = (TBox)this.tboxes.get(ont);
            RBox r = (RBox)this.rboxes.get(ont);
            this.timers.startTimer("Preprocessing");
            t.split();
            if (PelletOptions.PRINT_SIZE) {
                System.out.println("Ontology" + ont + "before normalization, absortion and internalization");
                System.out.println("Tu is (" + t.Tu.size() + ")");
                System.out.println("Tg was " + (t.Tg.isEmpty() ? "empty" : "(" + t.Tg.size() + ")"));
            }
            if (DEBUG) {
                System.out.println("Tu " + t.Tu);
                System.out.println("Tg " + t.Tg);
            }
            t.absorb();
            t.Tu.normalize();
            t.Tg.internalize();
            r.computeRoleHierarchy();
            if (PelletOptions.PRINT_SIZE) {
                System.out.println("Ontology" + ont + "AFTER normalization, absortion and internalization");
                System.out.println("Tg is " + (t.Tg.isEmpty() ? "empty" : "(" + t.Tg.size() + ")"));
                if (t.Tg.getUC() != null) {
                    System.out.println("UC is (" + t.Tg.getUC().getLength() + ")");
                    System.out.println("UC is " + t.Tg.getUC());
                }
            }
            if (DEBUG) {
                System.out.println("Number of classes in the Econnected KB is (" + this.getClasses().size() + ")");
            }
            Iterator i = this.getABox().getNodes().iterator();
            int count = 0;
            while (i.hasNext()) {
                Node aux = (Node)i.next();
                if (aux.getOntology() != ont) continue;
                if (DEBUG) {
                    System.out.println("The individual " + aux.getName() + "belongs to " + ont);
                }
                ++count;
            }
            if (!DEBUG) continue;
            System.out.println("Number of nodes in the ABox of the ontology " + ont + "is " + count);
        }
        this.status = 0;
        this.expressive.compute();
        this.abox.initialize();
    }

    public void classify() {
        if (this.isClassified()) {
            return;
        }
        this.prepare();
        if (DEBUG) {
            System.out.println("The Expressivity is: " + this.expressive.toString());
        }
        this.ensureConsistency();
        this.checkAll = false;
        Iterator i = this.tboxes.keySet().iterator();
        while (i.hasNext()) {
            String ontName = (String)i.next();
            this.setOntology(ontName);
            if (DEBUG) {
                System.out.println("Classifying " + ontName);
            }
            this.builder = new TaxonomyBuilder(this);
            this.taxonomy = this.builder.classify();
            this.classif.put(this.ontology, this.taxonomy);
        }
        if (DEBUG) {
            System.out.println(this.classif);
        }
        this.status |= 0x10;
    }

    public void printClassTree() {
        this.printClassTree(new OutputFormatter());
    }

    public void printClassTree(OutputFormatter out) {
        this.classify();
        Iterator j = this.classif.keySet().iterator();
        while (j.hasNext()) {
            String ont = (String)j.next();
            this.setOntology(ont);
            out.printBold("Component Ontology: ").printLink(this.ontology);
            this.taxonomy.print(out);
        }
    }

    CompletionStrategy chooseStrategy(ABox abox) {
        if (this.expressive.hasInverses()) {
            return new EconnSHIONStrategy(abox);
        }
        return new PECSHIONStrategy(abox);
    }

    private String findTBoxForClass(ATerm c) {
        Iterator i = this.tboxes.keySet().iterator();
        while (i.hasNext()) {
            String ont = (String)i.next();
            TBox tbox = (TBox)this.tboxes.get(ont);
            if (!tbox.classes.contains(c)) continue;
            return ont;
        }
        return null;
    }

    private String findRBoxForRole(ATerm r) {
        Iterator i = this.rboxes.keySet().iterator();
        while (i.hasNext()) {
            String ont = (String)i.next();
            RBox rbox = (RBox)this.rboxes.get(ont);
            if (!rbox.isRole(r)) continue;
            return ont;
        }
        return null;
    }

    Role getRole(ATerm term) {
        Iterator i = this.rboxes.values().iterator();
        while (i.hasNext()) {
            RBox rbox = (RBox)i.next();
            Role role = rbox.getRole(term);
            if (role == null) continue;
            return role;
        }
        return null;
    }

    public boolean isSatisfiable(ATermAppl c) {
        String save = this.ontology;
        if (!ATermUtils.isComplexClass(c)) {
            String ont = this.findTBoxForClass(c);
            this.setOntology(ont);
        }
        boolean sat = super.isSatisfiable(c);
        if (save != this.ontology && save != null) {
            this.setOntology(save);
        }
        return sat;
    }

    public void addDomain(ATerm p, ATermAppl c) {
        String ont = this.findRBoxForRole(p);
        this.status |= 4;
        RBox rbox = (RBox)this.rboxes.get(ont);
        Role r = rbox.getDefinedRole(p);
        r.addDomain(c);
        if (DEBUG) {
            System.out.println("domain " + p + " " + c);
        }
    }

    public void addRange(ATerm p, ATermAppl c) {
        String ont = this.findRBoxForRole(p);
        this.status |= 4;
        RBox rbox = (RBox)this.rboxes.get(ont);
        Role r = rbox.getDefinedRole(p);
        r.addRange(c);
        if (DEBUG) {
            System.out.println("range " + p + " " + c);
        }
    }

    public Set getNumberRestrictions() {
        return this.numberRestrictions;
    }
}

