/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;

public class EdgeList {
    private List list;

    public EdgeList() {
        this.list = new ArrayList();
    }

    public EdgeList(int size) {
        this.list = new ArrayList(size);
    }

    public EdgeList(EdgeList edges) {
        this.list = new ArrayList(edges.list);
    }

    public void addEdgeList(EdgeList edges) {
        if (edges == null) {
            return;
        }
        this.list.addAll(edges.list);
    }

    public void addEdge(Edge e) {
        this.list.add(e);
    }

    public void removeEdge(Edge edge) {
        this.list.remove(edge);
    }

    public Edge edgeAt(int i) {
        return (Edge)this.list.get(i);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    private EdgeList findEdges(Role role, Individual from, Node to) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = (Edge)this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            result.addEdge(e);
        }
        return result;
    }

    private boolean edgeExists(Role role, Individual from, Node to) {
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = (Edge)this.list.get(i);
            if (from != null && !from.equals(e.getFrom()) || role != null && !e.getRole().isSubRoleOf(role) || to != null && !to.equals(e.getTo())) continue;
            return true;
        }
        return false;
    }

    public EdgeList getEdgesFromTo(Individual from, Node to) {
        return this.findEdges(null, from, to);
    }

    public EdgeList getEdgesFrom(Individual from) {
        return this.findEdges(null, from, null);
    }

    public EdgeList getEdgesTo(Node to) {
        return this.findEdges(null, null, to);
    }

    public EdgeList getEdges(Role role) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = (Edge)this.list.get(i);
            if (!e.getRole().isSubRoleOf(role)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public EdgeList getEdgesContaining(Node node) {
        EdgeList result = new EdgeList();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge e = (Edge)this.list.get(i);
            if (!e.getFrom().equals(node) && !e.getTo().equals(node)) continue;
            result.addEdge(e);
        }
        return result;
    }

    public Set getPredecessors() {
        HashSet<Individual> result = new HashSet<Individual>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)this.list.get(i);
            result.add(edge.getFrom());
        }
        return result;
    }

    public Set getSuccessors() {
        HashSet<Node> result = new HashSet<Node>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)this.list.get(i);
            result.add(edge.getTo());
        }
        return result;
    }

    public Set getNeighbors(Individual node) {
        HashSet<Node> result = new HashSet<Node>();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)this.list.get(i);
            result.add(edge.getNeighbor(node));
        }
        return result;
    }

    public Set getFilteredNeighbors(Individual node) {
        HashSet<Node> result = new HashSet<Node>();
        String lang = null;
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            Edge edge = (Edge)this.list.get(i);
            Node neighbor = edge.getNeighbor(node);
            if (neighbor instanceof Literal) {
                Literal lit = (Literal)neighbor;
                if (lang == null) {
                    lang = lit.getLang();
                    result.add(neighbor);
                    continue;
                }
                if (!lang.equals(lit.getLang())) continue;
                result.add(neighbor);
                continue;
            }
            result.add(neighbor);
        }
        return result;
    }

    public boolean hasEdgeFrom(Individual from) {
        return this.edgeExists(null, from, null);
    }

    public boolean hasEdgeTo(Node to) {
        return this.edgeExists(null, null, to);
    }

    public boolean hasEdge(Role role) {
        return this.edgeExists(role, null, null);
    }

    public boolean hasEdge(Edge e) {
        return this.edgeExists(e.getRole(), e.getFrom(), e.getTo());
    }

    public String toString() {
        return this.list.toString();
    }
}

