/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MaxBranch;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.OptimizedBlocking;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class EmptySHINStrategy
extends CompletionStrategy {
    Vector mayNeedExpandingList;
    LinkedList mayNeedExpanding;

    public EmptySHINStrategy(ABox abox) {
        super(abox, new OptimizedBlocking());
    }

    ABox complete() {
        if (ABox.DEBUG) {
            System.out.println("************  EmptySHINStrategy  ************");
        }
        if (this.abox.getNodes().isEmpty()) {
            this.abox.setComplete(true);
            return this.abox;
        }
        this.mayNeedExpanding = new LinkedList();
        this.mayNeedExpandingList = new Vector();
        Individual root = (Individual)this.abox.getNodes().iterator().next();
        this.mayNeedExpanding.add(root);
        while (!this.abox.isComplete() && !this.abox.isClosed()) {
            Node next;
            if (this.mayNeedExpanding.isEmpty()) {
                this.abox.setComplete(true);
                break;
            }
            if (ABox.DEBUG) {
                this.abox.printTree();
            }
            if ((next = (Node)this.mayNeedExpanding.removeFirst()) instanceof Literal) continue;
            Individual x = (Individual)next;
            if (this.parentNeedsExpanding(x)) {
                this.mayNeedExpanding.removeAll(x.getParent().getDescendants());
                this.mayNeedExpanding.addFirst(x.getParent());
                continue;
            }
            this.applyUnfoldingRule(x);
            if (this.restart()) continue;
            if (this.parentNeedsExpanding(x)) {
                this.mayNeedExpanding.removeAll(x.getParent().getDescendants());
                this.mayNeedExpanding.addFirst(x.getParent());
                continue;
            }
            if (x.canApply(Node.OR)) {
                this.applyDisjunctionRule(x);
                if (this.abox.isClosed()) {
                    this.restart();
                    continue;
                }
                this.mayNeedExpanding.addFirst(x);
                continue;
            }
            this.applyMaxRule(x);
            if (this.restart() || this.blocking.isDirectlyBlocked(x, x.getAncestors())) continue;
            this.applySomeValuesRule(x);
            if (this.restart()) continue;
            this.applyMinRule(x);
            if (this.restart()) continue;
            if (this.parentNeedsExpanding(x)) {
                this.mayNeedExpanding.removeAll(x.getParent().getDescendants());
                this.mayNeedExpanding.addFirst(x.getParent());
                continue;
            }
            this.applyMaxRule(x);
            if (this.restart()) continue;
            if (this.parentNeedsExpanding(x)) {
                this.mayNeedExpanding.removeAll(x.getParent().getDescendants());
                this.mayNeedExpanding.addFirst(x.getParent());
                continue;
            }
            this.mayNeedExpanding.addAll(x.getSuccessors());
        }
        return this.abox;
    }

    public boolean restart() {
        if (this.abox.isClosed()) {
            if (ABox.DEBUG) {
                System.out.println("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
            }
            if (this.backtrack()) {
                this.abox.setClash(null);
            } else {
                this.abox.setComplete(true);
            }
            return true;
        }
        return false;
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            List branches = this.abox.getBranches();
            branches.subList(lastBranch, branches.size()).clear();
            Branch newBranch = (Branch)branches.get(lastBranch - 1);
            if (ABox.DEBUG) {
                System.out.println("Backtracking to branch " + lastBranch);
            }
            if (lastBranch != newBranch.branch) {
                throw new RuntimeException("Internal error in reasoner: Trying to backtrack branch " + lastBranch + " but got " + newBranch.branch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.prevDS[newBranch.tryNext] = this.abox.getClash().depends.copy();
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.restore();
            }
            if (!(branchFound = newBranch.tryNext())) {
                if (!ABox.DEBUG) continue;
                System.out.println("Failed at branch " + lastBranch);
                continue;
            }
            this.mayNeedExpandingList.setSize(lastBranch);
            this.mayNeedExpanding = (LinkedList)this.mayNeedExpandingList.lastElement();
            this.mayNeedExpanding.addFirst(newBranch.node);
        }
        return branchFound;
    }

    private boolean parentNeedsExpanding(Individual x) {
        if (x.isRoot()) {
            return false;
        }
        Individual parent = x.getParent();
        return parent.canApply(Node.ATOM) || parent.canApply(Node.OR) || parent.canApply(Node.SOME) || parent.canApply(Node.MIN) || parent.isChanged(Node.MAX);
    }

    void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        this.mayNeedExpandingList.add(new LinkedList(this.mayNeedExpanding));
        if (newBranch.branch != this.abox.getBranches().size()) {
            throw new RuntimeException("Internal error: Invalid branch created!");
        }
    }

    protected void applyDisjunctionRule(Individual node) {
        if (!node.canApply(Node.OR)) {
            return;
        }
        List types = node.getTypes(Node.OR);
        int size = types.size();
        for (int j = node.applyNext[Node.OR]; j < size; ++j) {
            ATermAppl disjunction = (ATermAppl)types.get(j);
            ATermAppl a = (ATermAppl)disjunction.getArgument(0);
            ATermList disjuncts = (ATermList)a.getArgument(0);
            ATerm[] disj = new ATerm[disjuncts.getLength()];
            int index = 0;
            while (!disjuncts.isEmpty()) {
                disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
                if (node.hasType(disj[index])) break;
                disjuncts = disjuncts.getNext();
                ++index;
            }
            if (!disjuncts.isEmpty()) continue;
            DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, node, disjunction, node.getDepends(disjunction), disj);
            this.addBranch(newBranch);
            if (newBranch.tryNext()) continue;
            return;
        }
        node.applyNext[Node.OR] = size;
    }

    protected boolean applyMaxRule(Individual x, Role r, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set neighbors = edges.getNeighbors(x);
        if (k == 0 && neighbors.size() > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                ds = ds.union(edge.getDepends());
            }
            this.abox.setClash(new Clash(x, 4, ds));
            return false;
        }
        if (neighbors.size() <= k) {
            return false;
        }
        List mergePairs = this.findMergeNodes(neighbors);
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1);
            if (dsEdges == null) {
                return false;
            }
            if (ABox.DEBUG) {
                System.out.println("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            this.abox.setClash(new Clash(x, 4, ds.union(dsEdges)));
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, x, r, k, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        return neighbors.size() > k + 1;
    }

    protected void applyMaxRule(Individual x) {
        if (!x.isChanged(Node.MAX)) {
            return;
        }
        List maxCardinality = x.getTypes(Node.MAX);
        Iterator j = maxCardinality.iterator();
        while (j.hasNext()) {
            ATermAppl mc = (ATermAppl)j.next();
            ATermAppl max = (ATermAppl)mc.getArgument(0);
            Role r = this.abox.getRole(max.getArgument(0));
            int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
            DependencySet ds = x.getDepends(mc);
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, n, ds);
            }
            if (!this.abox.isClosed()) continue;
            return;
        }
        j = this.abox.getKB().getRBox().getFunctionalRoles().iterator();
        while (j.hasNext()) {
            Role r = (Role)j.next();
            boolean hasMore = true;
            while (hasMore) {
                hasMore = this.applyMaxRule(x, r, 1, DependencySet.INDEPENDENT);
            }
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.setChanged(Node.MAX, false);
    }

    protected void applyMinRule(Individual x) {
        if (!x.canApply(Individual.MIN)) {
            return;
        }
        List types = x.getTypes(Node.MIN);
        int size = types.size();
        for (int j = x.applyNext[Node.MIN]; j < size; ++j) {
            int c1;
            int n;
            ATermAppl mc = (ATermAppl)types.get(j);
            Role r = this.abox.getRole(mc.getArgument(0));
            if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt())) continue;
            if (ABox.DEBUG) {
                System.out.println("Apply min rule to " + x + " " + mc + " anon" + (this.abox.anonCount + 1) + " - anon" + (this.abox.anonCount + n));
            }
            DependencySet ds = x.getDepends(mc);
            Node[] y = new Node[n];
            for (c1 = 0; c1 < n; ++c1) {
                ATermAppl name = this.abox.createUniqueName();
                if (r.isDatatypeRole()) {
                    y[c1] = this.abox.addLiteral();
                } else {
                    y[c1] = this.abox.addIndividual(name);
                    y[c1].depth = x.depth + 1;
                    if (x.depth >= this.abox.treeDepth) {
                        this.abox.treeDepth = x.depth + 1;
                    }
                }
                x.addOutEdge(r, y[c1], ds);
            }
            for (c1 = 0; c1 < n; ++c1) {
                for (int c2 = c1 + 1; c2 < n; ++c2) {
                    y[c1].setDifferent(y[c2], ds);
                }
            }
        }
        x.applyNext[Node.MIN] = size;
    }

    protected void applySomeValuesRule(Individual x) {
        if (!x.canApply(Individual.SOME)) {
            return;
        }
        List types = x.getTypes(Node.SOME);
        int size = types.size();
        for (int j = x.applyNext[Node.SOME]; j < size; ++j) {
            ATermAppl sv = (ATermAppl)types.get(j);
            ATermAppl a = (ATermAppl)sv.getArgument(0);
            ATermAppl s = (ATermAppl)a.getArgument(0);
            ATermAppl c = (ATermAppl)a.getArgument(1);
            Role role = this.abox.getRole(s);
            c = ATermUtils.negate(c);
            boolean neighborFound = false;
            Node y = null;
            EdgeList edges = x.getRNeighborEdges(role);
            for (int e = 0; !neighborFound && e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                y = edge.getNeighbor(x);
                neighborFound = y.hasType(c);
            }
            if (neighborFound) continue;
            DependencySet ds = x.getDepends(sv).copy();
            if (role.isDatatypeRole()) {
                if (ABox.DEBUG) {
                    System.out.println("Apply some values rule to  " + x + " -> " + y + " " + s + " " + c);
                }
                Literal literal = null;
                if (ATermUtils.isNominal(c)) {
                    literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
                } else {
                    literal = this.abox.addLiteral();
                    literal.addType(c, ds);
                }
                x.addOutEdge(role, literal, ds);
                continue;
            }
            if (ATermUtils.isNominal(c)) {
                y = this.abox.getIndividual(c.getArgument(0));
                if (ABox.DEBUG) {
                    System.out.println("Apply has value " + x + " " + s + " " + y);
                }
                x.addOutEdge(role, y, ds);
                continue;
            }
            boolean useExistingNode = false;
            boolean useExistingRole = false;
            if (role.isFunctional()) {
                if (!edges.isEmpty()) {
                    useExistingNode = true;
                    useExistingRole = true;
                } else {
                    Role fs = role.getFunctionalSupers()[0];
                    edges = x.getRNeighborEdges(fs);
                    if (!edges.isEmpty()) {
                        useExistingNode = true;
                        y = (Node)edges.getNeighbors(x).iterator().next();
                    }
                }
            }
            if (!useExistingNode) {
                y = this.abox.addIndividual(this.abox.createUniqueName());
                y.depth = x.depth + 1;
                if (x.depth >= this.abox.treeDepth) {
                    this.abox.treeDepth = x.depth + 1;
                }
            }
            if (ABox.DEBUG) {
                System.out.println("Apply some values rule to  " + x + " -> " + y + " " + s + " " + c + " " + (useExistingNode ? " (old)" : " (new)"));
            }
            if (!useExistingRole) {
                x.addOutEdge(role, y, ds);
            }
            y.addType(c, ds);
            if (!this.abox.isClosed()) continue;
            return;
        }
        x.applyNext[Individual.SOME] = size;
    }

    protected void applyUnfoldingRule(Individual node) {
        if (!node.canApply(Node.ATOM)) {
            return;
        }
        Map normalizedMap = this.abox.getTBox().Tu.normalizedMap;
        List types = node.getTypes(Node.ATOM);
        for (int j = node.applyNext[Node.ATOM]; j < types.size(); ++j) {
            ATermAppl c = (ATermAppl)types.get(j);
            ATermAppl unfolded = (ATermAppl)normalizedMap.get(c);
            if (unfolded == null) continue;
            DependencySet ds = node.getDepends(c).copy();
            if (ABox.DEBUG && !node.hasType(unfolded)) {
                System.out.println("Apply unfolding rule to  " + node + ": " + c + " -> " + unfolded + " " + ds);
            }
            node.addType(unfolded, ds);
        }
        node.applyNext[Node.ATOM] = types.size();
    }
}

