/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.TgBox;
import org.mindswap.pellet.TuBox;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.output.ATermBaseVisitor;
import org.mindswap.pellet.output.ATermVisitor;
import org.mindswap.pellet.utils.ATermUtils;

public class Expressivity {
    KnowledgeBase kb;
    boolean hasNegation;
    boolean hasInverse;
    boolean hasFunctionality;
    boolean hasCardinality;
    boolean hasTransitivity;
    boolean hasRoleHierarchy;
    boolean hasDatatype;
    Set nominals;
    Visitor visitor;

    Expressivity(KnowledgeBase kb) {
        this.kb = kb;
    }

    private void init() {
        this.hasNegation = false;
        this.hasInverse = false;
        this.hasDatatype = false;
        this.hasCardinality = false;
        this.hasFunctionality = false;
        this.hasTransitivity = false;
        this.hasRoleHierarchy = false;
        this.nominals = new HashSet();
        this.visitor = new Visitor();
    }

    public void compute() {
        this.init();
        this.processIndividuals();
        this.processClasses();
        this.processRoles();
    }

    public String toString() {
        String dl = "";
        dl = this.hasNegation ? "ALC" : "AL";
        if (this.hasTransitivity) {
            dl = dl + "R+";
        }
        if (dl.equals("ALCR+")) {
            dl = "S";
        }
        if (this.hasRoleHierarchy) {
            dl = dl + "H";
        }
        if (this.hasInverse) {
            dl = dl + "I";
        }
        if (this.hasNominal()) {
            dl = dl + "O";
        }
        if (this.hasCardinality) {
            dl = dl + "N";
        } else if (this.hasFunctionality) {
            dl = dl + "F";
        }
        if (this.hasDatatype) {
            dl = dl + "(D)";
        }
        return dl;
    }

    protected void processClasses() {
        TgBox Tg = this.kb.getTBox().Tg;
        TuBox Tu = this.kb.getTBox().Tu;
        if (!Tg.isEmpty()) {
            this.hasNegation = true;
            ATermList list = Tg.getUC();
            while (!list.isEmpty()) {
                this.visitor.visit((ATermAppl)list.getFirst());
                list = list.getNext();
            }
        }
        Iterator i = Tu.normalizedMap.values().iterator();
        while (i.hasNext()) {
            ATermAppl term = (ATermAppl)i.next();
            this.visitor.visit(term);
        }
    }

    protected void processIndividuals() {
        IndividualIterator i = this.kb.getABox().getIndIterator();
        while (i.hasNext()) {
            Individual ind = (Individual)i.next();
            ATermAppl nominal = ATermUtils.makeValue(ind.getName());
            Iterator j = ind.getTypes().iterator();
            while (j.hasNext()) {
                ATermAppl term = (ATermAppl)j.next();
                if (term.equals(nominal)) continue;
                this.visitor.visit(term);
            }
        }
    }

    protected void processRoles() {
        Iterator i = this.kb.getRBox().getRoles().iterator();
        while (i.hasNext()) {
            ATermAppl range;
            ATermAppl domain;
            Role r = (Role)i.next();
            if (r.isDatatypeRole()) {
                this.hasDatatype = true;
            }
            if (!r.isAnon() && r.hasNamedInverse()) {
                this.hasInverse = true;
            }
            if (r.isAnon() && r.isFunctional()) {
                this.hasInverse = true;
            }
            if (r.isFunctional()) {
                this.hasFunctionality = true;
            }
            if (r.isTransitive()) {
                this.hasTransitivity = true;
            }
            if (r.getSubRoles().size() > 1) {
                this.hasRoleHierarchy = true;
            }
            if ((domain = r.getDomain()) != null) {
                this.visitor.visit(domain);
            }
            if ((range = r.getRange()) == null) continue;
            this.visitor.visit(range);
        }
    }

    public boolean hasCardinality() {
        return this.hasCardinality;
    }

    public boolean hasDatatype() {
        return this.hasDatatype;
    }

    public boolean hasFunctionality() {
        return this.hasFunctionality;
    }

    public boolean hasInverse() {
        return this.hasInverse;
    }

    public boolean hasNegation() {
        return this.hasNegation;
    }

    public boolean hasNominal() {
        return !this.nominals.isEmpty();
    }

    public boolean hasRoleHierarchy() {
        return this.hasRoleHierarchy;
    }

    public boolean hasTransitivity() {
        return this.hasTransitivity;
    }

    public Set getNominals() {
        return this.nominals;
    }

    class Visitor
    extends ATermBaseVisitor
    implements ATermVisitor {
        Visitor() {
        }

        public void visitTerm(ATermAppl term) {
        }

        public void visitAnd(ATermAppl term) {
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitOr(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitNot(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visit((ATermAppl)term.getArgument(0));
        }

        public void visitSome(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitAll(ATermAppl term) {
            this.visit((ATermAppl)term.getArgument(1));
        }

        public void visitMin(ATermAppl term) {
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            if (cardinality > 2) {
                Expressivity.this.hasCardinality = true;
            } else if (cardinality > 0) {
                Expressivity.this.hasFunctionality = true;
            }
        }

        public void visitMax(ATermAppl term) {
            int cardinality = ((ATermInt)term.getArgument(1)).getInt();
            if (cardinality > 1) {
                Expressivity.this.hasCardinality = true;
            } else if (cardinality > 0) {
                Expressivity.this.hasFunctionality = true;
            }
        }

        public void visitHasValue(ATermAppl term) {
            Expressivity.this.nominals.add(term.getArgument(1));
        }

        public void visitValue(ATermAppl term) {
            Expressivity.this.nominals.add(term);
        }

        public void visitOneOf(ATermAppl term) {
            Expressivity.this.hasNegation = true;
            this.visitList((ATermList)term.getArgument(0));
        }

        public void visitLiteral(ATermAppl term) {
        }

        public void visitSubClass(ATermAppl term) {
            throw new InternalReasonerException("This function should never be called!");
        }
    }
}

