/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class Individual
extends Node {
    private EdgeList outEdges;
    private EdgeList inEdges;
    private ArrayList[] types = new ArrayList[TYPES];
    int[] applyNext = new int[TYPES];
    boolean connected = true;

    Individual(ATermAppl name) {
        this(name, null);
    }

    Individual(ATermAppl name, ABox abox) {
        super(name, abox);
        for (int i = 0; i < TYPES; ++i) {
            this.types[i] = new ArrayList();
            this.applyNext[i] = 0;
        }
        this.outEdges = new EdgeList();
        this.inEdges = new EdgeList();
    }

    Individual(Individual ind, ABox abox) {
        super(ind, abox);
        int i;
        for (i = 0; i < TYPES; ++i) {
            this.types[i] = new ArrayList(ind.types[i]);
            this.applyNext[i] = ind.applyNext[i];
        }
        if (abox == null) {
            Edge newEdge;
            Individual to;
            Individual from;
            Edge edge;
            this.mergedTo = null;
            this.outEdges = new EdgeList(ind.outEdges.size());
            for (i = 0; i < ind.outEdges.size(); ++i) {
                edge = ind.outEdges.edgeAt(i);
                from = this;
                to = new Individual(edge.getTo().getName());
                newEdge = new Edge(edge.getRole(), from, to);
                this.outEdges.addEdge(newEdge);
            }
            this.inEdges = new EdgeList(ind.inEdges.size());
            for (i = 0; i < ind.inEdges.size(); ++i) {
                edge = ind.inEdges.edgeAt(i);
                from = this;
                to = new Individual(edge.getTo().getName());
                newEdge = new Edge(edge.getRole(), from, to);
                this.inEdges.addEdge(newEdge);
            }
        } else {
            this.outEdges = new EdgeList(ind.outEdges.size());
            this.inEdges = ind.inEdges;
        }
    }

    public ATermAppl getTerm() {
        return this.name;
    }

    public Node copyTo(ABox abox) {
        return new Individual(this, abox);
    }

    protected void updateNodeReferences() {
        super.updateNodeReferences();
        EdgeList oldEdges = this.inEdges;
        this.inEdges = new EdgeList(oldEdges.size());
        for (int i = 0; i < oldEdges.size(); ++i) {
            Edge edge = oldEdges.edgeAt(i);
            Individual from = this.abox.getIndividual(edge.getFrom().getName());
            Edge newEdge = new Edge(edge.getRole(), from, this, edge.getDepends());
            this.inEdges.addEdge(newEdge);
            from.addOutEdge(newEdge);
        }
    }

    public void mergeTo(Node node, DependencySet ds) {
        super.mergeTo(node, ds);
        if (!this.abox.isInitialized() || !this.connected) {
            return;
        }
        Timer timer = this.abox.getKB().timers.startTimer("mergeIndividuals");
        Individual y = this;
        Individual z = (Individual)node;
        if (this.isRoot()) {
            Edge edge;
            HashMap types = new HashMap(y.getDepends());
            Iterator yTypes = types.entrySet().iterator();
            while (yTypes.hasNext()) {
                Map.Entry entry = yTypes.next();
                ATermAppl yType = (ATermAppl)entry.getKey();
                DependencySet dep = (DependencySet)entry.getValue();
                z.addType(yType, dep.union(ds));
            }
            y.detach();
            if (y.isRoot()) {
                EdgeList outEdges = y.getOutEdges();
                for (int e = 0; e < outEdges.size(); ++e) {
                    edge = outEdges.edgeAt(e);
                    edge.getTo().removeInEdge(edge);
                    z.addOutEdge(edge.getRole(), edge.getTo(), edge.getDepends().union(ds));
                }
            }
            EdgeList inEdges = y.getInEdges();
            for (int e = 0; e < inEdges.size(); ++e) {
                edge = inEdges.edgeAt(e);
                Individual w = edge.getFrom();
                if (w.equals(y)) {
                    z.addOutEdge(edge.getRole(), z, edge.getDepends().union(ds));
                    continue;
                }
                w.addOutEdge(edge.getRole(), z, edge.getDepends().union(ds));
            }
            z.setDifferents(y.getDifferents(), ds);
        } else {
            HashMap types = new HashMap(y.getDepends());
            Iterator yTypes = types.entrySet().iterator();
            while (yTypes.hasNext()) {
                Map.Entry entry = yTypes.next();
                ATermAppl yType = (ATermAppl)entry.getKey();
                DependencySet dep = (DependencySet)entry.getValue();
                z.addType(yType, dep.union(ds));
            }
            EdgeList edges = y.getInEdges();
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                Individual w = edge.getFrom();
                if (w.hasAncestor(z)) {
                    z.addOutEdge(edge.getRole().getInverse(), w, edge.getDepends().union(ds));
                    continue;
                }
                w.addOutEdge(edge.getRole(), z, edge.getDepends().union(ds));
            }
            y.detach();
            z.setDifferents(y.getDifferents(), ds);
        }
        timer.stop();
    }

    public final List getTypes(int type) {
        return this.types[type];
    }

    public final boolean canApply(int type) {
        return this.applyNext[type] < this.types[type].size();
    }

    public void addType(ATermAppl c, DependencySet ds) {
        if (this.depends.containsKey(c)) {
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
        ATermAppl notC = ATermUtils.negate(c);
        DependencySet clashDepends = (DependencySet)this.depends.get(notC);
        if (clashDepends != null) {
            if (this.abox.doExplanation()) {
                ATermAppl positive = ATermUtils.isNot(notC) ? c : notC;
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds), positive));
            } else {
                this.abox.setClash(Clash.atomic(this, clashDepends.union(ds)));
            }
        }
        if (ATermUtils.isPrimitive(c)) {
            this.setChanged(ATOM, true);
            this.types[ATOM].add(c);
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                if (!this.hasType(conj)) {
                    this.addType(conj, ds);
                }
                cs = cs.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ALLFUN)) {
            this.setChanged(ALL, true);
            this.types[ALL].add(c);
            if (this.abox.isInitialized()) {
                this.abox.applyAllValues(this, c, ds);
            }
        } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
            if (this.checkMinClash(c, ds)) {
                return;
            }
            if (!this.isRedundantMin(c)) {
                this.types[MIN].add(c);
                this.setChanged(MIN, true);
            }
        } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
            ATermAppl x = (ATermAppl)c.getArgument(0);
            if (ATermUtils.isAnd(x)) {
                this.setChanged(OR, true);
                this.types[OR].add(c);
            } else if (ATermUtils.isAllValues(x)) {
                this.setChanged(SOME, true);
                this.types[SOME].add(c);
            } else if (ATermUtils.isMin(x)) {
                if (this.checkMaxClash(x, ds)) {
                    return;
                }
                if (!this.isRedundantMax(x)) {
                    this.types[MAX].add(c);
                    this.setChanged(MAX, true);
                }
            } else if (x.getArity() == 0) {
                this.setChanged(ATOM, true);
                this.types[ATOM].add(c);
            }
        } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
            this.setChanged(NOM, true);
            this.types[NOM].add(c);
        } else {
            System.err.println("Warning: Adding invalid class constructor - " + c);
            this.depends.put(ATermUtils.BOTTOM, ds);
        }
    }

    private boolean checkMinClash(ATermAppl minCard, DependencySet minDepends) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        if (minR != null && minR.isFunctional() && min > 1) {
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " on FunctionalProperty";
            }
            this.abox.setClash(new Clash((Node)this, 1, minDepends, exp));
            return true;
        }
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl maxCard = (ATermAppl)mc.getArgument(0);
            Role maxR = this.abox.getRole(maxCard.getArgument(0));
            int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
            if (max >= min || !minR.isSubRoleOf(maxR)) continue;
            DependencySet maxDepends = this.getDepends(mc);
            DependencySet ds = minDepends.union(maxDepends);
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    private boolean checkMaxClash(ATermAppl maxCard, DependencySet maxDepends) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        Iterator i = this.types[MIN].iterator();
        while (i.hasNext()) {
            ATermAppl minCard = (ATermAppl)i.next();
            Role minR = this.abox.getRole(minCard.getArgument(0));
            int min = ((ATermInt)minCard.getArgument(1)).getInt();
            if (max >= min || !minR.isSubRoleOf(maxR)) continue;
            DependencySet minDepends = this.getDepends(minCard);
            DependencySet ds = minDepends.union(maxDepends);
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = minCard + " max(" + maxR + ", " + max + ")";
            }
            this.abox.setClash(new Clash((Node)this, 1, ds, exp));
            return true;
        }
        return false;
    }

    private boolean isRedundantMin(ATermAppl minCard) {
        Role minR = this.abox.getRole(minCard.getArgument(0));
        int min = ((ATermInt)minCard.getArgument(1)).getInt();
        Iterator i = this.types[MIN].iterator();
        while (i.hasNext()) {
            ATermAppl prevMinCard = (ATermAppl)i.next();
            Role prevMinR = this.abox.getRole(prevMinCard.getArgument(0));
            int prevMin = ((ATermInt)prevMinCard.getArgument(1)).getInt() - 1;
            if (min > prevMin || !prevMinR.isSubRoleOf(minR)) continue;
            return true;
        }
        return false;
    }

    private boolean isRedundantMax(ATermAppl maxCard) {
        Role maxR = this.abox.getRole(maxCard.getArgument(0));
        int max = ((ATermInt)maxCard.getArgument(1)).getInt() - 1;
        if (max == 1 && maxR != null && maxR.isFunctional()) {
            return true;
        }
        Iterator i = this.types[MAX].iterator();
        while (i.hasNext()) {
            ATermAppl mc = (ATermAppl)i.next();
            ATermAppl prevMaxCard = (ATermAppl)mc.getArgument(0);
            Role prevMaxR = this.abox.getRole(prevMaxCard.getArgument(0));
            int prevMax = ((ATermInt)prevMaxCard.getArgument(1)).getInt() - 1;
            if (max < prevMax || !maxR.isSubRoleOf(prevMaxR)) continue;
            return true;
        }
        return false;
    }

    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.setChanged(true);
        if (ATermUtils.isPrimitive(c)) {
            this.types[ATOM].remove(c);
        } else if (!c.getAFun().equals(ATermUtils.ANDFUN)) {
            if (c.getAFun().equals(ATermUtils.ALLFUN)) {
                this.types[ALL].remove(c);
            } else if (c.getAFun().equals(ATermUtils.MINFUN)) {
                this.types[MIN].remove(c);
            } else if (c.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl x = (ATermAppl)c.getArgument(0);
                if (ATermUtils.isAnd(x)) {
                    this.types[OR].remove(c);
                } else if (ATermUtils.isAllValues(x)) {
                    this.types[SOME].remove(c);
                } else if (ATermUtils.isMin(x)) {
                    this.types[MAX].remove(c);
                } else if (x.getArity() == 0) {
                    this.types[ATOM].remove(c);
                }
            } else if (c.getAFun().equals(ATermUtils.VALUEFUN)) {
                this.types[NOM].remove(c);
            } else {
                throw new RuntimeException("Invalid concept " + c);
            }
        }
    }

    public void detach() {
        super.detach();
        int n = this.outEdges.size();
        for (int i = 0; i < n; ++i) {
            Individual succ;
            Edge edge = this.outEdges.edgeAt(i);
            if (!(edge.getTo() instanceof Individual) || !(succ = (Individual)edge.getTo()).isRoot()) continue;
            succ.removeInEdge(edge);
        }
        this.connected = false;
    }

    public void reattach(int branch) {
        super.reattach(branch);
        EdgeList edges = this.getOutEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.branch > branch || edge.getTo() instanceof Literal) continue;
            Individual succ = (Individual)edge.getTo();
            succ.addInEdge(edge);
        }
        this.connected = true;
    }

    public final boolean isLeaf() {
        return this.outEdges.isEmpty();
    }

    public final Set getSuccessors() {
        return this.outEdges.getSuccessors();
    }

    public Set getDescendants() {
        if (this.isLeaf()) {
            return Collections.EMPTY_SET;
        }
        return this.getDescendants(new HashSet());
    }

    protected Set getDescendants(Set descendants) {
        int n = this.outEdges.size();
        for (int i = 0; i < n; ++i) {
            Node succ = this.outEdges.edgeAt(i).getTo();
            if (succ == this || succ.isRoot()) continue;
            descendants.add(succ);
            if (succ.isLeaf()) continue;
            ((Individual)succ).getDescendants(descendants);
        }
        return descendants;
    }

    public final Set getRSuccessors(Role r) {
        return this.outEdges.getEdges(r).getNeighbors(this);
    }

    public final EdgeList getRSuccessorEdges(Role r) {
        return this.outEdges.getEdges(r);
    }

    public final Set getRPredecessors(Role r) {
        return this.inEdges.getEdges(r).getNeighbors(this);
    }

    public final Set getRNeighbors(Role r) {
        return this.getRNeighborEdges(r).getNeighbors(this);
    }

    public EdgeList getRNeighborEdges(Role r) {
        EdgeList neighbors = this.outEdges.getEdges(r);
        Role invR = r.getInverse();
        if (invR != null) {
            neighbors.addEdgeList(this.inEdges.getEdges(invR));
        }
        return neighbors;
    }

    public EdgeList getEdgesTo(Node x) {
        return this.outEdges.getEdgesTo(x);
    }

    public EdgeList getEdgesTo(Node x, Role r) {
        return this.outEdges.getEdgesTo(x).getEdges(r);
    }

    DependencySet hasDistinctRNeighborsForMax(Role r, long n) {
        DependencySet ds = null;
        EdgeList edges = this.getRNeighborEdges(r);
        if ((long)edges.size() >= n) {
            ArrayList allDisjointSets = new ArrayList();
            block0: for (int i = 0; i < edges.size(); ++i) {
                Node y = edges.edgeAt(i).getNeighbor(this);
                boolean added = false;
                for (int j = 0; j < allDisjointSets.size(); ++j) {
                    Node z;
                    int k;
                    List disjointSet = (List)allDisjointSets.get(j);
                    for (k = 0; k < disjointSet.size() && y.isDifferent(z = (Node)disjointSet.get(k)); ++k) {
                    }
                    if (k != disjointSet.size()) continue;
                    added = true;
                    disjointSet.add(y);
                    if ((long)disjointSet.size() < n) continue;
                    ds = DependencySet.EMPTY;
                    for (int e = 0; e < edges.size(); ++e) {
                        ds = ds.union(edges.edgeAt(e).getDepends());
                    }
                    break block0;
                }
                if (added) continue;
                ArrayList<Node> singletonSet = new ArrayList<Node>();
                singletonSet.add(y);
                allDisjointSets.add(singletonSet);
                if (n != 1L) continue;
                ds = DependencySet.EMPTY;
                for (int e = 0; e < edges.size(); ++e) {
                    ds = ds.union(edges.edgeAt(e).getDepends());
                }
                break;
            }
        }
        return ds;
    }

    boolean hasDistinctRNeighborsForMin(Role r, long n) {
        EdgeList edges = this.getRNeighborEdges(r);
        if (n == 1L) {
            return !edges.isEmpty();
        }
        if ((long)edges.size() < n) {
            return false;
        }
        ArrayList allDisjointSets = new ArrayList();
        for (int i = 0; i < edges.size(); ++i) {
            Node y = edges.edgeAt(i).getNeighbor(this);
            boolean added = false;
            for (int j = 0; j < allDisjointSets.size(); ++j) {
                boolean addToThis = true;
                List disjointSet = (List)allDisjointSets.get(j);
                for (int k = 0; k < disjointSet.size(); ++k) {
                    Node z = (Node)disjointSet.get(k);
                    if (y.isDifferent(z)) continue;
                    addToThis = false;
                    break;
                }
                if (!addToThis) continue;
                added = true;
                disjointSet.add(y);
                if ((long)disjointSet.size() < n) continue;
                return true;
            }
            if (added) continue;
            ArrayList<Node> singletonSet = new ArrayList<Node>();
            singletonSet.add(y);
            allDisjointSets.add(singletonSet);
        }
        return false;
    }

    public final boolean hasRNeighbor(Role r) {
        if (this.outEdges.hasEdge(r)) {
            return true;
        }
        Role invR = r.getInverse();
        return invR != null && this.inEdges.hasEdge(invR);
    }

    public final boolean hasRSuccessor(Role r) {
        return this.outEdges.hasEdge(r);
    }

    public final boolean hasEdge(Role r, Node x) {
        return this.outEdges.hasEdge(new Edge(r, this, x));
    }

    final boolean hasSuccessor(Node x) {
        return this.outEdges.hasEdgeTo(x);
    }

    final boolean hasRSuccessor(Role r, Node x) {
        return this.hasEdge(r, x);
    }

    public Boolean hasDataPropertyValue(Role r, Object value) {
        Boolean hasValue = Boolean.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            Literal literal = (Literal)edge.getTo();
            Object literalValue = literal.getValue();
            if (literalValue == null) {
                Datatype datatype = literal.getDatatype();
                if (datatype.size() != 1L || !datatype.contains(value)) continue;
                hasValue = null;
                continue;
            }
            if (!literalValue.equals(value)) continue;
            if (ds.max() == 0) {
                return Boolean.TRUE;
            }
            hasValue = null;
        }
        return hasValue;
    }

    public Boolean hasObjectPropertyValue(Role r, Individual value) {
        Boolean hasValue = Boolean.FALSE;
        EdgeList edges = this.outEdges.getEdges(r);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            if (value == null) {
                return Boolean.TRUE;
            }
            if (!edge.getTo().isSame(value)) continue;
            if (ds.max() == 0) {
                return Boolean.TRUE;
            }
            hasValue = null;
        }
        Role invR = r.getInverse();
        edges = this.inEdges.getEdges(invR);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet ds = edge.getDepends();
            if (value == null) {
                return Boolean.TRUE;
            }
            if (!edge.getFrom().isSame(value)) continue;
            if (ds.max() == 0) {
                return Boolean.TRUE;
            }
            hasValue = null;
        }
        return hasValue;
    }

    boolean hasRNeighbor(Role r, Node x) {
        if (this.hasRSuccessor(r, x)) {
            return true;
        }
        if (x instanceof Individual) {
            return ((Individual)x).hasRSuccessor(r.getInverse(), this);
        }
        return false;
    }

    public void addInEdge(Edge edge) {
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        this.inEdges.addEdge(edge);
    }

    protected void addOutEdge(Edge edge) {
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        this.outEdges.addEdge(edge);
    }

    public void addOutEdge(Role r, Node x, DependencySet d) {
        if (this.hasEdge(r, x)) {
            return;
        }
        this.abox.changed = true;
        this.setChanged(ALL, true);
        this.setChanged(MAX, true);
        d = d.copy();
        d.branch = this.abox.getBranch();
        Edge edge = new Edge(r, this, x, d);
        this.outEdges.addEdge(edge);
        x.addInEdge(edge);
        if (this.abox.isInitialized()) {
            this.abox.applyDomainRange(edge);
            this.abox.applyAllValues(edge);
            this.abox.applyFunctionalRole(edge);
        }
    }

    public final EdgeList getOutEdges() {
        return this.outEdges;
    }

    public final EdgeList getInEdges() {
        return this.inEdges;
    }

    public void restore(int branch) {
        super.restore(branch);
        for (int i = 0; i < TYPES; ++i) {
            this.applyNext[i] = 0;
        }
        Iterator i = this.outEdges.iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            DependencySet d = e.getDepends();
            if (d.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("Restoring added edge - delete " + e);
            }
            i.remove();
        }
    }

    public final void removeEdge(Edge edge) {
        this.outEdges.removeEdge(edge);
    }

    public final void removeInEdge(Edge edge) {
        this.inEdges.removeEdge(edge);
    }

    public final void removeInEdges() {
        this.inEdges = new EdgeList();
    }

    public String debugString() {
        return this.name.getName() + " = " + this.types[ATOM] + this.types[ALL] + this.types[SOME] + this.types[OR] + this.types[MIN] + this.types[MAX] + this.types[NOM] + "; **" + this.outEdges + "**" + "; **" + this.inEdges + "**" + "";
    }
}

