/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Individual;

class IndividualIterator
implements Iterator {
    protected Map nodes;
    protected List nodeList;
    protected int index;
    protected int start;
    protected int stop;

    public IndividualIterator(ABox abox) {
        this(abox, true);
    }

    protected IndividualIterator(ABox abox, boolean findNext) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = 0;
        this.stop = this.nodeList.size();
        this.index = this.start;
        if (findNext) {
            this.findNext();
        }
    }

    public IndividualIterator(ABox abox, int start, int stop) {
        this.nodes = abox.getNodeMap();
        this.nodeList = abox.getNodeNames();
        this.start = start;
        this.stop = stop;
        this.index = start;
        this.findNext();
    }

    protected void findNext() {
        while (this.index < this.stop && !(this.nodes.get(this.nodeList.get(this.index)) instanceof Individual)) {
            ++this.index;
        }
    }

    public boolean hasNext() {
        this.findNext();
        return this.index < this.stop;
    }

    public void reset() {
        this.index = this.start;
        this.findNext();
    }

    public void jump(int i) {
        this.index = i;
    }

    public Object next() {
        this.findNext();
        Individual ind = (Individual)this.nodes.get(this.nodeList.get(this.index++));
        return ind;
    }

    public void remove() {
        throw new RuntimeException("Remove is not supported");
    }
}

