/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.EmptySHINStrategy;
import org.mindswap.pellet.EmptySHNStrategy;
import org.mindswap.pellet.Expressivity;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MatrixTaxonomyBuilder;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.RBox;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.SHIONStrategy;
import org.mindswap.pellet.SHONStrategy;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyBuilder;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.exceptions.InconsistentOntologyException;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;

public class KnowledgeBase {
    public static boolean DEBUG = false;
    protected ABox abox;
    protected TBox tbox;
    protected RBox rbox;
    private Set individuals;
    protected TaxonomyBuilder builder;
    protected Taxonomy taxonomy;
    private boolean consistent;
    protected int status;
    protected static final int UNCHANGED = 0;
    protected static final int ABOX_CHANGED = 1;
    protected static final int TBOX_CHANGED = 2;
    protected static final int RBOX_CHANGED = 4;
    protected static final int ALL_CHANGED = 7;
    protected static final int CONSISTENCY = 8;
    protected static final int CLASSIFICATION = 16;
    protected static final int REALIZATION = 32;
    protected String ontology;
    private Expressivity expressivity;
    public Timers timers = new Timers();

    public KnowledgeBase() {
        this.clear();
        this.timers.createTimer("preprocessing");
        this.timers.createTimer("consistency");
        this.status = 7;
    }

    public KnowledgeBase(KnowledgeBase kb) {
        this.abox = kb.abox.copy();
        this.tbox = kb.tbox;
        this.rbox = kb.rbox;
        this.expressivity = kb.expressivity;
        this.individuals = new HashSet(kb.individuals);
        this.status = 7;
        this.timers = kb.timers;
    }

    public Expressivity getExpressivity() {
        this.prepare();
        return this.expressivity;
    }

    public void clear() {
        this.abox = new ABox(this);
        this.tbox = new TBox(this);
        this.rbox = new RBox();
        this.expressivity = new Expressivity(this);
        this.individuals = new HashSet();
        this.status = 7;
    }

    public KnowledgeBase copy() {
        return new KnowledgeBase(this);
    }

    public void addClass(ATerm c) {
        if (((Object)c).equals(ATermUtils.TOP) || ATermUtils.isComplexClass(c)) {
            return;
        }
        if (ATermUtils.isBnode((ATermAppl)c)) {
            System.out.print("");
        }
        this.status |= 2;
        this.tbox.classes.add(c);
        if (DEBUG) {
            System.out.println("class " + c);
        }
    }

    public void addSubClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.status |= 2;
        if (ATermUtils.isOneOf(c1)) {
            ATermList list = (ATermList)c1.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl nominal = (ATermAppl)list.getFirst();
                ATermAppl ind = (ATermAppl)nominal.getArgument(0);
                this.addIndividual(ind);
                this.addType(ind, c2);
                list = list.getNext();
            }
        } else {
            ATermAppl subAxiom = ATermUtils.makeSub(c1, c2);
            this.tbox.addAxiom(subAxiom);
            if (DEBUG) {
                System.out.println("sub " + c1 + " " + c2);
            }
        }
    }

    public void addSameClass(ATermAppl c1, ATermAppl c2) {
        if (c1.equals(c2)) {
            return;
        }
        this.status |= 2;
        if (ATermUtils.isOneOf(c2) || ATermUtils.isOneOf(c1)) {
            this.addSubClass(c1, c2);
            this.addSubClass(c2, c1);
        } else {
            ATermAppl sameAxiom = ATermUtils.makeSame(c1, c2);
            this.tbox.addAxiom(sameAxiom);
            if (DEBUG) {
                System.out.println("same " + c1 + " " + c2);
            }
        }
    }

    public void addDisjointClass(ATerm c1, ATerm c2) {
        this.status |= 2;
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        ATermAppl notC1 = ATermUtils.makeNot(c1);
        this.tbox.addAxiom(ATermUtils.makeSub(c1, notC2));
        this.tbox.addAxiom(ATermUtils.makeSub(c2, notC1));
        if (DEBUG) {
            System.out.println("disjoint " + c1 + " " + c2);
        }
    }

    public void addDataPropertyValue(ATermAppl p, ATermAppl ind, ATermAppl literalValue) {
        this.status |= 1;
        Role role = this.getRole(p);
        if (!role.isDatatypeRole()) {
            return;
        }
        Individual subj = this.abox.getIndividual(ind);
        Literal obj = this.abox.addLiteral(literalValue);
        subj.addOutEdge(role, obj, DependencySet.INDEPENDENT);
        if (DEBUG) {
            System.out.println("DataPropertyValue " + ind + " " + p + " " + literalValue);
        }
    }

    public Individual addIndividual(ATermAppl i) {
        Node node = this.abox.getNode(i);
        if (node == null) {
            this.status |= 1;
            node = this.abox.addIndividual(i);
            node.setOntology(this.ontology);
            this.individuals.add(i);
            if (DEBUG) {
                System.out.println("individual " + i);
            }
        } else if (node instanceof Literal) {
            throw new UnsupportedFeatureException("Trying to use a literal as an individual. Literal ID: " + i.getName());
        }
        return (Individual)node;
    }

    public void addType(ATermAppl i, ATermAppl c) {
        this.status |= 1;
        this.abox.addType(i, c);
        if (DEBUG) {
            System.out.println("type " + i + " " + c);
        }
    }

    public void addSame(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.abox.addSame(i1, i2);
        if (DEBUG) {
            System.out.println("same " + i1 + " " + i2);
        }
    }

    public void addDifferent(ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        this.abox.addDifferent(i1, i2);
        if (DEBUG) {
            System.out.println("diff " + i1 + " " + i2);
        }
    }

    public void addObjectPropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        this.status |= 1;
        Individual subj = this.abox.getIndividual(i1);
        Individual obj = this.abox.getIndividual(i2);
        Role role = this.getRole(p);
        if (subj == null) {
            throw new UnsupportedFeatureException(i1 + " is not a known individual!");
        }
        if (role == null) {
            throw new UnsupportedFeatureException(p + " is not a known property!");
        }
        if (obj == null) {
            throw new UnsupportedFeatureException(i2 + " is not a known individual!");
        }
        if (!role.isObjectRole()) {
            return;
        }
        subj.addOutEdge(role, obj, DependencySet.INDEPENDENT);
        if (DEBUG) {
            System.out.println("ObjectPropertyValue " + i1 + " " + p + " " + i2);
        }
    }

    public void addProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addRole(p);
        if (DEBUG) {
            System.out.println("undefined-prop " + p);
        }
    }

    public void addObjectProperty(ATerm p) {
        this.status |= 4;
        this.rbox.addObjectRole((ATermAppl)p);
        if (DEBUG) {
            System.out.println("object-prop " + p);
        }
    }

    public void addDatatypeProperty(ATerm p) {
        this.status |= 4;
        this.rbox.addDatatypeRole((ATermAppl)p);
        if (DEBUG) {
            System.out.println("data-prop " + p);
        }
    }

    public void addOntologyProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addOntologyRole(p);
        if (DEBUG) {
            System.out.println("onto-prop " + p);
        }
    }

    public void addAnnotationProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addAnnotationRole(p);
        if (DEBUG) {
            System.out.println("annotation-prop " + p);
        }
    }

    public void addSubProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addSubRole(p1, p2);
        if (DEBUG) {
            System.out.println("sub-prop " + p1 + " " + p2);
        }
    }

    public void addSameProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addSubRole(p1, p2);
        this.rbox.addSubRole(p2, p1);
        if (DEBUG) {
            System.out.println("same-prop " + p1 + " " + p2);
        }
    }

    public void addInverseProperty(ATermAppl p1, ATermAppl p2) {
        this.status |= 4;
        this.rbox.addInverseRole(p1, p2);
        if (DEBUG) {
            System.out.println("inv-prop " + p1 + " " + p2);
        }
    }

    public void addTransitiveProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.setTransitive(true);
        if (DEBUG) {
            System.out.println("trans-prop " + p);
        }
    }

    public void addSymmetricProperty(ATermAppl p) {
        this.status |= 4;
        this.rbox.addInverseRole(p, p);
        if (DEBUG) {
            System.out.println("sym-prop " + p);
        }
    }

    public void addFunctionalProperty(ATermAppl p) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.setFunctional(true);
        if (DEBUG) {
            System.out.println("func-prop " + p);
        }
    }

    public void addInverseFunctionalProperty(ATerm p) {
        this.status |= 4;
        Role role = this.rbox.getDefinedRole(p);
        Role inv = role.getInverse();
        inv.setFunctional(true);
        if (DEBUG) {
            System.out.println("inv-func-prop " + p);
        }
    }

    public void addDomain(ATerm p, ATermAppl c) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addDomain(c);
        if (DEBUG) {
            System.out.println("domain " + p + " " + c);
        }
    }

    public void addRange(ATerm p, ATermAppl c) {
        this.status |= 4;
        Role r = this.rbox.getDefinedRole(p);
        r.addRange(c);
        if (DEBUG) {
            System.out.println("range " + p + " " + c);
        }
    }

    public void addDatatype(ATerm p) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(((Object)p).toString())) {
            this.status |= 2;
            this.getDatatypeReasoner().defineDatatype(((Object)p).toString());
            if (DEBUG) {
                System.out.println("datatype " + p);
            }
        }
    }

    public void addDataRange(String datatypeURI, ATermList values) {
        DatatypeReasoner dtReasoner = this.getDatatypeReasoner();
        if (!dtReasoner.isDefined(datatypeURI.toString())) {
            this.status |= 2;
            Datatype dataRange = dtReasoner.enumeration(ATermUtils.listToSet(values));
            this.getDatatypeReasoner().defineDatatype(datatypeURI.toString(), dataRange);
            if (DEBUG) {
                System.out.println("datarange " + datatypeURI.toString() + " " + values);
            }
        }
    }

    public boolean removeObjectPropertyValue(ATermAppl p, ATermAppl i1, ATermAppl i2) {
        boolean removed = false;
        Individual subj = this.abox.getIndividual(i1);
        Individual obj = this.abox.getIndividual(i2);
        Role role = this.getRole(p);
        if (subj == null) {
            throw new UnsupportedFeatureException(i1 + " is not an individual!");
        }
        if (obj == null) {
            return false;
        }
        if (role == null) {
            return false;
        }
        EdgeList edges = subj.getEdgesTo(obj, role);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            if (!edge.getRole().equals(role)) continue;
            subj.removeEdge(edge);
            this.status |= 1;
            removed = true;
            break;
        }
        if (DEBUG) {
            System.out.println("Remove ObjectPropertyValue " + i1 + " " + p + " " + i2);
        }
        return removed;
    }

    public void removeType(ATermAppl ind, ATermAppl c) {
        this.status |= 1;
        Individual subj = this.abox.getIndividual(ind);
        if (subj == null) {
            return;
        }
        subj.removeType(c);
        if (DEBUG) {
            System.out.println("Remove Type " + ind + " " + c);
        }
    }

    public void prepare() {
        if (!this.isChanged()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        Timer timer = this.timers.startTimer("preprocessing");
        boolean reuseTaxonomy = this.taxonomy != null && !this.isTBoxChanged() && (!this.expressivity.hasNominal() || PelletOptions.USE_PSEUDO_NOMINALS);
        int sizeTg = 0;
        if (this.isTBoxChanged()) {
            if (DEBUG) {
                System.out.print("Splitting...");
            }
            this.tbox.split();
            sizeTg = this.tbox.Tg.size();
            if (PelletOptions.USE_ABSORPTION) {
                if (DEBUG) {
                    System.out.print("Absorbing...");
                }
                this.tbox.absorb();
            }
            if (DEBUG) {
                System.out.print("Normalizing...");
            }
            this.tbox.Tu.normalize();
            if (DEBUG) {
                System.out.print("Internalizing...");
            }
            this.tbox.Tg.internalize();
            if (DEBUG) {
                System.out.print("Role hierarchy...");
            }
            this.rbox.computeRoleHierarchy();
        } else if (this.isRBoxChanged()) {
            if (DEBUG) {
                System.out.print("Role hierarchy...");
            }
            this.rbox.computeRoleHierarchy();
        }
        this.status = 0;
        if (DEBUG) {
            System.out.print("Expressivity...");
        }
        this.expressivity.compute();
        if (DEBUG) {
            System.out.print("ABox init...");
        }
        this.abox.initialize();
        if (DEBUG) {
            System.out.println("done.");
        }
        if (DEBUG) {
            Iterator it = this.tbox.Tu.normalizedMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                System.out.println(entry.getKey() + " -> " + entry.getValue());
            }
        }
        this.abox.setDoExplanation(explain);
        this.abox.clearCaches(!reuseTaxonomy);
        if (reuseTaxonomy) {
            this.status |= 0x10;
        } else {
            this.taxonomy = null;
        }
        timer.stop();
        if (PelletOptions.PRINT_SIZE) {
            System.out.print("Expressivity: " + this.expressivity + ", ");
            System.out.print("Individuals: " + this.individuals.size() + ", ");
            System.out.print("Classes: " + this.tbox.classes.size());
            if (sizeTg > 0) {
                System.out.print(", GCIs: " + this.tbox.Tg.size() + " (");
                System.out.print(sizeTg - this.tbox.Tg.size() + " absorbed)");
            }
            System.out.print(" Strategy: " + this.chooseStrategy(this.abox));
            System.out.println();
        }
    }

    public boolean isConsistencyDone() {
        return (this.status & 0xF) == 8;
    }

    public boolean isClassified() {
        return (this.status & 0x17) == 16;
    }

    public boolean isRealized() {
        return (this.status & 0x27) == 32;
    }

    public boolean isChanged() {
        return (this.status & 7) != 0;
    }

    public boolean isTBoxChanged() {
        return (this.status & 2) != 0;
    }

    public boolean isRBoxChanged() {
        return (this.status & 4) != 0;
    }

    public boolean isABoxChanged() {
        return (this.status & 1) != 0;
    }

    private void consistency() {
        if (this.isConsistencyDone()) {
            return;
        }
        boolean explain = this.abox.doExplanation();
        this.abox.setDoExplanation(true);
        this.prepare();
        Timer timer = this.timers.startTimer("consistency");
        this.consistent = this.abox.isConsistent();
        this.abox.setDoExplanation(explain);
        if (!this.consistent) {
            System.err.println(this.getExplanation());
        }
        timer.stop();
        this.status |= 8;
    }

    public boolean isConsistent() {
        this.consistency();
        return this.consistent;
    }

    public void ensureConsistency() {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException("Cannot do reasoning with inconsistent ontologies!");
        }
    }

    public void classify() {
        this.ensureConsistency();
        if (this.isClassified()) {
            return;
        }
        Timer timer = this.timers.startTimer("classify");
        this.builder = PelletOptions.USE_OLD_CLASSIFICATION ? new MatrixTaxonomyBuilder(this) : new TaxonomyBuilder(this);
        this.taxonomy = this.builder.classify();
        timer.stop();
        this.status |= 0x10;
    }

    public void realize() {
        if (this.isRealized()) {
            return;
        }
        this.classify();
        Timer timer = this.timers.startTimer("realize");
        this.taxonomy = this.builder.realize();
        timer.stop();
        this.status |= 0x20;
    }

    public Set getClasses() {
        return Collections.unmodifiableSet(this.tbox.classes);
    }

    public Set getProperties() {
        HashSet<ATermAppl> set = new HashSet<ATermAppl>();
        Iterator i = this.rbox.getRoleNames().iterator();
        while (i.hasNext()) {
            ATermAppl p = (ATermAppl)i.next();
            if (!ATermUtils.isPrimitive(p)) continue;
            set.add(p);
        }
        return set;
    }

    public Set getIndividuals() {
        return Collections.unmodifiableSet(this.individuals);
    }

    public Role getProperty(ATerm r) {
        return this.rbox.getRole(r);
    }

    public int getPropertyType(ATerm r) {
        Role role = this.getProperty(r);
        return role == null ? 0 : role.getType();
    }

    public boolean isClass(ATerm c) {
        return ATermUtils.isComplexClass(c) || this.getClasses().contains(c) || ((Object)c).equals(ATermUtils.TOP);
    }

    public boolean isProperty(ATerm p) {
        return this.rbox.isRole(p);
    }

    public boolean isDatatypeProperty(ATerm p) {
        return this.getPropertyType(p) == 2;
    }

    public boolean isObjectProperty(ATerm p) {
        return this.getPropertyType(p) == 1;
    }

    public boolean isAnnotationProperty(ATerm p) {
        return this.getPropertyType(p) == 3;
    }

    public boolean isOntologyProperty(ATerm p) {
        return this.getPropertyType(p) == 4;
    }

    public boolean isIndividual(ATerm ind) {
        return this.getIndividuals().contains(ind);
    }

    public boolean isTransitiveProperty(ATermAppl r) {
        if (this.rbox.getRole(r).isTransitive()) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(r, ATermUtils.makeSomeValues(r, c)), ATermUtils.makeAllValues(r, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isSymmetricProperty(ATermAppl p) {
        return this.isInverse(p, p);
    }

    public boolean isFunctionalProperty(ATermAppl p) {
        if (this.rbox.getRole(p).isFunctional()) {
            return true;
        }
        ATermAppl max1P = ATermUtils.makeMax(p, 1);
        return this.isSubClassOf(ATermUtils.TOP, max1P);
    }

    public boolean isInverseFunctionalProperty(ATermAppl p) {
        Role role = this.rbox.getRole(p);
        if (role.isInverseFunctional()) {
            return true;
        }
        ATermAppl invP = role.getInverse().getName();
        ATermAppl max1invP = ATermUtils.makeMax(invP, 1);
        return this.isSubClassOf(ATermUtils.TOP, max1invP);
    }

    public boolean isSubPropertyOf(ATermAppl sub, ATermAppl sup) {
        Role roleSup;
        Role roleSub = this.rbox.getRole(sub);
        if (roleSub.isSubRoleOf(roleSup = this.rbox.getRole(sup))) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(ATermUtils.makeSomeValues(sub, c), ATermUtils.makeAllValues(sup, notC));
        return !this.abox.isSatisfiable(test);
    }

    public boolean isEquivalentProperty(ATermAppl p1, ATermAppl p2) {
        return this.isSubPropertyOf(p1, p2) && this.isSubPropertyOf(p2, p1);
    }

    public boolean isInverse(ATermAppl r1, ATermAppl r2) {
        if (this.rbox.getRole(r1).getInverse().getName().equals(r2)) {
            return true;
        }
        this.ensureConsistency();
        ATermAppl c = ATermUtils.makeTermAppl("_C_");
        ATermAppl notC = ATermUtils.makeNot(c);
        ATermAppl test = ATermUtils.makeAnd(c, ATermUtils.makeSomeValues(r1, ATermUtils.makeAllValues(r2, notC)));
        return !this.abox.isSatisfiable(test);
    }

    public boolean hasDomain(ATermAppl p, ATermAppl c) {
        ATermAppl minP1 = ATermUtils.makeMin(p, 1);
        return this.isSubClassOf(minP1, c);
    }

    public boolean hasRange(ATermAppl p, ATermAppl c) {
        ATermAppl allValues = ATermUtils.makeAllValues(p, c);
        return this.isSubClassOf(ATermUtils.TOP, allValues);
    }

    public boolean isDatatype(ATermAppl c) {
        return this.abox.getDatatypeReasoner().isDefined(c.getName());
    }

    public boolean isSatisfiable(ATermAppl c) {
        this.ensureConsistency();
        if (!this.isClass(c)) {
            return false;
        }
        return this.abox.isSatisfiable(c);
    }

    public boolean hasIndividual(ATerm d) {
        this.ensureConsistency();
        Timer timer = this.timers.startTimer("hasIndividual");
        ATermAppl c = ATermUtils.normalize((ATermAppl)d);
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            if (this.abox.isObviousType(x, c)) {
                return true;
            }
            if (!this.abox.isPossibleType(x, notC)) continue;
            unknowns.add(x);
        }
        boolean hasIndividual = !unknowns.isEmpty() && this.abox.isType(unknowns, c);
        timer.stop();
        return hasIndividual;
    }

    public boolean isSubTypeOf(ATermAppl d1, ATermAppl d2) {
        if (!this.isDatatype(d1)) {
            return false;
        }
        if (!this.isDatatype(d2)) {
            return false;
        }
        return this.getDatatypeReasoner().isSubTypeOf(d1, d2);
    }

    public boolean isSubClassOf(ATermAppl c1, ATermAppl c2) {
        this.ensureConsistency();
        if (!this.isClass(c1)) {
            return false;
        }
        if (!this.isClass(c2)) {
            return false;
        }
        if (c1.equals(c2)) {
            return true;
        }
        if (this.isClassified() && this.taxonomy.contains(c1) && this.taxonomy.contains(c2)) {
            return this.taxonomy.isSubClassOf(c1, c2);
        }
        return this.abox.isSubClassOf(c1, c2);
    }

    public boolean isSubclassOf(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2);
    }

    public boolean isEquivalentClass(ATermAppl c1, ATermAppl c2) {
        return this.isSubClassOf(c1, c2) && this.isSubClassOf(c2, c1);
    }

    public boolean isDisjoint(ATermAppl c1, ATermAppl c2) {
        ATermAppl c1and2 = ATermUtils.makeAnd(c1, c2);
        return !this.isSatisfiable(c1and2);
    }

    public boolean isComplement(ATermAppl c1, ATermAppl c2) {
        ATermAppl notC2 = ATermUtils.makeNot(c2);
        return this.isEquivalentClass(c1, notC2);
    }

    public Boolean isKnownType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        c = ATermUtils.normalize(c);
        if (this.abox.isObviousType(x, c)) {
            return Boolean.TRUE;
        }
        if (!this.abox.isPossibleType(x, c)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public boolean isType(ATermAppl x, ATermAppl c) {
        this.ensureConsistency();
        if (!this.isIndividual(x)) {
            return false;
        }
        if (!this.isClass(c)) {
            return false;
        }
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.taxonomy.getInstances(c).contains(x);
        }
        return this.abox.isType(x, c);
    }

    public boolean isSameAs(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            return false;
        }
        if (ind2 == null) {
            return false;
        }
        if (ind1.isSame(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeNot(ATermUtils.makeValue(t2));
        return !this.isType(t1, c);
    }

    public boolean isDifferentFrom(ATermAppl t1, ATermAppl t2) {
        Individual ind1 = this.abox.getIndividual(t1);
        Individual ind2 = this.abox.getIndividual(t2);
        if (ind1 == null) {
            return false;
        }
        if (ind2 == null) {
            return false;
        }
        if (ind1.isDifferent(ind2)) {
            return true;
        }
        ATermAppl c = ATermUtils.makeValue(t2);
        return !this.isType(t1, c);
    }

    public boolean hasPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(s)) {
            return false;
        }
        if (!this.isProperty(p)) {
            return false;
        }
        if (o != null && (this.isDatatypeProperty(p) ? !ATermUtils.isLiteral(o) : !this.isIndividual(o))) {
            return false;
        }
        return this.abox.hasPropertyValue(s, p, o);
    }

    public Boolean hasKnownPropertyValue(ATermAppl s, ATermAppl p, ATermAppl o) {
        this.ensureConsistency();
        return this.abox.hasObviousPropertyValue(s, p, o);
    }

    public ABox getABox() {
        return this.abox;
    }

    public RBox getRBox() {
        return this.rbox;
    }

    public TBox getTBox() {
        return this.tbox;
    }

    public DatatypeReasoner getDatatypeReasoner() {
        return this.abox.getDatatypeReasoner();
    }

    public Set getSuperClasses(ATermAppl c, boolean direct) {
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSuperClasses(c, direct);
    }

    public Set getSubClasses(ATermAppl c) {
        return this.getSubClasses(c, false);
    }

    public Set getTypes(ATermAppl ind, boolean direct) {
        this.realize();
        return this.taxonomy.getTypes(ind, direct);
    }

    public Set getTypes(ATermAppl ind) {
        this.realize();
        return this.taxonomy.getTypes(ind);
    }

    public ATermAppl getType(ATermAppl ind) {
        return (ATermAppl)this.abox.getIndividual(ind).getTypes(Node.ATOM).iterator().next();
    }

    public ATermAppl getType(ATermAppl ind, boolean direct) {
        this.realize();
        Set setOfSets = this.taxonomy.getTypes(ind, direct);
        Set set = (Set)setOfSets.iterator().next();
        return (ATermAppl)set.iterator().next();
    }

    public Set getInstances(ATermAppl c) {
        if (this.isRealized() && this.taxonomy.contains(c)) {
            return this.taxonomy.getInstances(c);
        }
        return new HashSet(this.retrieve(c));
    }

    public Set getInstances(ATermAppl c, boolean direct) {
        if (!direct) {
            return this.getInstances(c);
        }
        if (ATermUtils.isPrimitive(c)) {
            this.realize();
            return this.taxonomy.getInstances(c, direct);
        }
        return Collections.EMPTY_SET;
    }

    public Set getEquivalentClasses(ATermAppl c) {
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getEquivalentClasses(c);
    }

    public Set getSuperClasses(ATermAppl c) {
        return this.getSuperClasses(c, false);
    }

    public Set getSubClasses(ATermAppl c, boolean direct) {
        this.classify();
        if (!this.taxonomy.contains(c)) {
            this.builder.classify(c);
        }
        return this.taxonomy.getSubClasses(c, direct);
    }

    public Set getSuperProperties(ATermAppl prop) {
        return this.getSuperProperties(prop, false);
    }

    public Set getSuperProperties(ATermAppl prop, boolean direct) {
        Set eqs = this.getEquivalentProperties(prop);
        Role role = this.rbox.getRole(prop);
        Set supers = role.getSuperRoles();
        HashSet<Set> result = new HashSet<Set>();
        Set set = SetUtils.difference(supers, eqs);
        set.remove(role);
        ArrayList list = new ArrayList(set);
        for (int i = 0; i < list.size(); ++i) {
            Role p = (Role)list.get(i);
            if (!set.contains(p) || p.isAnon()) continue;
            if (direct) {
                Set pSups = SetUtils.union(this.getSuperProperties(p.getName()));
                if (SetUtils.intersects(set = SetUtils.difference(set, pSups), this.getSubProperties(p.getName()))) continue;
                Set s = this.getEquivalentProperties(p.getName());
                s.add(p);
                result.add(s);
                continue;
            }
            Set pEqs = this.getEquivalentProperties(p.getName());
            pEqs.add(p);
            result.add(pEqs);
            set = SetUtils.difference(set, pEqs);
        }
        return result;
    }

    public Set getSubProperties(ATerm prop) {
        return this.getSubProperties(prop, false);
    }

    public Set getSubProperties(ATerm prop, boolean direct) {
        Role role = this.rbox.getRole(prop);
        Set sub = role.getSubRoles();
        Set eqs = this.getEquivalentProperties(prop);
        HashSet<Set> result = new HashSet<Set>();
        Set set = SetUtils.difference(sub, eqs);
        set.remove(role);
        ArrayList list = new ArrayList(set);
        for (int i = 0; i < list.size(); ++i) {
            Role p = (Role)list.get(i);
            if (!set.contains(p) || p.isAnon()) continue;
            if (direct) {
                Set allSubs = SetUtils.union(this.getSubProperties(p.getName()));
                Set allSups = SetUtils.union(this.getSuperProperties(p.getName()));
                if (SetUtils.intersects(set = SetUtils.difference(set, allSubs), allSups)) continue;
                Set s = this.getEquivalentProperties(p.getName());
                s.add(p);
                result.add(s);
                continue;
            }
            Set pEqs = this.getEquivalentProperties(p.getName());
            pEqs.add(p);
            result.add(pEqs);
            set = SetUtils.difference(set, pEqs);
        }
        return result;
    }

    public Set getEquivalentProperties(ATerm prop) {
        this.prepare();
        Role role = this.rbox.getRole(prop);
        Set sub = role.getSubRoles();
        Set sup = role.getSuperRoles();
        Set set = SetUtils.intersection(sub, sup);
        set.remove(role);
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Role r = (Role)i.next();
            if (!r.isAnon()) continue;
            i.remove();
        }
        return set;
    }

    public Set getInverses(ATerm prop) {
        Role invR = this.rbox.getRole(prop).getInverse();
        if (invR != null && !invR.isAnon()) {
            Set inverses = this.getEquivalentProperties(invR.getName());
            inverses.add(invR.getName());
            return inverses;
        }
        return Collections.EMPTY_SET;
    }

    public Set getDomains(ATermAppl prop) {
        Set<ATermAppl> set = new HashSet<ATermAppl>();
        ATermAppl domain = this.rbox.getRole(prop).getDomain();
        if (domain != null) {
            if (ATermUtils.isAnd(domain)) {
                set = ATermUtils.listToSet((ATermList)domain.getArgument(0));
            } else {
                set.add(domain);
            }
        }
        return set;
    }

    public Set getRanges(ATerm prop) {
        Set<ATermAppl> set = new HashSet<ATermAppl>();
        ATermAppl range = this.rbox.getRole(prop).getRange();
        if (range != null) {
            if (ATermUtils.isAnd(range)) {
                set = ATermUtils.listToSet((ATermList)range.getArgument(0));
            } else {
                set.add(range);
            }
        }
        return set;
    }

    public QueryResults runQuery(String queryStr) {
        QueryResults results = QueryEngine.exec(queryStr, this);
        return results;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x, Datatype datatype) {
        Role role = this.rbox.getRole(r);
        if (role == null || !role.isDatatypeRole()) {
            throw new UnsupportedFeatureException("getDataPropertyValues function can only be used with datatype properties. Property: " + role);
        }
        ArrayList<Literal> result = new ArrayList<Literal>();
        List values = this.getDataPropertyValues(r, x);
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            Object value = lit.getValue();
            if (!datatype.contains(value)) continue;
            result.add(lit);
        }
        return result;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x, String lang) {
        List values = this.getDataPropertyValues(r, x);
        if (lang == null) {
            return values;
        }
        ArrayList<Literal> result = new ArrayList<Literal>();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Literal lit = (Literal)i.next();
            String litLang = lit.getLang();
            if (!litLang.equals(lang)) continue;
            result.add(lit);
        }
        return result;
    }

    public List getDataPropertyValues(ATermAppl r, ATermAppl x) {
        this.ensureConsistency();
        Individual ind = this.abox.getIndividual(x);
        Role role = this.rbox.getRole(r);
        if (ind == null) {
            return Collections.EMPTY_LIST;
        }
        if (role == null) {
            return Collections.EMPTY_LIST;
        }
        return this.abox.getObviousDataPropertyValues(x, role);
    }

    public List getObjectPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null || !role.isObjectRole()) {
            throw new UnsupportedFeatureException("getObjectPropertyValues function can only be used with object properties. Property: " + role);
        }
        ATermAppl invR = role.getInverse().getName();
        return this.getIndividualsWithObjectProperty(invR, x);
    }

    public List getPropertyValues(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role.isObjectRole()) {
            return this.getObjectPropertyValues(r, x);
        }
        return this.getDataPropertyValues(r, x);
    }

    public List getIndividualsWithProperty(ATermAppl r, ATermAppl x) {
        Role role = this.rbox.getRole(r);
        if (role == null) {
            return Collections.EMPTY_LIST;
        }
        if (role.isObjectRole()) {
            return this.getIndividualsWithObjectProperty(r, x);
        }
        return this.getIndividualsWithDataProperty(r, x);
    }

    public List getIndividualsWithDataProperty(ATermAppl r, ATermAppl litValue) {
        this.ensureConsistency();
        Object value = this.getDatatypeReasoner().getValue(litValue);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl subj = ((Individual)i.next()).getName();
            Boolean hasObviousValue = this.abox.hasObviousDataPropertyValue(subj, r, value);
            if (hasObviousValue == null) {
                unknowns.add(subj);
                continue;
            }
            if (!hasObviousValue.booleanValue()) continue;
            knowns.add(subj);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl valueX = ATermUtils.makeValue(litValue);
            ATermAppl c = ATermUtils.normalize(ATermUtils.makeSomeValues(r, valueX));
            this.binaryInstanceRetrieval(c, unknowns, knowns);
        }
        return knowns;
    }

    public List getIndividualsWithObjectProperty(ATermAppl r, ATermAppl o) {
        this.ensureConsistency();
        if (!this.isIndividual(o)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl subj = ((Individual)i.next()).getName();
            Boolean hasObviousValue = this.abox.hasObviousObjectPropertyValue(subj, r, o);
            if (hasObviousValue == null) {
                unknowns.add(subj);
                continue;
            }
            if (!hasObviousValue.booleanValue()) continue;
            knowns.add(subj);
        }
        if (!unknowns.isEmpty()) {
            ATermAppl valueO = ATermUtils.makeValue(o);
            ATermAppl c = ATermUtils.normalize(ATermUtils.makeSomeValues(r, valueO));
            this.binaryInstanceRetrieval(c, unknowns, knowns);
        }
        return knowns;
    }

    public List retrieve(ATermAppl d) {
        this.ensureConsistency();
        Timer timer = this.timers.startTimer("retrieve");
        ATermAppl c = ATermUtils.normalize(d);
        ATermAppl notC = ATermUtils.negate(c);
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        if (!this.abox.isSatisfiable(notC)) {
            knowns.addAll(this.getIndividuals());
        } else if (this.abox.isSatisfiable(c)) {
            ArrayList<ATermAppl> unknowns = new ArrayList<ATermAppl>();
            IndividualIterator i = this.abox.getIndIterator();
            while (i.hasNext()) {
                ATermAppl x = ((Individual)i.next()).getName();
                if (this.abox.isObviousType(x, c)) {
                    knowns.add(x);
                    continue;
                }
                if (!this.abox.isPossibleType(x, c)) continue;
                unknowns.add(x);
            }
            if (!unknowns.isEmpty() && this.abox.isType(unknowns, c)) {
                this.binaryInstanceRetrieval(c, unknowns, knowns);
            }
        }
        timer.stop();
        return knowns;
    }

    public List retrieveIndividualsWithProperty(ATermAppl r) {
        this.ensureConsistency();
        ArrayList<ATermAppl> knowns = new ArrayList<ATermAppl>();
        IndividualIterator i = this.abox.getIndIterator();
        while (i.hasNext()) {
            ATermAppl x = ((Individual)i.next()).getName();
            if (!this.abox.hasProperty(x, r)) continue;
            knowns.add(x);
        }
        return knowns;
    }

    private void binaryInstanceRetrieval(ATermAppl c, List candidates, List results) {
        if (candidates.isEmpty()) {
            return;
        }
        List[] partitions = this.partition(candidates);
        this.partitionInstanceRetrieval(c, partitions, results);
    }

    private void partitionInstanceRetrieval(ATermAppl c, List[] partitions, List results) {
        if (partitions[0].size() == 1) {
            ATermAppl i = (ATermAppl)partitions[0].get(0);
            this.binaryInstanceRetrieval(c, partitions[1], results);
            if (this.isType(i, c)) {
                results.add(i);
            }
        } else if (!this.abox.isType(partitions[0], c)) {
            this.binaryInstanceRetrieval(c, partitions[1], results);
        } else if (!this.abox.isType(partitions[1], c)) {
            this.binaryInstanceRetrieval(c, partitions[0], results);
        } else {
            this.binaryInstanceRetrieval(c, partitions[0], results);
            this.binaryInstanceRetrieval(c, partitions[1], results);
        }
    }

    private List[] partition(List candidates) {
        List[] partitions = new List[2];
        int n = candidates.size();
        if (n <= 1) {
            partitions[0] = candidates;
            partitions[1] = new ArrayList();
        } else {
            partitions[0] = candidates.subList(0, n / 2);
            partitions[1] = candidates.subList(n / 2, n);
        }
        return partitions;
    }

    public void printClassTree() {
        this.classify();
        this.taxonomy.print();
    }

    public void printClassTree(OutputFormatter out) {
        this.classify();
        this.taxonomy.print(out);
    }

    public boolean doExplanation() {
        return this.abox.doExplanation();
    }

    public void setDoExplanation(boolean doExplanation) {
        this.abox.setDoExplanation(doExplanation);
    }

    public String getExplanation() {
        return this.abox.getExplanation();
    }

    public Set getExplanationSet() {
        return SetUtils.EMPTY_SET;
    }

    public void setRBox(RBox rbox) {
        this.rbox = rbox;
    }

    public void setTBox(TBox tbox) {
        this.tbox = tbox;
    }

    CompletionStrategy chooseStrategy(ABox abox) {
        if (PelletOptions.DEFAULT_COMPLETION_STRATEGY != null) {
            Class[] types = new Class[]{ABox.class};
            Object[] args = new Object[]{abox};
            try {
                Constructor cons = PelletOptions.DEFAULT_COMPLETION_STRATEGY.getConstructor(types);
                return (CompletionStrategy)cons.newInstance(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InternalReasonerException("Failed to create the default completion strategy defined in PelletOptions!");
            }
        }
        if (PelletOptions.USE_COMPLETION_STRATEGY) {
            Expressivity expressivity = this.getExpressivity();
            if (expressivity.hasNominal() || abox.size() > 1) {
                if (expressivity.hasInverse()) {
                    return new SHIONStrategy(abox);
                }
                return new SHONStrategy(abox);
            }
            if (expressivity.hasInverse()) {
                return new EmptySHINStrategy(abox);
            }
            return new EmptySHNStrategy(abox);
        }
        return new SHIONStrategy(abox);
    }

    public String getOntology() {
        return this.ontology;
    }

    public void setOntology(String ontology) {
        this.ontology = ontology;
    }

    public void setTimeout(long timeout) {
        this.timers.mainTimer.setTimeout(timeout);
    }

    Role getRole(ATerm term) {
        return this.rbox.getRole(term);
    }

    public Taxonomy getTaxonomy() {
        this.classify();
        return this.taxonomy;
    }
}

