/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.DatatypeReasoner;
import org.mindswap.pellet.datatypes.RDFSLiteral;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.UnionDatatype;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class Literal
extends Node {
    ATermAppl atermValue;
    Object value;
    Datatype datatype;
    private Edge inEdge;

    public Literal(ATermAppl name, ATermAppl atermValue, ABox abox) {
        super(name, abox);
        if (atermValue != null) {
            this.atermValue = ATermUtils.makeValue(atermValue);
            this.value = abox.dtReasoner.getValue(atermValue);
        }
    }

    public Literal(Literal literal, ABox abox) {
        super(literal, abox);
        this.atermValue = literal.atermValue;
        this.value = literal.value;
        this.inEdge = literal.inEdge;
    }

    public Node copyTo(ABox abox) {
        return new Literal(this, abox);
    }

    protected void updateNodeReferences() {
        super.updateNodeReferences();
        Individual ind = this.inEdge.getFrom();
        ATermAppl name = ind.getName();
        Individual from = this.abox.getIndividual(name);
        this.inEdge = new Edge(this.inEdge.getRole(), from, this, this.inEdge.getDepends());
        from.addOutEdge(this.inEdge);
    }

    public final boolean isLeaf() {
        return true;
    }

    public boolean isDifferent(Node node) {
        if (super.isDifferent(node)) {
            return true;
        }
        if (node instanceof Individual) {
            return true;
        }
        Literal literal = (Literal)node;
        if (this.value != null && literal.value != null) {
            return !this.value.equals(literal.value);
        }
        return false;
    }

    public boolean hasType(ATerm type) {
        return super.hasType(type) || this.atermValue != null && this.atermValue.equals(type);
    }

    public DependencySet getDifferenceDependency(Node node) {
        DependencySet ds = null;
        if (this.isDifferent(node) && (ds = (DependencySet)this.differents.get(node)) == null) {
            ds = DependencySet.INDEPENDENT;
        }
        return ds;
    }

    public void mergeTo(Node node, DependencySet ds) {
        super.mergeTo(node, ds);
        if (!this.abox.isInitialized()) {
            return;
        }
        Literal y = this;
        Literal z = (Literal)node;
        if (y.value != null) {
            if (z.value == null) {
                z.value = y.value;
            } else if (!z.value.equals(y.value)) {
                throw new InternalReasonerException("Trying to merge two distinct literals.Literal1: " + y.toTypedString() + " Literal2: " + z.toTypedString());
            }
        }
        Iterator yTypes = y.getTypes().iterator();
        while (yTypes.hasNext()) {
            ATermAppl yType = (ATermAppl)yTypes.next();
            DependencySet dep = y.getDepends(yType);
            z.addType(yType, dep.union(ds));
        }
        y.detach();
        z.setDifferents(y.getDifferents(), ds);
    }

    public void addType(ATermAppl c, DependencySet d) {
        if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList cs = (ATermList)c.getArgument(0);
            while (!cs.isEmpty()) {
                ATermAppl conj = (ATermAppl)cs.getFirst();
                if (!this.hasType(c)) {
                    super.addType(conj, d);
                }
                cs = cs.getNext();
            }
        } else {
            if (this.hasType(c)) {
                return;
            }
            super.addType(c, d);
        }
        this.checkClash();
    }

    public void addInEdge(Edge edge) {
        if (this.inEdge != null || !edge.getTo().equals(this)) {
            throw new InternalReasonerException("Trying to add another edge to a literal. Edge: " + edge);
        }
        if (edge == null) {
            throw new InternalReasonerException("Adding a null edge to a literal.");
        }
        this.inEdge = edge;
    }

    public void removeInEdge(Edge edge) {
        if (this.inEdge == null || !this.inEdge.equals(edge)) {
            throw new InternalReasonerException("Trying to remove a non-existing edge from a literal. Literal ID:" + this + " Edge: " + edge);
        }
        this.inEdge = null;
    }

    public void removeInEdges() {
        this.inEdge = null;
    }

    public EdgeList getInEdges() {
        EdgeList edges = new EdgeList();
        edges.addEdge(this.inEdge);
        return edges;
    }

    public Edge getInEdge() {
        return this.inEdge;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public ATermAppl getTerm() {
        return (ATermAppl)this.atermValue.getArgument(0);
    }

    public String getDatatypeURI() {
        if (this.atermValue != null) {
            ATermAppl literal = this.getTerm();
            String datatypeURI = ((ATermAppl)literal.getArgument(2)).getName();
            if (datatypeURI.equals("")) {
                return null;
            }
            return datatypeURI;
        }
        if (this.datatype == null) {
            return null;
        }
        if (this.datatype instanceof UnionDatatype) {
            return null;
        }
        if (this.datatype.getURI() != null) {
            return this.datatype.getURI();
        }
        AtomicDatatype primitive = ((AtomicDatatype)this.datatype).getPrimitiveType();
        return primitive.getURI();
    }

    public String getLang() {
        if (this.value != null && this.value instanceof StringValue) {
            return ((StringValue)this.value).getLang();
        }
        return "";
    }

    public String getLexicalValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    private void checkClash() {
        DependencySet ds;
        Set types;
        if (this.value == null && this.atermValue != null) {
            this.abox.setClash(Clash.invalidLiteral(this, DependencySet.INDEPENDENT, this.getTerm()));
            return;
        }
        if (this.hasType(ATermUtils.BOTTOM)) {
            this.abox.setClash(new Clash(this, 6, this.getDepends(ATermUtils.BOTTOM)));
            if (this.abox.doExplanation()) {
                System.out.println("1) Literal clash dependency = " + this.abox.getClash());
            }
        }
        if ((types = this.getTypes()).size() == 1) {
            this.datatype = RDFSLiteral.instance;
            return;
        }
        DatatypeReasoner dtReasoner = this.abox.getDatatypeReasoner();
        ATerm[] dt = new ATermAppl[types.size() - 1];
        int count = 0;
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ATermAppl type = (ATermAppl)i.next();
            if (type.equals(RDFSLiteral.instance.getName())) continue;
            dt[count++] = type;
        }
        this.datatype = dtReasoner.intersection(dt);
        if (this.datatype.isEmpty()) {
            ds = DependencySet.EMPTY;
            for (int i2 = 0; i2 < dt.length; ++i2) {
                ds = ds.union(this.getDepends(dt[i2]));
            }
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = "Types: " + this.getTypes().toString();
            }
            this.abox.setClash(new Clash((Node)this, 6, ds, exp));
        } else if (this.value != null && !this.datatype.contains(this.value)) {
            ds = DependencySet.EMPTY;
            for (int i3 = 0; i3 < dt.length; ++i3) {
                ds = ds.union(this.getDepends(dt[i3]));
            }
            if (this.value instanceof StringValue) {
                this.abox.setClash(Clash.missingDatatype(this, ds, this.getTerm(), (ATermAppl)dt[0]));
            } else {
                this.abox.setClash(Clash.valueDatatype(this, ds, this.getTerm(), (ATermAppl)dt[0]));
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public String toTypedString() {
        String str = "\"" + this.value + "\"";
        String lang = this.getLang();
        if (!lang.equals("")) {
            return str + "@" + lang;
        }
        String datatypeURI = this.getDatatypeURI();
        if (datatypeURI != null) {
            return str + "^^" + datatypeURI;
        }
        return str;
    }

    public String toString() {
        return this.toTypedString();
    }

    public String debugString() {
        return this.name + " = " + this.getTypes().toString();
    }
}

