/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyBuilder;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.URIUtils;

public class MatrixTaxonomyBuilder
extends TaxonomyBuilder {
    private int numClasses = this.classes.size() + 2;
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private ATermAppl[] classList = null;
    private int[] sameAs = null;
    static final byte UNKNOWN = 0;
    static final byte YES = 1;
    static final byte NO = 2;
    private byte[][] subclass = null;
    static final String[] chars = new String[]{"?", "+", "-"};

    public MatrixTaxonomyBuilder(KnowledgeBase kb) {
        super(kb);
        if (Taxonomy.DEBUG) {
            System.out.println("Classes: " + this.numClasses + " Individuals: " + kb.getIndividuals().size());
        }
        this.sameAs = new int[this.numClasses];
        this.classList = new ATermAppl[this.numClasses];
        this.classList[0] = ATermUtils.TOP;
        this.classList[1] = ATermUtils.BOTTOM;
        Iterator i = this.classes.iterator();
        int index = 2;
        while (i.hasNext()) {
            this.classList[index] = (ATermAppl)i.next();
            ++index;
        }
        this.subclass = new byte[this.numClasses][this.numClasses];
    }

    public Taxonomy classify() {
        this.init();
        this.notifyListener("satisfiabilityStarted");
        this.checkSatisfiability();
        if (Taxonomy.DEBUG) {
            System.out.println("Starting classification...");
        }
        this.notifyListener("classificationStarted");
        for (int i = 0; i < this.numClasses; ++i) {
            if (this.isCanceled()) {
                return null;
            }
            this.notifyListener(this.classList[i].getName());
            this.classify(i, new HashSet());
        }
        this.finished = true;
        if (Taxonomy.DEBUG) {
            this.printStats();
        }
        this.classList = null;
        this.subclass = null;
        this.sameAs = null;
        return this.taxonomy;
    }

    private void init() {
        int i;
        for (i = 2; i < this.numClasses; ++i) {
            this.subclass[i][i] = 2;
            this.subclass[i][0] = 1;
            this.subclass[1][i] = 1;
            this.sameAs[i] = i;
        }
        this.sameAs[0] = 0;
        this.sameAs[1] = 1;
        this.subclass[0][0] = 2;
        this.subclass[0][1] = 2;
        this.subclass[1][1] = 2;
        this.subclass[1][0] = 1;
        for (i = 0; i < this.numClasses; ++i) {
            TBox[] tbox = new TBox[]{this.kb.getTBox().Tu, this.kb.getTBox().Tg};
            for (int t = 0; t < tbox.length; ++t) {
                TermDefinition td = tbox[t].getTD(this.classList[i]);
                if (td == null) continue;
                if (td.getSames() != null) {
                    Iterator j = td.getSames().iterator();
                    while (j.hasNext()) {
                        ATermAppl c = (ATermAppl)j.next();
                        c = (ATermAppl)c.getArgument(1);
                        this.preclassify(i, c, true);
                    }
                }
                if (td.getSub() == null) continue;
                ATermAppl term = (ATermAppl)td.getSub().getArgument(1);
                if (term.getAFun().equals(ATermUtils.ANDFUN)) {
                    ATermList subs = (ATermList)term.getArgument(0);
                    while (!subs.isEmpty()) {
                        ATermAppl c = (ATermAppl)subs.getFirst();
                        this.preclassify(i, c, false);
                        subs = subs.getNext();
                    }
                    continue;
                }
                this.preclassify(i, term, false);
            }
        }
    }

    private void checkSatisfiability() {
        for (int i = 2; i < this.numClasses; ++i) {
            if (this.isCanceled()) {
                return;
            }
            this.notifyListener(this.classList[i].getName());
            if (this.subclass[i][1] == 1) {
                this.kb.getABox().cacheUnsatConcept(this.classList[i]);
                continue;
            }
            if (Taxonomy.DEBUG) {
                System.out.print(i + ") Satisfiability testing for " + this.getClassName(i) + " ");
            }
            long time = System.currentTimeMillis();
            boolean isSatisfiable = this.kb.isSatisfiable(this.classList[i]);
            time = System.currentTimeMillis() - time;
            if (Taxonomy.DEBUG) {
                System.out.print((isSatisfiable ? "true" : "*****FALSE*****") + " (" + time + "ms)");
            }
            int n = this.subclass[i][1] = isSatisfiable ? 2 : 1;
            if (!isSatisfiable) {
                this.taxonomy.addEquivalentNode(this.classList[i], this.taxonomy.getBottom());
            }
            if (!PelletOptions.USE_CACHING) continue;
            if (Taxonomy.DEBUG) {
                System.out.print("...negation ");
            }
            time = System.currentTimeMillis();
            isSatisfiable = this.kb.isSatisfiable(ATermUtils.makeNot(this.classList[i]));
            time = System.currentTimeMillis() - time;
            int n2 = this.subclass[0][i] = isSatisfiable ? 2 : 1;
            if (!isSatisfiable) {
                this.taxonomy.addEquivalentNode(this.classList[i], this.taxonomy.getTop());
            }
            if (!Taxonomy.DEBUG) continue;
            System.out.println(isSatisfiable + " (" + time + "ms)");
        }
    }

    private void preclassify(int i, ATermAppl c, boolean isSame) {
        ATermAppl negation;
        if (ATermUtils.isPrimitive(c)) {
            if (c.getName().startsWith("bNode")) {
                return;
            }
            int k = this.index(c);
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Preclassify (1) " + this.getClassName(i) + " " + this.getClassName(k));
            }
            this.mark(i, k);
            if (isSame) {
                if (Taxonomy.DETAILED_DEBUG) {
                    System.out.println("Preclassify (2) " + this.getClassName(k) + " " + this.getClassName(i));
                }
                this.mark(k, i);
            }
        } else if (c.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)c.getArgument(0);
            while (!conj.isEmpty()) {
                this.preclassify(i, (ATermAppl)conj.getFirst(), false);
                conj = conj.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.ORFUN)) {
            if (!isSame) {
                return;
            }
            ATermList disj = (ATermList)c.getArgument(0);
            while (!disj.isEmpty()) {
                ATermAppl d = (ATermAppl)disj.getFirst();
                if (ATermUtils.isPrimitive(d)) {
                    int other = this.index(d);
                    if (Taxonomy.DETAILED_DEBUG) {
                        System.out.println("Preclassify (3) " + this.getClassName(other) + " " + this.getClassName(i));
                    }
                    this.mark(other, i);
                }
                disj = disj.getNext();
            }
        } else if (c.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)c.getArgument(0))) {
            int other = this.index(negation);
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Preclassify (4) " + this.getClassName(i) + " " + this.getClassName(other));
            }
            this.unmark(i, other);
            this.unmark(other, i);
        }
    }

    private List search(boolean topSearch, int c, int x, Set visited, List result) {
        ArrayList<Integer> posSucc = new ArrayList<Integer>();
        visited.add(new Integer(x));
        TaxonomyNode node = this.taxonomy.getNode(this.classList[x]);
        List list = topSearch ? node.getSubs() : node.getSupers();
        for (int i = 0; i < list.size(); ++i) {
            TaxonomyNode next = (TaxonomyNode)list.get(i);
            int y = this.index(next.getConcept());
            if (topSearch) {
                if (!this.isSubClassOf(c, y)) continue;
                posSucc.add(new Integer(y));
                continue;
            }
            if (!this.isSubClassOf(y, c)) continue;
            posSucc.add(new Integer(y));
        }
        if (posSucc.isEmpty()) {
            result.add(new Integer(x));
        } else {
            Iterator i = posSucc.iterator();
            while (i.hasNext()) {
                Integer y = (Integer)i.next();
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result);
            }
        }
        return result;
    }

    private void classify(int i, Set list) {
        int j;
        if (this.taxonomy.contains(this.classList[i])) {
            return;
        }
        Integer o = new Integer(i);
        if (list.contains(o)) {
            return;
        }
        list.add(o);
        if (Taxonomy.DEBUG) {
            System.out.println("Classify " + i + " " + this.getClassName(i) + "...");
        }
        for (int j2 = 0; j2 < this.numClasses; ++j2) {
            if (this.subclass[i][j2] != 1) continue;
            this.classify(j2, list);
        }
        List supers = this.search(true, i, 0, new HashSet(), new ArrayList());
        if (supers.size() == 1 && this.isSubClassOf(j = ((Integer)supers.iterator().next()).intValue(), i)) {
            if (Taxonomy.DEBUG) {
                System.out.println(i + " is same as " + j);
            }
            TaxonomyNode sup = this.taxonomy.getNode(this.classList[j]);
            this.taxonomy.addEquivalentNode(this.classList[i], sup);
            this.sameAs[i] = this.sameAs[j];
            return;
        }
        TaxonomyNode node = this.taxonomy.addNode(this.classList[i]);
        Iterator i1 = supers.iterator();
        while (i1.hasNext()) {
            int j3 = (Integer)i1.next();
            TaxonomyNode sup = this.taxonomy.getNode(this.classList[j3]);
            sup.addSub(node);
        }
        List subs = this.search(false, i, 1, new HashSet(), new ArrayList());
        Iterator i2 = subs.iterator();
        while (i2.hasNext()) {
            int j4 = (Integer)i2.next();
            TaxonomyNode sub = this.taxonomy.getNode(this.classList[j4]);
            node.addSub(sub);
        }
        node.removeMultiplePaths();
    }

    private int index(ATermAppl c) {
        for (int i = 0; i < this.numClasses; ++i) {
            if (!this.classList[i].equals(c)) continue;
            return this.sameAs[i];
        }
        return -1;
    }

    private void mark(int i, int j) {
        int k;
        if (i == 0) {
            System.out.println("DEBUG");
        }
        if (i == j) {
            return;
        }
        if (this.subclass[i][j] == 1) {
            return;
        }
        if (this.subclass[i][j] == 2) {
            throw new RuntimeException("marking unmarked cells [" + i + "," + j + "] " + this.classList[i] + " " + this.classList[j]);
        }
        this.subclass[i][j] = 1;
        for (k = 0; k < this.numClasses; ++k) {
            if (this.subclass[j][k] != 1) continue;
            this.mark(i, k);
        }
        for (k = 0; k < this.numClasses; ++k) {
            if (this.subclass[k][i] != 1) continue;
            this.mark(k, j);
        }
    }

    private void unmark(int i, int j) {
        int k;
        if (this.subclass[i][j] == 2) {
            return;
        }
        if (this.subclass[i][j] == 1) {
            throw new RuntimeException("unmarking marked cells [" + i + "," + j + "] " + this.classList[i] + " " + this.classList[j]);
        }
        this.subclass[i][j] = 2;
        for (k = 0; k < this.numClasses; ++k) {
            if (this.subclass[k][j] != 1) continue;
            this.unmark(i, k);
        }
        for (k = 0; k < this.numClasses; ++k) {
            if (this.subclass[i][k] != 1) continue;
            this.unmark(k, j);
        }
    }

    private boolean isSubClassOf(int i, int j) {
        boolean result;
        if (this.subclass[i][j] == 0) {
            long time = System.currentTimeMillis();
            long count = this.kb.getABox().satisfiabilityCount;
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.print("Subsumption testing for [" + i + "," + j + "] " + this.getClassName(i) + " " + this.getClassName(j) + "...");
            }
            this.kb.timers.startTimer("classifySub");
            result = this.kb.isSubClassOf(this.classList[i], this.classList[j]);
            this.kb.timers.stopTimer("classifySub");
            if (Taxonomy.DETAILED_DEBUG) {
                time = this.kb.getABox().satisfiabilityCount > count ? System.currentTimeMillis() - time : time - System.currentTimeMillis();
                System.out.println(" done (" + chars[result ? 1 : 2] + ") (" + time + "ms)");
            }
            if (result) {
                this.mark(i, j);
            } else {
                this.unmark(i, j);
            }
        } else {
            result = this.subclass[i][j] == 1;
        }
        return result;
    }

    public void printStats() {
        System.out.println("Sub Count: " + this.kb.timers.getTimer("classifySub").getCount());
        System.out.println("Sat Count: " + (this.kb.abox.satisfiabilityCount - (long)(2 * this.kb.tbox.classes.size())));
    }

    private String getClassName(int i) {
        if (i == 0) {
            return "owl:Thing";
        }
        if (i == 1) {
            return "owl:Nothing";
        }
        return URIUtils.getLocalName(this.classList[i].getName());
    }
}

