/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import java.util.List;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.NodeMerge;
import org.mindswap.pellet.Role;

class MaxBranch
extends Branch {
    List mergePairs;
    Role r;
    int n;

    MaxBranch(ABox abox, Individual x, Role r, int n, List mergePairs, DependencySet ds) {
        super(abox, x, ds, mergePairs.size());
        this.r = r;
        this.n = n;
        this.mergePairs = mergePairs;
    }

    protected Branch copyTo(ABox abox) {
        Individual x = abox.getIndividual(this.node.getName());
        MaxBranch b = new MaxBranch(abox, x, this.r, this.n, this.mergePairs, this.termDepends);
        b.anonCount = this.anonCount;
        b.nodeCount = this.nodeCount;
        b.branch = this.branch;
        return b;
    }

    protected boolean tryBranch() {
        this.abox.incrementBranch();
        DependencySet ds = this.termDepends;
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            NodeMerge nm = (NodeMerge)this.mergePairs.get(this.tryNext);
            Node y = this.abox.getNode(nm.y);
            Node z = this.abox.getNode(nm.z);
            if (ABox.DEBUG) {
                System.out.println("MAX : (" + (this.tryNext + 1) + "/" + this.mergePairs.size() + ") at branch (" + this.branch + ") to  " + this.node + " for prop " + this.r + " merge " + y + " -> " + z);
            }
            ds = ds.union(new DependencySet(this.branch));
            EdgeList rNeighbors = this.node.getRNeighborEdges(this.r);
            ds = ds.union(rNeighbors.getEdgesContaining(y).edgeAt(0).getDepends());
            ds = ds.union(rNeighbors.getEdgesContaining(z).edgeAt(0).getDepends());
            y.mergeTo(z, ds);
            boolean earlyClash = this.abox.isClosed();
            if (earlyClash) {
                if (ABox.DEBUG) {
                    System.out.println("CLASH: Branch " + this.branch + " " + this.abox.getClash() + "!");
                }
                if (!(clashDepends = this.abox.getClash().depends).contains(this.branch)) {
                    return false;
                }
            } else {
                return true;
            }
            this.restore();
            this.abox.incrementBranch();
            this.prevDS[this.tryNext] = clashDepends.copy();
            ++this.tryNext;
        }
        ds = DependencySet.EMPTY;
        for (int k = 0; k < this.tryCount; ++k) {
            ds = ds.union(this.prevDS[k]);
        }
        ds.remove(this.branch);
        this.abox.setClash(Clash.maxCardinality(this.node, ds));
        return false;
    }

    public String toString() {
        if (this.tryNext < this.mergePairs.size()) {
            return "Branch " + this.branch + " max rule on " + this.node + " merged  " + this.mergePairs.get(this.tryNext);
        }
        return "Branch " + this.branch + " max rule on " + this.node + " exhausted merge possibilities";
    }
}

