/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;

public abstract class Node {
    public static boolean DEBUG = false;
    public static int CHANGED = 127;
    public static int UNCHANGED = 0;
    public static int ATOM = 0;
    public static int OR = 1;
    public static int SOME = 2;
    public static int ALL = 3;
    public static int MIN = 4;
    public static int MAX = 5;
    public static int NOM = 6;
    public static int TYPES = 7;
    private String ontology;
    private int status;
    protected ABox abox;
    protected ATermAppl name;
    protected Map depends;
    protected int depth = 1;
    private boolean isRoot;
    protected Node mergedTo = this;
    protected DependencySet mergeDepends = null;
    protected Map differents;
    int branch;

    protected Node(ATermAppl name, ABox abox) {
        this.name = name;
        this.abox = abox;
        if (abox != null) {
            this.ontology = abox.getKB().getOntology();
        }
        this.isRoot = !name.getName().startsWith("anon");
        this.mergeDepends = DependencySet.INDEPENDENT;
        this.differents = new HashMap();
        this.depends = new HashMap();
        this.status = CHANGED;
    }

    protected Node(Node node, ABox abox) {
        this.name = node.getName();
        this.abox = abox;
        this.ontology = node.ontology;
        this.isRoot = node.isRoot;
        this.mergeDepends = node.mergeDepends;
        this.mergedTo = node.mergedTo;
        this.differents = node.differents;
        this.depends = new HashMap(node.depends);
        this.branch = node.branch;
        this.status = CHANGED;
    }

    protected void updateNodeReferences() {
        this.mergedTo = this.abox.getNode(this.mergedTo.getName());
        HashMap diffs = new HashMap(this.differents.size());
        Iterator i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Node node = (Node)entry.getKey();
            diffs.put(this.abox.getNode(node.getName()), entry.getValue());
        }
        this.differents = diffs;
    }

    public final Node copy() {
        return this.copyTo(null);
    }

    public final boolean isChanged() {
        return this.status != UNCHANGED;
    }

    public final boolean isChanged(int type) {
        return (this.status & 1 << type) != 0;
    }

    public final void setChanged(boolean changed) {
        this.status = changed ? CHANGED : UNCHANGED;
    }

    public void setOntology(String ont) {
        this.ontology = ont;
    }

    public String getOntology() {
        return this.ontology;
    }

    public void setChanged(int type, boolean changed) {
        this.status = changed ? (this.status |= 1 << type) : (this.status &= ~(1 << type));
    }

    public final boolean isBnode() {
        return this.name.getName().startsWith("bNode");
    }

    public final boolean isNamedIndividual() {
        return this.isRoot && !this.isBnode();
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public abstract boolean isLeaf();

    public abstract Node copyTo(ABox var1);

    public abstract void addInEdge(Edge var1);

    public abstract void removeInEdge(Edge var1);

    public abstract EdgeList getInEdges();

    public abstract void removeInEdges();

    public void restore(int branch) {
        DependencySet d;
        if (DEBUG) {
            System.out.println("Node " + this.name);
        }
        if (ABox.DEBUG && this.getNameStr().indexOf(":Exec") != -1) {
            System.out.println("DEBUG");
        }
        this.status = CHANGED;
        Iterator i = null;
        if (this.mergeDepends.branch > branch) {
            if (DEBUG) {
                System.out.println("Restoring merged node - " + this.name);
            }
            this.mergeDepends = DependencySet.INDEPENDENT;
            this.mergedTo = this;
            this.reattach(branch);
        }
        i = this.getTypes().iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            d = this.getDepends(c);
            if (d.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("Restoring added type - remove " + this.name + " " + c + " " + d + " " + branch);
            }
            i.remove();
            this.removeType(c);
        }
        i = this.getInEdges().iterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            d = e.getDepends();
            if (d.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("Restoring added reverse edge - delete " + e);
            }
            i.remove();
        }
        i = this.differents.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Node node = (Node)entry.getKey();
            DependencySet d2 = (DependencySet)entry.getValue();
            if (d2.branch <= branch) continue;
            if (DEBUG) {
                System.out.println("Restoring added difference - delete " + node);
            }
            i.remove();
        }
    }

    public void detach() {
        EdgeList edges = this.getInEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            Individual pred = edge.getFrom();
            pred.removeEdge(edge);
        }
    }

    public void reattach(int branch) {
        EdgeList edges = this.getInEdges();
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = edges.edgeAt(i);
            DependencySet d = edge.getDepends();
            if (d.branch > branch) continue;
            Individual pred = edge.getFrom();
            pred.addOutEdge(edge);
        }
    }

    public void addType(ATermAppl c, DependencySet ds) {
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        int max = ds.max();
        if (ds.branch == -1 && max != 0) {
            ds.branch = max + 1;
        }
        this.depends.put(c, ds);
        this.abox.changed = true;
    }

    public void removeType(ATermAppl c) {
        this.depends.remove(c);
        this.status = CHANGED;
    }

    public boolean hasType(ATerm c) {
        return this.depends.containsKey(c);
    }

    public Individual getParent() {
        EdgeList inEdges = this.getInEdges();
        if (inEdges == null || inEdges.size() == 0) {
            return null;
        }
        return inEdges.edgeAt(0).getFrom();
    }

    public final Set getPredecessors() {
        return this.getInEdges().getPredecessors();
    }

    public Set getAncestors() {
        if (this.isRoot()) {
            return Collections.EMPTY_SET;
        }
        return this.getAncestors(new HashSet());
    }

    protected Set getAncestors(Set ancestors) {
        EdgeList inEdges = this.getInEdges();
        int n = inEdges.size();
        for (int i = 0; i < n; ++i) {
            Individual pred = inEdges.edgeAt(i).getFrom();
            if (pred == this || ancestors.contains(pred)) continue;
            ancestors.add(pred);
            pred.getAncestors(ancestors);
        }
        return ancestors;
    }

    final boolean hasPredecessor(Individual x) {
        return x.hasSuccessor(this);
    }

    final boolean hasAncestor(Individual x) {
        return this.getAncestors().contains(x);
    }

    public final DependencySet getDepends(ATerm c) {
        return (DependencySet)this.depends.get(c);
    }

    public final Map getDepends() {
        return this.depends;
    }

    public final Set getTypes() {
        return this.depends.keySet();
    }

    public void removeTypes() {
        this.depends.clear();
        this.status = CHANGED;
    }

    public final int mergedAt() {
        return this.mergeDepends.branch;
    }

    public final boolean isMerged() {
        return this.mergedTo != this;
    }

    public final DependencySet getMergeDependency() {
        return this.mergeDepends;
    }

    public Node getMergedTo() {
        if (this.mergedTo == this) {
            return this;
        }
        return this.mergedTo.getMergedTo();
    }

    public void mergeTo(Node node, DependencySet ds) {
        if (this.isSame(node)) {
            return;
        }
        if (this.isDifferent(node)) {
            throw new RuntimeException("Trying to set two distinct equals equal " + this.name + ", " + node.getNameStr() + " " + ds);
        }
        this.mergedTo = node;
        this.mergeDepends = ds.copy();
        this.mergeDepends.branch = this.abox.getBranch();
    }

    public final void setSame(Node node, DependencySet ds) {
        this.mergeTo(node, ds);
    }

    public boolean isSame(Node node) {
        return this.getMergedTo().equals(node.getMergedTo());
    }

    public boolean isDifferent(Node node) {
        return this.differents.containsKey(node);
    }

    public void setDifferent(Node node, DependencySet ds) {
        if (this.isDifferent(node)) {
            return;
        }
        ds = ds.copy();
        ds.branch = this.abox.getBranch();
        this.differents.put(node, ds);
        node.setDifferent(this, ds);
    }

    public void setDifferents(Set set, DependencySet ds) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Node diff = (Node)i.next();
            this.setDifferent(diff, ds);
        }
    }

    public final Set getDifferents() {
        return this.differents.keySet();
    }

    public DependencySet getDifferenceDependency(Node node) {
        return (DependencySet)this.differents.get(node);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final ATermAppl getName() {
        return this.name;
    }

    public abstract ATermAppl getTerm();

    public final String getNameStr() {
        return this.name.getName();
    }

    public String toString() {
        return this.name.getName();
    }

    public final List getPath() {
        LinkedList<ATermAppl> path = new LinkedList<ATermAppl>();
        if (this.isNamedIndividual()) {
            path.add(this.name);
        } else {
            Node node = this;
            while (!node.getInEdges().isEmpty()) {
                Edge inEdge = node.getInEdges().edgeAt(0);
                node = inEdge.getFrom();
                path.addFirst(inEdge.getRole().getName());
                if (!node.isNamedIndividual()) continue;
                path.addFirst(node.getName());
                break;
            }
        }
        return path;
    }

    public ABox getABox() {
        return this.abox;
    }
}

