/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermInt;
import aterm.ATermList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Branch;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.CompletionStrategy;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.DisjunctionBranch;
import org.mindswap.pellet.EconnectedKB;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.MaxBranch;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PECDoubleBlocking;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.ATermUtils;

public class PECSHIONStrategy
extends CompletionStrategy {
    public PECSHIONStrategy(ABox abox) {
        super(abox, new PECDoubleBlocking(abox));
    }

    protected void applyDisjunctionRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = (Individual)i.next();
            node.setChanged(Node.OR, false);
            if (!node.canApply(Node.OR) || this.blocking.isIndirectlyBlocked(node)) continue;
            List types = node.getTypes(Node.OR);
            int size = types.size();
            for (int j = node.applyNext[Node.OR]; j < size; ++j) {
                ATermAppl disjunction = (ATermAppl)types.get(j);
                ATermAppl a = (ATermAppl)disjunction.getArgument(0);
                ATermList disjuncts = (ATermList)a.getArgument(0);
                ATerm[] disj = new ATerm[disjuncts.getLength()];
                int index = 0;
                while (!disjuncts.isEmpty()) {
                    disj[index] = ATermUtils.negate((ATermAppl)disjuncts.getFirst());
                    if (node.hasType(disj[index])) break;
                    disjuncts = disjuncts.getNext();
                    ++index;
                }
                if (!disjuncts.isEmpty()) continue;
                DisjunctionBranch newBranch = new DisjunctionBranch(this.abox, node, disjunction, node.getDepends(disjunction), disj);
                this.addBranch(newBranch);
                if (newBranch.tryNext()) continue;
                return;
            }
            node.applyNext[Node.OR] = size;
        }
    }

    protected boolean applyMaxRule(Individual x, Role r, int k, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set neighbors = edges.getNeighbors(x);
        if (k == 0 && neighbors.size() > 0) {
            for (int e = 0; e < edges.size(); ++e) {
                Edge edge = edges.edgeAt(e);
                ds = ds.union(edge.getDepends());
            }
            String exp = null;
            if (this.abox.doExplanation()) {
                exp = "Individual " + x + " should not have any value for property " + r;
            }
            this.abox.setClash(new Clash((Node)x, 4, ds, exp));
            return false;
        }
        if (neighbors.size() <= k) {
            return false;
        }
        List mergePairs = this.findMergeNodes(neighbors);
        if (mergePairs.size() == 0) {
            DependencySet dsEdges = x.hasDistinctRNeighborsForMax(r, k + 1);
            if (dsEdges == null) {
                return false;
            }
            if (ABox.DEBUG) {
                System.out.println("Early clash detection for max rule worked " + x + " has more than " + k + " " + r + " edges " + ds.union(dsEdges) + " " + x.getRNeighborEdges(r).getNeighbors(x));
            }
            if (this.abox.doExplanation()) {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges), r.getName(), k));
            } else {
                this.abox.setClash(Clash.maxCardinality(x, ds.union(dsEdges)));
            }
            return false;
        }
        MaxBranch newBranch = new MaxBranch(this.abox, x, r, k, mergePairs, ds);
        this.addBranch(newBranch);
        if (!newBranch.tryNext()) {
            return false;
        }
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        return neighbors.size() > k + 1;
    }

    protected void applyFunctionalMaxRule(Individual x, Role r, DependencySet ds) {
        EdgeList edges = x.getRNeighborEdges(r);
        Set neighbors = edges.getNeighbors(x);
        if (neighbors.size() <= 1) {
            return;
        }
        Iterator i = neighbors.iterator();
        Node head = (Node)i.next();
        ds = ds.union(edges.getEdgesContaining(head).edgeAt(0).getDepends());
        while (i.hasNext()) {
            Node next = (Node)i.next();
            ds = ds.union(edges.getEdgesContaining(next).edgeAt(0).getDepends());
            if (next.isDifferent(head)) {
                ds = ds.union(next.getDifferenceDependency(head));
                this.abox.setClash(Clash.maxCardinality(x, ds));
                return;
            }
            if (head.isRoot() || next.isLeaf() || next.hasAncestor((Individual)head)) {
                if (ABox.DEBUG) {
                    System.out.println("Apply max rule to  " + x + " for prop " + r + " merge " + next + " -> " + head);
                }
                next.mergeTo(head, ds);
            } else {
                if (ABox.DEBUG) {
                    System.out.println("Apply max rule to  " + x + " for prop " + r + " merge " + head + " -> " + next);
                }
                head.mergeTo(next, ds);
                head = next;
            }
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected void applyMaxRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.isChanged(Node.MAX)) continue;
            List maxCardinality = x.getTypes(Node.MAX);
            if (this.blocking.isIndirectlyBlocked(x)) continue;
            Iterator j = maxCardinality.iterator();
            while (j.hasNext()) {
                ATermAppl mc = (ATermAppl)j.next();
                ATermAppl max = (ATermAppl)mc.getArgument(0);
                Role r = this.abox.getRole(max.getArgument(0));
                int n = ((ATermInt)max.getArgument(1)).getInt() - 1;
                DependencySet ds = x.getDepends(mc);
                if (n == 1) {
                    this.applyFunctionalMaxRule(x, r, ds);
                    if (!this.abox.isClosed()) continue;
                    return;
                }
                boolean hasMore = true;
                while (hasMore) {
                    hasMore = this.applyMaxRule(x, r, n, ds);
                    if (!this.abox.isClosed() && !x.isMerged()) continue;
                    return;
                }
            }
            j = ((EconnectedKB)this.abox.getKB()).getRBox().getFunctionalRoles().iterator();
            while (j.hasNext()) {
                Role r = (Role)j.next();
                this.applyFunctionalMaxRule(x, r, DependencySet.INDEPENDENT);
                if (!this.abox.isClosed() && !x.isMerged()) continue;
                return;
            }
            x.setChanged(Node.MAX, false);
        }
    }

    protected void applyMinRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.canApply(Individual.MIN) || this.blocking.isBlocked(x)) continue;
            List types = x.getTypes(Node.MIN);
            int size = types.size();
            for (int j = x.applyNext[Node.MIN]; j < size; ++j) {
                int c1;
                int n;
                ATermAppl mc = (ATermAppl)types.get(j);
                Role r = this.abox.getRole(mc.getArgument(0));
                if (x.hasDistinctRNeighborsForMin(r, n = ((ATermInt)mc.getArgument(1)).getInt())) continue;
                if (ABox.DEBUG) {
                    System.out.println("Apply min rule to " + x + " " + mc + " anon" + (this.abox.anonCount + 1) + " - anon" + (this.abox.anonCount + n));
                }
                DependencySet ds = x.getDepends(mc);
                Node[] y = new Node[n];
                for (c1 = 0; c1 < n; ++c1) {
                    ATermAppl name = this.abox.createUniqueName();
                    if (r.isDatatypeRole()) {
                        y[c1] = this.abox.addLiteral();
                    } else {
                        y[c1] = this.abox.addIndividual(name);
                        y[c1].depth = x.depth + 1;
                        if (x.depth >= this.abox.treeDepth) {
                            this.abox.treeDepth = x.depth + 1;
                        }
                        if (r.isLinkRole()) {
                            y[c1].setOntology(r.getForeignOntology());
                        } else {
                            y[c1].setOntology(x.getOntology());
                        }
                    }
                    x.addOutEdge(r, y[c1], ds);
                }
                for (c1 = 0; c1 < n; ++c1) {
                    for (int c2 = c1 + 1; c2 < n; ++c2) {
                        y[c1].setDifferent(y[c2], ds);
                    }
                }
            }
            x.applyNext[Node.MIN] = size;
        }
    }

    protected void applyNominalRule(IndividualIterator i) {
        boolean ruleApplied = true;
        while (ruleApplied) {
            ruleApplied = false;
            i.reset();
            while (i.hasNext()) {
                Individual y = (Individual)i.next();
                if (!y.canApply(Individual.NOM) || this.blocking.isBlocked(y)) continue;
                List types = y.getTypes(Node.NOM);
                int size = types.size();
                for (int j = y.applyNext[Node.NOM]; j < size; ++j) {
                    ATermAppl nc = (ATermAppl)types.get(j);
                    DependencySet ds = y.getDepends(nc);
                    Individual z = this.abox.getIndividual(nc.getArgument(0));
                    if (z.isMerged()) {
                        if (z.mergedAt() < this.abox.getBranch()) {
                            ds = ds.union(z.getMergeDependency());
                        }
                        z = (Individual)z.getMergedTo();
                    }
                    ATermUtils.assertTrue(this.abox.getNodes().contains(z));
                    if (y.equals(z) || y.isSame(z)) continue;
                    if (y.isDifferent(z)) {
                        ds = ds.union(y.getDifferenceDependency(z));
                        this.abox.setClash(new Clash(y, 5, ds));
                        return;
                    }
                    if (ABox.DEBUG) {
                        System.out.println("Apply nominal rule to  " + y + " -> " + z);
                    }
                    if (ABox.DEBUG) {
                        this.abox.printTree();
                    }
                    y.mergeTo(z, ds);
                    if (ABox.DEBUG) {
                        this.abox.printTree();
                    }
                    if (this.abox.isClosed()) {
                        return;
                    }
                    ruleApplied = true;
                    break;
                }
                y.applyNext[Node.NOM] = size;
                y.setChanged(Node.NOM, false);
            }
        }
    }

    protected void applySomeValuesRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual x = (Individual)i.next();
            if (!x.canApply(Individual.SOME) || this.blocking.isBlocked(x)) continue;
            List types = x.getTypes(Node.SOME);
            int size = types.size();
            for (int j = x.applyNext[Node.SOME]; j < size; ++j) {
                ATermAppl sv = (ATermAppl)types.get(j);
                ATermAppl a = (ATermAppl)sv.getArgument(0);
                ATermAppl s = (ATermAppl)a.getArgument(0);
                ATermAppl c = (ATermAppl)a.getArgument(1);
                Role role = this.abox.getRole(s);
                c = ATermUtils.negate(c);
                boolean neighborFound = false;
                Node y = null;
                Edge edge = null;
                EdgeList edges = x.getRNeighborEdges(role);
                for (int e = 0; !neighborFound && e < edges.size(); ++e) {
                    edge = edges.edgeAt(e);
                    y = edge.getNeighbor(x);
                    neighborFound = y.hasType(c);
                }
                if (neighborFound) continue;
                DependencySet ds = x.getDepends(sv).copy();
                if (role.isDatatypeRole()) {
                    if (ABox.DEBUG) {
                        System.out.println("Apply some values rule to  " + x + " -> " + y + " " + s + " " + c);
                    }
                    Literal literal = null;
                    if (ATermUtils.isNominal(c)) {
                        literal = this.abox.addLiteral((ATermAppl)c.getArgument(0));
                    } else {
                        literal = this.abox.addLiteral();
                        literal.addType(c, ds);
                    }
                    x.addOutEdge(role, literal, ds);
                } else if (ATermUtils.isNominal(c)) {
                    y = this.abox.getIndividual(c.getArgument(0));
                    if (ABox.DEBUG) {
                        System.out.println("Apply has value " + x + " " + s + " " + y + " " + ds);
                    }
                    x.addOutEdge(role, y, ds);
                } else {
                    boolean useExistingNode = false;
                    boolean useExistingRole = false;
                    if (role.isFunctional()) {
                        if (!edges.isEmpty()) {
                            useExistingNode = true;
                            useExistingRole = true;
                        } else {
                            Role fs = role.getFunctionalSupers()[0];
                            edges = x.getRNeighborEdges(fs);
                            if (!edges.isEmpty()) {
                                useExistingNode = true;
                                edge = edges.edgeAt(0);
                                y = edge.getNeighbor(x);
                            }
                        }
                    }
                    if (useExistingNode) {
                        ds = ds.union(edge.getDepends());
                    } else {
                        y = this.abox.addIndividual(this.abox.createUniqueName());
                        if (role.isLinkRole()) {
                            y.setOntology(role.getForeignOntology());
                        } else if (((EconnectedKB)this.abox.getKB()).getTBoxes().size() > 1) {
                            y.setOntology(x.getOntology());
                        }
                        y.depth = x.depth + 1;
                        if (x.depth >= this.abox.treeDepth) {
                            this.abox.treeDepth = x.depth + 1;
                        }
                    }
                    if (ABox.DEBUG) {
                        System.out.println("Apply some values rule to  " + x + " -> " + y + " " + s + " " + c + " " + ds + (useExistingNode ? " (old)" : " (new)"));
                    }
                    if (!useExistingRole) {
                        x.addOutEdge(role, y, ds);
                    }
                    y.addType(c, ds);
                }
                if (!this.abox.isClosed()) continue;
                return;
            }
            x.applyNext[Individual.SOME] = size;
        }
    }

    protected void applyUnfoldingRule(IndividualIterator i) {
        i.reset();
        while (i.hasNext()) {
            Individual node = (Individual)i.next();
            if (node.getOntology() == null) {
                System.out.print("");
            }
            if (((EconnectedKB)this.abox.getKB()).getTBox(node.getOntology()) == null) {
                System.out.print("");
            }
            Map normalizedMap = ((EconnectedKB)this.abox.getKB()).getTBox((String)node.getOntology()).Tu.normalizedMap;
            if (!node.canApply(Node.ATOM) || this.blocking.isBlocked(node)) continue;
            List types = node.getTypes(Node.ATOM);
            int size = types.size();
            for (int j = node.applyNext[Node.ATOM]; j < size; ++j) {
                ATermAppl c = (ATermAppl)types.get(j);
                ATermAppl unfolded = (ATermAppl)normalizedMap.get(c);
                if (unfolded == null) continue;
                DependencySet ds = node.getDepends(c).copy();
                if (ABox.DEBUG && !node.hasType(unfolded)) {
                    System.out.println("Apply unfolding rule to  " + node + ": " + c + " -> " + unfolded + " " + ds);
                }
                node.addType(unfolded, ds);
                size = types.size();
                if (!this.abox.isClosed()) continue;
                return;
            }
            node.applyNext[Node.ATOM] = size;
            if (!this.abox.isClosed()) continue;
            return;
        }
    }

    protected boolean backtrack() {
        boolean branchFound = false;
        while (!branchFound) {
            int lastBranch = this.abox.getClash().depends.max();
            if (lastBranch <= 0) {
                return false;
            }
            if (lastBranch > this.abox.getBranches().size()) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but has only " + this.abox.getBranches().size() + " branches");
            }
            List branches = this.abox.getBranches();
            branches.subList(lastBranch, branches.size()).clear();
            Branch newBranch = (Branch)branches.get(lastBranch - 1);
            if (ABox.DEBUG) {
                System.out.println("Backtracking to branch " + lastBranch + " -> " + newBranch);
            }
            if (lastBranch != newBranch.branch) {
                throw new InternalReasonerException("Backtrack: Trying to backtrack to branch " + lastBranch + " but got " + newBranch.branch);
            }
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.prevDS[newBranch.tryNext] = this.abox.getClash().depends.copy();
            }
            ++newBranch.tryNext;
            if (newBranch.tryNext < newBranch.tryCount) {
                newBranch.restore();
                branchFound = newBranch.tryNext();
            } else {
                this.abox.getClash().depends.remove(lastBranch);
            }
            if (branchFound || !ABox.DEBUG) continue;
            System.out.println("Failed at branch " + lastBranch);
        }
        return branchFound;
    }

    ABox complete() {
        while (!this.abox.isComplete()) {
            while (this.abox.changed && !this.abox.isClosed()) {
                this.abox.changed = false;
                if (ABox.DEBUG) {
                    System.out.println("Branch: " + this.abox.getBranch() + ", Depth: " + this.abox.treeDepth + ", Size: " + this.abox.getNodes().size());
                    this.printBlocked();
                    this.abox.printTree();
                    this.abox.validate();
                }
                IndividualIterator i = this.abox.getIndIterator();
                if (PelletOptions.USE_OPTIMIZEDINDIVIDUALS && !((EconnectedKB)this.abox.getKB()).getCheckAll()) {
                    String ont2 = this.abox.getKB().getOntology();
                    FilteredIterator it = new FilteredIterator(ont2);
                    i = it;
                }
                this.timers.startTimer("applyUnfoldingRule");
                this.applyUnfoldingRule(i);
                this.timers.stopTimer("applyUnfoldingRule");
                if (this.abox.isClosed()) break;
                this.timers.startTimer("applyDisjunctionRule");
                this.applyDisjunctionRule(i);
                this.timers.stopTimer("applyDisjunctionRule");
                if (this.abox.isClosed()) break;
                this.timers.startTimer("applySomeValuesRule");
                this.applySomeValuesRule(i);
                this.timers.stopTimer("applySomeValuesRule");
                if (this.abox.isClosed()) break;
                this.timers.startTimer("applyMinRule");
                this.applyMinRule(i);
                this.timers.stopTimer("applyMinRule");
                this.applyNominalRule(i);
                if (this.abox.isClosed()) break;
                this.timers.startTimer("applyMaxRule");
                this.applyMaxRule(i);
                this.timers.stopTimer("applyMaxRule");
                if (!this.abox.isClosed() && !this.hasClash()) continue;
                break;
            }
            if (this.abox.isClosed()) {
                if (ABox.DEBUG) {
                    System.out.println("Clash at Branch (" + this.abox.getBranch() + ") " + this.abox.getClash());
                }
                if (this.backtrack()) {
                    this.abox.setClash(null);
                    continue;
                }
                this.abox.setComplete(true);
                continue;
            }
            this.abox.setComplete(true);
        }
        return this.abox;
    }

    private boolean hasClash() {
        this.timers.startTimer("hasClash");
        this.abox.setClash(null);
        if (ABox.DEBUG) {
            this.abox.printTree();
        }
        boolean hasClash = false;
        IndividualIterator i = this.abox.getIndIterator();
        while (!hasClash && i.hasNext()) {
            Individual node = (Individual)i.next();
            if (node.isChanged()) {
                hasClash = this.hasClash(node);
            }
            if (!ABox.DEBUG || !hasClash) continue;
            System.out.println("found a clash in " + node.getName());
        }
        this.timers.stopTimer("hasClash");
        return hasClash;
    }

    boolean hasClash(Individual node) {
        ATermAppl x = node.getName();
        if (node.isChanged(Node.MAX)) {
            this.timers.startTimer("clashMax");
            Iterator i = node.getTypes(Node.MAX).iterator();
            while (i.hasNext()) {
                ATermAppl mc = (ATermAppl)i.next();
                ATermAppl a = (ATermAppl)mc.getArgument(0);
                ATerm r = a.getArgument(0);
                int n = ((ATermInt)a.getArgument(1)).getInt() - 1;
                DependencySet ds = node.getDepends(mc);
                Role role = this.abox.getRole(r);
                DependencySet dsEdges = node.hasDistinctRNeighborsForMax(role, n + 1);
                if (dsEdges == null) continue;
                this.abox.setClash(Clash.maxCardinality(node, ds.union(dsEdges)));
                if (ABox.DEBUG) {
                    System.out.println("3) Clash dependency all " + x + " has " + mc + " and more neighbors -> " + this.abox.getClash());
                }
                this.timers.stopTimer("clashMax");
                return true;
            }
            this.timers.stopTimer("clashMax");
        }
        return false;
    }

    void addBranch(Branch newBranch) {
        this.abox.getBranches().add(newBranch);
        if (newBranch.branch != this.abox.getBranches().size()) {
            throw new RuntimeException("Internal error: Invalid branch created!");
        }
    }

    class FilteredIterator
    extends IndividualIterator {
        private String ontology;
        boolean needToApplyRules;

        FilteredIterator(String ont) {
            super(PECSHIONStrategy.this.abox, false);
            this.ontology = ont;
            this.needToApplyRules = false;
            this.findNext();
        }

        protected void findNext() {
            Individual ind;
            String ont1;
            while (this.index < this.stop && (!(this.nodes.get(this.nodeList.get(this.index)) instanceof Individual) || !(ont1 = (ind = (Individual)this.nodes.get(this.nodeList.get(this.index))).getOntology()).equals(this.ontology) && !((EconnectedKB)PECSHIONStrategy.this.abox.getKB()).getEconnExpressivity().hasNominal(ont1) && ind.isRoot())) {
                ++this.index;
            }
        }
    }
}

