/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;

public class RBox {
    private Map roles = new HashMap();
    private Set functionalRoles = new HashSet();
    boolean consistent = true;

    public Role getRole(ATerm r) {
        return (Role)this.roles.get(r);
    }

    public Role getDefinedRole(ATerm r) {
        Role role = (Role)this.roles.get(r);
        if (role == null) {
            throw new RuntimeException(r + "is not defined as a property");
        }
        return role;
    }

    public boolean isConsistent() {
        return this.consistent;
    }

    public Role addRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 0);
            this.roles.put(r, role);
        }
        return role;
    }

    public Role addObjectRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 1);
            this.roles.put(r, role);
            ATermAppl invR = ATermUtils.makeInv(r);
            Role invRole = new Role(invR, 1);
            this.roles.put(invR, invRole);
            role.setInverse(invRole);
            invRole.setInverse(role);
        } else if (role.getType() == 0) {
            role.setType(1);
            ATermAppl invR = ATermUtils.makeInv(r);
            Role invRole = new Role(invR, 1);
            this.roles.put(invR, invRole);
            role.setInverse(invRole);
            invRole.setInverse(role);
        } else if (role.getType() != 1) {
            this.consistent = false;
        }
        return role;
    }

    public void addDatatypeRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 2);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(2);
        } else if (role.getType() != 2) {
            System.err.println(r + " is defined both as a DatatypeProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
    }

    public Role addLinkRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 5);
            this.roles.put(r, role);
        } else if (role.getType() == 0) {
            role.setType(5);
        } else if (role.getType() != 5) {
            System.err.println(r + " is defined both as a LinkProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
        return role;
    }

    public Role addAnnotationRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 3);
            this.roles.put(r, role);
        } else if (role.getType() != 0 && role.getType() != 3) {
            System.err.println(r + "is defined both as an AnnotationProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
        return role;
    }

    public Role addOntologyRole(ATermAppl r) {
        Role role = this.getRole(r);
        if (role == null) {
            role = new Role(r, 4);
            this.roles.put(r, role);
        } else if (role.getType() != 0 && role.getType() != 4) {
            System.err.println(r + "is defined both as an OntologyProperty and a " + role.getTypeName() + "Property");
            this.consistent = false;
        }
        return role;
    }

    public void addSubRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            this.consistent = false;
        } else {
            roleR.addSubRole(roleS);
            roleS.addSuperRole(roleR);
        }
    }

    public void addSameRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            this.consistent = false;
        } else {
            roleR.addSubRole(roleS);
            roleR.addSuperRole(roleS);
            roleS.addSubRole(roleR);
            roleS.addSuperRole(roleR);
        }
    }

    public void addInverseRole(ATerm s, ATerm r) {
        Role roleS = this.getRole(s);
        Role roleR = this.getRole(r);
        if (roleS == null || roleR == null) {
            this.consistent = false;
        } else {
            ATermAppl prevInvR = roleR.getInverse().getName();
            ATermAppl prevInvS = roleS.getInverse().getName();
            if (prevInvR.equals(s) && prevInvS.equals(r)) {
                return;
            }
            if (prevInvR.getArity() == 0) {
                if (prevInvS.getArity() == 0) {
                    this.addSameRole(prevInvR, s);
                    this.addSameRole(prevInvS, r);
                } else {
                    this.addSameRole(prevInvR, s);
                    if (this.getRole(prevInvS).isFunctional()) {
                        roleR.setFunctional(true);
                    }
                    this.roles.remove(prevInvS);
                }
            } else if (prevInvS.getArity() == 0) {
                this.addSameRole(prevInvS, r);
                if (this.getRole(prevInvR).isFunctional()) {
                    roleS.setFunctional(true);
                }
                this.roles.remove(prevInvR);
            } else {
                roleR.setInverse(roleS);
                roleS.setInverse(roleR);
                if (this.getRole(prevInvR).isFunctional()) {
                    roleS.setFunctional(true);
                }
                if (this.getRole(prevInvS).isFunctional()) {
                    roleR.setFunctional(true);
                }
                this.roles.remove(prevInvR);
                this.roles.remove(prevInvS);
            }
        }
    }

    public boolean isRole(ATerm r) {
        if (r instanceof ATermAppl) {
            ATermAppl a = (ATermAppl)r;
            if (a.getArity() == 0) {
                return this.roles.containsKey(r);
            }
            if (a.getArity() == 1) {
                return a.getAFun().equals(ATermUtils.INVFUN) && this.isRole(a.getArgument(0));
            }
        }
        return false;
    }

    public void computeRoleHierarchy() {
        Role role;
        Iterator i = this.roles.values().iterator();
        while (i.hasNext()) {
            role = (Role)i.next();
            if (role.getType() != 1 && role.getType() != 2) continue;
            HashSet subRoles = new HashSet();
            this.computeSubRoles(role, subRoles);
            role.setSubRoles(subRoles);
        }
        i = this.roles.values().iterator();
        while (i.hasNext()) {
            ATermAppl range;
            ATermAppl domain;
            role = (Role)i.next();
            Role invR = role.getInverse();
            if (invR != null) {
                domain = invR.getDomain();
                if (domain != null) {
                    role.addRange(domain);
                }
                if ((range = invR.getRange()) != null) {
                    role.addDomain(range);
                }
            }
            domain = role.getDomain();
            range = role.getRange();
            Iterator subs = role.getSubRoles().iterator();
            while (subs.hasNext()) {
                Role s = (Role)subs.next();
                s.addSuperRole(role);
                if (domain != null) {
                    s.addDomain(domain);
                }
                if (range == null) continue;
                s.addRange(range);
            }
        }
        i = this.roles.values().iterator();
        while (i.hasNext()) {
            Role r = (Role)i.next();
            boolean isTransitive = this.isTransitiveRole(r);
            r.setTransitive(isTransitive);
            Iterator supers = r.getSuperRoles().iterator();
            while (supers.hasNext()) {
                Role s = (Role)supers.next();
                if (!s.isFunctional()) continue;
                r.setFunctional(true);
                r.addFunctionalSuper(s);
            }
            if (!r.isFunctional() || !r.getFunctionalSupers()[0].equals(r)) continue;
            this.functionalRoles.add(r);
        }
    }

    private Set computeImmediateSubRoles(Role r) {
        HashSet<Role> subs = null;
        Role invR = r.getInverse();
        if (invR == null) {
            subs = r.getSubRoles();
        } else {
            subs = new HashSet<Role>(r.getSubRoles());
            Iterator i = invR.getSubRoles().iterator();
            while (i.hasNext()) {
                Role invSubR = (Role)i.next();
                Role subR = invSubR.getInverse();
                if (subR == null) {
                    System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
                    continue;
                }
                subs.add(subR);
            }
        }
        return subs;
    }

    private void computeSubRoles(Role r, Set set) {
        if (set.contains(r)) {
            return;
        }
        set.add(r);
        Iterator i = this.computeImmediateSubRoles(r).iterator();
        while (i.hasNext()) {
            Role s = (Role)i.next();
            this.computeSubRoles(s, set);
        }
    }

    private boolean isTransitiveRole(Role r) {
        if (!r.isObjectRole()) {
            return false;
        }
        if (r.getInverse() == null) {
            return false;
        }
        return this.isTransitiveRole(r, new HashSet());
    }

    private boolean isTransitiveRole(Role r, HashSet visited) {
        if (visited.contains(r)) {
            return false;
        }
        visited.add(r);
        return r.isTransitive() || this.hasTransitiveSubRole(r, visited) || this.hasTransitiveInverseRole(r, visited);
    }

    private boolean hasTransitiveSubRole(Role r, HashSet visited) {
        Iterator sr = r.getSubRoles().iterator();
        while (sr.hasNext()) {
            Role s = (Role)sr.next();
            if (!this.isTransitiveRole(s, visited)) continue;
            return true;
        }
        return false;
    }

    private boolean hasTransitiveInverseRole(Role r, HashSet visited) {
        Role inv = r.getInverse();
        return ATermUtils.isPrimitive(inv.getName()) && this.isTransitiveRole(inv, visited);
    }

    public String toString() {
        return "[RBox " + this.roles.values() + "]";
    }

    public Set inverseRoleList(Set roles) {
        HashSet<Role> set = new HashSet<Role>();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            Role r = (Role)i.next();
            Role invR = r.getInverse();
            if (invR == null) {
                System.err.println("Property " + r + " was supposed to be an ObjectProperty but it is not!");
                continue;
            }
            set.add(invR);
        }
        return set;
    }

    public Set getRoleNames() {
        return this.roles.keySet();
    }

    public Set getFunctionalRoles() {
        return this.functionalRoles;
    }

    public Collection getRoles() {
        return this.roles.values();
    }
}

