/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.output.OutputFormatter;
import org.mindswap.pellet.output.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;

public class Taxonomy {
    public static boolean DEBUG = false;
    public static boolean DETAILED_DEBUG = false;
    protected Map nodes;
    protected TaxonomyNode TOP;
    protected TaxonomyNode BOTTOM;
    protected TaxonomyPrinter printer = new TaxonomyPrinter();

    public Taxonomy() {
        this.nodes = new HashMap();
        this.TOP = this.addNode(ATermUtils.TOP);
        this.BOTTOM = this.addNode(ATermUtils.BOTTOM);
        this.TOP.addSub(this.BOTTOM);
    }

    public TaxonomyNode getBottom() {
        return this.BOTTOM;
    }

    public TaxonomyNode getTop() {
        return this.TOP;
    }

    public Set getClasses() {
        return this.nodes.keySet();
    }

    public boolean contains(ATermAppl c) {
        return this.nodes.containsKey(c);
    }

    public TaxonomyNode addNode(ATermAppl c) {
        TaxonomyNode node = new TaxonomyNode(c);
        this.nodes.put(c, node);
        return node;
    }

    public void addEquivalentNode(ATermAppl c, TaxonomyNode node) {
        node.addEquivalent(c);
        this.nodes.put(c, node);
    }

    public TaxonomyNode getNode(ATermAppl c) {
        return (TaxonomyNode)this.nodes.get(c);
    }

    public Set getInstances(ATermAppl c) {
        return this.getInstances(c, false);
    }

    public Set getInstances(ATermAppl c, boolean direct) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        HashSet result = new HashSet(node.getInstances());
        if (!direct) {
            Iterator subs = this.getSubClasses(c).iterator();
            while (subs.hasNext()) {
                Set sub = (Set)subs.next();
                ATermAppl a = (ATermAppl)sub.iterator().next();
                result.addAll(this.getInstances(a));
            }
        }
        return result;
    }

    public boolean isEquivalentClass(ATermAppl x, ATermAppl y) {
        TaxonomyNode node1 = (TaxonomyNode)this.nodes.get(x);
        TaxonomyNode node2 = (TaxonomyNode)this.nodes.get(y);
        return node1.equals(node2);
    }

    public boolean isSubClassOf(ATermAppl x, ATermAppl y) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(x);
        ArrayList visit = new ArrayList();
        visit.add(this.nodes.get(x));
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            if (node.contains(y)) {
                return true;
            }
            visit.addAll(node.getSupers());
        }
        return false;
    }

    public Set getSubClasses(ATermAppl c) {
        return this.getSubClasses(c, false);
    }

    public Set getSubClasses(ATermAppl c, boolean direct) {
        return this.getSubSuperClasses(c, direct, true);
    }

    public Set getSuperClasses(ATermAppl c) {
        return this.getSuperClasses(c, false);
    }

    public Set getSuperClasses(ATermAppl c, boolean direct) {
        return this.getSubSuperClasses(c, direct, false);
    }

    public Set getSubSuperClasses(ATermAppl c, boolean direct, boolean getSubs) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        HashSet<Set> result = new HashSet<Set>();
        ArrayList visit = new ArrayList();
        visit.addAll(getSubs ? node.getSubs() : node.getSupers());
        for (int i = 0; i < visit.size(); ++i) {
            node = (TaxonomyNode)visit.get(i);
            Set add = node.getEquivalents();
            if (!add.isEmpty()) {
                result.add(add);
            }
            if (direct) continue;
            visit.addAll(getSubs ? node.getSubs() : node.getSupers());
        }
        return result;
    }

    public Set getEquivalentClasses(ATermAppl c) {
        TaxonomyNode node = (TaxonomyNode)this.nodes.get(c);
        if (node == null) {
            throw new RuntimeException(c + " is an unknown class!");
        }
        HashSet result = new HashSet(node.getEquivalents());
        result.remove(c);
        return result;
    }

    public Set getDirectTypes(ATermAppl ind) {
        HashSet<Set> result = new HashSet<Set>();
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
        }
        return result;
    }

    public Set getTypes(ATermAppl ind) {
        HashSet<Set> result = new HashSet<Set>();
        Iterator i = this.nodes.values().iterator();
        while (i.hasNext()) {
            TaxonomyNode node = (TaxonomyNode)i.next();
            if (!node.getInstances().contains(ind)) continue;
            result.add(node.getEquivalents());
            Set supers = this.getSuperClasses(node.getConcept());
            result.addAll(supers);
        }
        return result;
    }

    public Set getTypes(ATermAppl ind, boolean direct) {
        if (direct) {
            return this.getDirectTypes(ind);
        }
        return this.getTypes(ind);
    }

    public void print() {
        this.printer.print(this);
    }

    public void print(OutputFormatter out) {
        this.printer.print(this, out);
    }
}

