/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.IndividualIterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.Taxonomy;
import org.mindswap.pellet.TaxonomyNode;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.URIUtils;

public class TaxonomyBuilder {
    private byte PROPOGATE_UP = 1;
    private byte NO_PROPOGATE = 0;
    private byte PROPOGATE_DOWN = (byte)-1;
    protected Set classes;
    private Map toldSubsumers;
    private Map toldDisjoints;
    protected boolean finished = false;
    protected Taxonomy taxonomy;
    protected KnowledgeBase kb;
    private int count;
    private ClassifyListener listener = null;

    public TaxonomyBuilder(KnowledgeBase kb) {
        this.kb = kb;
        this.classes = new HashSet();
        this.classes.addAll(kb.getClasses());
        this.taxonomy = new Taxonomy();
        this.toldSubsumers = new HashMap();
        this.toldDisjoints = new HashMap();
    }

    public void setListener(ClassifyListener listener) {
        this.listener = listener;
    }

    protected void notifyListener(String notification) {
        if (this.listener == null) {
            return;
        }
        if (notification.equals("satisfiabilityStarted")) {
            this.listener.setMaximum(2 * this.classes.size());
            this.listener.satisfiabilityStarted();
        } else if (notification.equals("classificationStarted")) {
            this.listener.classificationStarted();
        } else {
            this.listener.startClass(notification);
        }
    }

    public boolean isCanceled() {
        return this.listener != null && this.listener.isCanceled();
    }

    public Taxonomy classify() {
        if (Taxonomy.DEBUG) {
            this.kb.timers.createTimer("classifySub");
            System.out.println("Classes: " + (this.classes.size() + 2) + " Individuals: " + this.kb.getIndividuals().size());
        }
        this.init();
        this.notifyListener("satisfiabilityStarted");
        if (Taxonomy.DEBUG) {
            System.out.println("Starting classification...");
        }
        this.count = 0;
        this.notifyListener("classificationStarted");
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            if (this.isCanceled()) {
                return null;
            }
            ATermAppl c = (ATermAppl)i.next();
            this.notifyListener(c.getName());
            this.classify(c);
        }
        this.finished = true;
        if (Taxonomy.DEBUG) {
            System.out.println("Sub Count: " + this.kb.timers.getTimer("classifySub").getCount());
            System.out.println("Sat Count: " + (this.kb.abox.satisfiabilityCount - (long)(2 * this.kb.tbox.classes.size())));
        }
        return this.taxonomy;
    }

    private void init() {
        Iterator i = this.classes.iterator();
        while (i.hasNext()) {
            ATermAppl c = (ATermAppl)i.next();
            TBox[] tbox = new TBox[]{this.kb.getTBox().Tu, this.kb.getTBox().Tg};
            for (int t = 0; t < tbox.length; ++t) {
                TermDefinition td = tbox[t].getTD(c);
                if (td == null) continue;
                if (td.getSames() != null) {
                    Iterator j = td.getSames().iterator();
                    while (j.hasNext()) {
                        ATermAppl d = (ATermAppl)j.next();
                        d = (ATermAppl)d.getArgument(1);
                        this.preclassify(c, d, true);
                    }
                }
                if (td.getSub() == null) continue;
                ATermAppl term = (ATermAppl)td.getSub().getArgument(1);
                if (term.getAFun().equals(ATermUtils.ANDFUN)) {
                    ATermList subs = (ATermList)term.getArgument(0);
                    while (!subs.isEmpty()) {
                        ATermAppl d = (ATermAppl)subs.getFirst();
                        this.preclassify(c, d, false);
                        subs = subs.getNext();
                    }
                    continue;
                }
                this.preclassify(c, term, false);
            }
        }
    }

    private void preclassify(ATermAppl c, ATermAppl d, boolean isSame) {
        ATermAppl negation;
        if (ATermUtils.isPrimitive(d)) {
            if (d.getName().startsWith("bNode")) {
                return;
            }
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Preclassify (1) " + this.getName(c) + " " + this.getName(d));
            }
            this.addToldSubsumer(c, d);
            if (isSame) {
                if (Taxonomy.DETAILED_DEBUG) {
                    System.out.println("Preclassify (2) " + this.getName(d) + " " + this.getName(c));
                }
                this.addToldSubsumer(d, c);
            }
        } else if (d.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList conj = (ATermList)d.getArgument(0);
            while (!conj.isEmpty()) {
                this.preclassify(c, (ATermAppl)conj.getFirst(), false);
                conj = conj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.ORFUN)) {
            if (!isSame) {
                return;
            }
            ATermList disj = (ATermList)d.getArgument(0);
            ATermAppl e = (ATermAppl)disj.getFirst();
            while (!disj.isEmpty()) {
                if (ATermUtils.isPrimitive(e)) {
                    if (Taxonomy.DETAILED_DEBUG) {
                        System.out.println("Preclassify (3) " + this.getName(c) + " " + this.getName(e));
                    }
                    this.addToldSubsumer(e, c);
                }
                disj = disj.getNext();
            }
        } else if (d.getAFun().equals(ATermUtils.NOTFUN) && ATermUtils.isPrimitive(negation = (ATermAppl)d.getArgument(0))) {
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Preclassify (4) " + this.getName(c) + " " + this.getName(negation));
            }
            this.addToldDisjoint(c, negation);
            this.addToldDisjoint(negation, c);
        }
    }

    private void addToldSubsumer(ATermAppl c, ATermAppl d) {
        HashSet<ATermAppl> subsumers = (HashSet<ATermAppl>)this.toldSubsumers.get(c);
        if (subsumers == null) {
            subsumers = new HashSet<ATermAppl>();
            this.toldSubsumers.put(c, subsumers);
        }
        subsumers.add(d);
    }

    private void addToldDisjoint(ATermAppl c, ATermAppl d) {
        HashSet<ATermAppl> disjoints = (HashSet<ATermAppl>)this.toldDisjoints.get(c);
        if (disjoints == null) {
            disjoints = new HashSet<ATermAppl>();
            this.toldDisjoints.put(c, disjoints);
        }
        disjoints.add(d);
    }

    private void markToldSubsumers(ATermAppl c, Map marked, Set concepts) {
        Set subsumers;
        if (concepts.contains(c)) {
            return;
        }
        concepts.add(c);
        TaxonomyNode node = this.taxonomy.getNode(c);
        if (node != null) {
            this.mark(node, marked, Boolean.TRUE, this.PROPOGATE_UP);
        }
        if ((subsumers = (Set)this.toldSubsumers.get(c)) != null) {
            Iterator i = subsumers.iterator();
            while (i.hasNext()) {
                ATermAppl sup = (ATermAppl)i.next();
                this.markToldSubsumers(sup, marked, concepts);
            }
        }
    }

    private void markToldDisjoints(ATermAppl c, Map marked) {
        Set disjoints = (Set)this.toldDisjoints.get(c);
        if (disjoints != null) {
            Iterator i = disjoints.iterator();
            while (i.hasNext()) {
                ATermAppl sup = (ATermAppl)i.next();
                TaxonomyNode node = this.taxonomy.getNode(sup);
                if (node == null) continue;
                this.mark(node, marked, Boolean.FALSE, this.PROPOGATE_DOWN);
            }
        }
    }

    private void checkSatisfiability(ATermAppl c) {
        Timer t = null;
        if (Taxonomy.DEBUG) {
            System.out.print("Satisfiable ");
            t = this.kb.timers.startTimer("classifySat");
        }
        boolean isSatisfiable = this.kb.isSatisfiable(c);
        if (Taxonomy.DEBUG) {
            t.stop();
            System.out.print((isSatisfiable ? "true" : "*****FALSE*****") + " (" + t.getLast() + "ms)");
        }
        if (!isSatisfiable) {
            this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
        }
        if (PelletOptions.USE_CACHING) {
            if (Taxonomy.DEBUG) {
                System.out.print("...negation ");
                t.start();
            }
            if (!(isSatisfiable = this.kb.isSatisfiable(ATermUtils.makeNot(c)))) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getTop());
            }
            if (Taxonomy.DEBUG) {
                t.stop();
                System.out.println(isSatisfiable + " (" + t.getLast() + "ms)");
            }
        } else if (Taxonomy.DEBUG) {
            System.out.println();
        }
    }

    public void classify(ATermAppl c) {
        this.classify(c, new HashSet());
    }

    private void classify(ATermAppl c, Set classified) {
        TaxonomyNode sup;
        if (classified.contains(c)) {
            return;
        }
        classified.add(c);
        if (this.taxonomy.contains(c)) {
            return;
        }
        Set subsumers = (Set)this.toldSubsumers.get(c);
        if (subsumers != null) {
            if (Taxonomy.DETAILED_DEBUG) {
                System.out.println("Classify " + this.getName(c) + " " + subsumers);
            }
            Iterator i = subsumers.iterator();
            while (i.hasNext()) {
                ATermAppl sup2 = (ATermAppl)i.next();
                this.classify(sup2, classified);
            }
        }
        if (Taxonomy.DEBUG) {
            System.out.print("Classify (" + ++this.count + ") " + this.getName(c) + "...");
        }
        this.checkSatisfiability(c);
        if (this.taxonomy.contains(c)) {
            return;
        }
        HashMap marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.markToldSubsumers(c, marked, new HashSet());
        this.markToldDisjoints(c, marked);
        Collection supers = this.search(true, c, this.taxonomy.getTop(), new HashSet(), new ArrayList(), marked);
        marked = new HashMap();
        this.mark(this.taxonomy.getTop(), marked, Boolean.FALSE, this.NO_PROPOGATE);
        this.mark(this.taxonomy.getBottom(), marked, Boolean.TRUE, this.NO_PROPOGATE);
        if (supers.size() == 1 && this.subsumed(sup = (TaxonomyNode)supers.iterator().next(), c, marked)) {
            if (Taxonomy.DEBUG) {
                System.out.println(this.getName(c) + " = " + this.getName(sup.getConcept()));
            }
            this.taxonomy.addEquivalentNode(c, sup);
            return;
        }
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.println("Bottom search...");
        }
        Collection subs = this.search(false, c, this.taxonomy.getBottom(), new HashSet(), new ArrayList(), marked);
        TaxonomyNode node = this.taxonomy.addNode(c);
        node.addSupers(new ArrayList(supers));
        node.addSubs(new ArrayList(subs));
        node.removeMultiplePaths();
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.println("Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
        }
    }

    private Collection search(boolean topSearch, ATermAppl c, TaxonomyNode x, Set visited, List result, Map marked) {
        ArrayList<TaxonomyNode> posSucc = new ArrayList<TaxonomyNode>();
        visited.add(x);
        List list = topSearch ? x.getSubs() : x.getSupers();
        for (int i = 0; i < list.size(); ++i) {
            TaxonomyNode next = (TaxonomyNode)list.get(i);
            if (topSearch) {
                if (!this.subsumes(next, c, marked)) continue;
                posSucc.add(next);
                continue;
            }
            if (!this.subsumed(next, c, marked)) continue;
            posSucc.add(next);
        }
        if (posSucc.isEmpty()) {
            result.add(x);
        } else {
            Iterator i = posSucc.iterator();
            while (i.hasNext()) {
                TaxonomyNode y = (TaxonomyNode)i.next();
                if (visited.contains(y)) continue;
                this.search(topSearch, c, y, visited, result, marked);
            }
        }
        return result;
    }

    private boolean subsumes(TaxonomyNode node, ATermAppl c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumes = this.subsumes(node.getConcept(), c);
        Boolean value = subsumes ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumes ? this.NO_PROPOGATE : this.PROPOGATE_DOWN;
        this.mark(node, marked, value, propogate);
        return subsumes;
    }

    private boolean subsumed(TaxonomyNode node, ATermAppl c, Map marked) {
        Boolean cached = (Boolean)marked.get(node);
        if (cached != null) {
            return cached;
        }
        boolean subsumed = this.subsumes(c, node.getConcept());
        Boolean value = subsumed ? Boolean.TRUE : Boolean.FALSE;
        byte propogate = subsumed ? this.NO_PROPOGATE : this.PROPOGATE_UP;
        this.mark(node, marked, value, propogate);
        return subsumed;
    }

    private void mark(TaxonomyNode node, Map marked, Boolean value, byte propogate) {
        Boolean exists = (Boolean)marked.get(node);
        if (exists != null) {
            if (exists != value) {
                throw new RuntimeException("Inconsistent classification result " + node.getConcept() + " " + exists + " " + value);
            }
            return;
        }
        marked.put(node, value);
        if (propogate != this.NO_PROPOGATE) {
            List others = propogate == this.PROPOGATE_UP ? node.getSupers() : node.getSubs();
            Iterator i = others.iterator();
            while (i.hasNext()) {
                TaxonomyNode next = (TaxonomyNode)i.next();
                this.mark(next, marked, value, propogate);
            }
        }
    }

    private boolean subsumes(ATermAppl sup, ATermAppl sub) {
        long time = System.currentTimeMillis();
        long count = this.kb.getABox().satisfiabilityCount;
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.print("Subsumption testing for [" + this.getName(sub) + "," + this.getName(sup) + "]...");
        }
        this.kb.timers.startTimer("classifySub");
        boolean result = this.kb.getABox().isSubClassOf(sub, sup);
        this.kb.timers.stopTimer("classifySub");
        if (Taxonomy.DETAILED_DEBUG) {
            String sign = this.kb.getABox().satisfiabilityCount > count ? "+" : "-";
            time = System.currentTimeMillis() - time;
            System.out.println(" done (" + (result ? "+" : "-") + ") (" + sign + time + "ms)");
        }
        return result;
    }

    public Taxonomy realize() {
        IndividualIterator i = this.kb.getABox().getIndIterator();
        int count = 0;
        while (i.hasNext()) {
            if (this.isCanceled()) {
                return null;
            }
            Individual x = (Individual)i.next();
            if (Taxonomy.DEBUG) {
                System.out.println(count + ") Realizing " + this.getName(x.getName()) + " ");
            }
            this.realize(x.getName(), ATermUtils.TOP);
            ++count;
        }
        return this.taxonomy;
    }

    private boolean realize(ATermAppl n, ATermAppl c) {
        boolean realized = false;
        if (c.equals(ATermUtils.BOTTOM)) {
            return false;
        }
        long time = System.currentTimeMillis();
        long count = this.kb.getABox().satisfiabilityCount;
        if (Taxonomy.DETAILED_DEBUG) {
            System.out.print("Type checking for " + this.getName(n) + "] " + this.getName(c) + "...");
        }
        this.kb.timers.startTimer("classifyType");
        boolean isType = this.kb.isType(n, c);
        this.kb.timers.stopTimer("classifyType");
        if (Taxonomy.DETAILED_DEBUG) {
            String sign = this.kb.getABox().satisfiabilityCount > count ? "+" : "-";
            time = System.currentTimeMillis() - time;
            System.out.println(" done (" + (isType ? "+" : "-") + ") (" + sign + time + "ms)");
        }
        if (isType) {
            TaxonomyNode node = this.taxonomy.getNode(c);
            Iterator subs = node.getSubs().iterator();
            while (subs.hasNext()) {
                TaxonomyNode sub = (TaxonomyNode)subs.next();
                ATermAppl d = sub.getConcept();
                realized = this.realize(n, d) || realized;
            }
            if (!realized) {
                this.taxonomy.getNode(c).addInstance(n);
                realized = true;
            }
        }
        return realized;
    }

    public void printStats() {
        int numClasses = this.classes.size();
        System.out.println("Num of Classes: " + numClasses + " Pairs: " + numClasses * numClasses + " Subsumption Count: " + this.kb.getABox().satisfiabilityCount);
    }

    private String getName(ATermAppl c) {
        if (c.equals(ATermUtils.TOP)) {
            return "owl:Thing";
        }
        if (c.equals(ATermUtils.BOTTOM)) {
            return "owl:Nothing";
        }
        return URIUtils.getLocalName(c.getName());
    }

    public static interface ClassifyListener {
        public void satisfiabilityStarted();

        public void classificationStarted();

        public void startClass(String var1);

        public boolean isCanceled();

        public void cancel();

        public void setMaximum(int var1);
    }
}

