/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATermAppl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.SetUtils;

public class TaxonomyNode {
    private ATermAppl concept;
    private Set equivalents;
    private List supers;
    private List subs;
    private Set instances;

    public TaxonomyNode(ATermAppl c) {
        this.concept = c;
        this.equivalents = Collections.singleton(this.concept);
        if (c.equals(ATermUtils.TOP)) {
            this.supers = Collections.EMPTY_LIST;
            this.subs = new ArrayList();
        } else if (c.equals(ATermUtils.BOTTOM)) {
            this.supers = new ArrayList();
            this.subs = Collections.EMPTY_LIST;
        } else {
            this.supers = new ArrayList(2);
            this.subs = new ArrayList();
        }
    }

    public boolean contains(ATermAppl c) {
        return this.equivalents.contains(c);
    }

    public void addEquivalent(ATermAppl c) {
        if (this.equivalents.size() == 1) {
            this.equivalents = new HashSet(this.equivalents);
        }
        this.equivalents.add(c);
    }

    public void addSub(TaxonomyNode other) {
        this.subs.add(other);
        other.supers.add(this);
    }

    public void addSubs(Collection others) {
        this.subs.addAll(others);
        Iterator i = others.iterator();
        while (i.hasNext()) {
            TaxonomyNode other = (TaxonomyNode)i.next();
            other.supers.add(this);
        }
    }

    public void addSupers(Collection others) {
        this.supers.addAll(others);
        Iterator i = others.iterator();
        while (i.hasNext()) {
            TaxonomyNode other = (TaxonomyNode)i.next();
            other.subs.add(this);
        }
    }

    public void removeSub(TaxonomyNode other) {
        this.subs.remove(other);
        other.supers.remove(this);
    }

    public void addInstance(ATermAppl ind) {
        if (this.instances == null) {
            this.instances = new HashSet();
        }
        this.instances.add(ind);
    }

    public ATermAppl getConcept() {
        return this.concept;
    }

    public Set getNamedEquivalents() {
        HashSet result = new HashSet(this.equivalents);
        Iterator j = result.iterator();
        while (j.hasNext()) {
            ATermAppl c = (ATermAppl)j.next();
            if (ATermUtils.isPrimitive(c)) continue;
            j.remove();
        }
        return result;
    }

    public Set getEquivalents() {
        return this.equivalents;
    }

    public Set getInstances() {
        return this.instances == null ? SetUtils.EMPTY_SET : this.instances;
    }

    public List getSubs() {
        return this.subs;
    }

    public List getSupers() {
        return this.supers;
    }

    public void removeMultiplePaths() {
        Iterator i1 = this.supers.iterator();
        while (i1.hasNext()) {
            TaxonomyNode sup = (TaxonomyNode)i1.next();
            Iterator i2 = this.subs.iterator();
            while (i2.hasNext()) {
                TaxonomyNode sub = (TaxonomyNode)i2.next();
                sup.removeSub(sub);
            }
        }
    }

    public String toString() {
        return this.concept + " = " + this.equivalents;
    }
}

