/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.TBox;
import org.mindswap.pellet.TermDefinition;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.Timer;

public class TuBox
extends TBox {
    protected boolean allow_even_loops = false;
    protected Map unfoldedcache = new HashMap();
    protected Set unfoldMisses = new HashSet();
    static int resets = 0;
    static int createtime = 0;
    Map unfoldedMap = null;
    Map normalizedMap = null;

    public TuBox(KnowledgeBase kb) {
        super(kb);
    }

    public void setAllowEvenLoops(boolean value) {
        this.allow_even_loops = value;
    }

    public void normalize() {
        ATermAppl sub;
        Timer timer = this.kb.timers.startTimer("normalize");
        this.normalizedMap = new HashMap();
        Iterator it = this.termhash.entrySet().iterator();
        while (it.hasNext()) {
            ATermAppl norm;
            Map.Entry entry = it.next();
            ATerm c = (ATerm)entry.getKey();
            TermDefinition td = (TermDefinition)entry.getValue();
            ATermList list = ATermUtils.EMPTY_LIST;
            Iterator e = td.getSames().iterator();
            while (e.hasNext()) {
                ATermAppl axiom = (ATermAppl)e.next();
                ATerm same = axiom.getArgument(1);
                list = list.insert(same);
            }
            if (!list.isEmpty()) {
                norm = ATermUtils.normalize(ATermUtils.makeNot(ATermUtils.makeOr(list)));
                this.normalizedMap.put(ATermUtils.makeNot(c), norm);
            }
            if (td.getSub() != null) {
                list = list.insert(td.getSub().getArgument(1));
            }
            if (list.isEmpty()) continue;
            norm = ATermUtils.normalize(ATermUtils.makeAnd(list));
            this.normalizedMap.put(c, norm);
        }
        if (PelletOptions.USE_ROLE_ABSORPTION && (sub = (ATermAppl)this.normalizedMap.get(ATermUtils.TOP)) != null && sub.getAFun().equals(ATermUtils.ANDFUN)) {
            ATermList l = (ATermList)sub.getArgument(0);
            ATermList newList = ATermUtils.EMPTY_LIST;
            while (!l.isEmpty()) {
                ATermAppl term = (ATermAppl)l.getFirst();
                if (term.getAFun().equals(ATermUtils.ALLFUN)) {
                    ATerm r = term.getArgument(0);
                    ATermAppl range = (ATermAppl)term.getArgument(1);
                    this.kb.addRange(r, range);
                } else {
                    newList = newList.insert(term);
                }
                l = l.getNext();
            }
            if (newList.isEmpty()) {
                this.normalizedMap.remove(ATermUtils.TOP);
            } else {
                this.normalizedMap.put(ATermUtils.TOP, ATermUtils.makeAnd(newList));
            }
        }
        timer.stop();
    }

    public boolean addIfUnfoldable(ATermAppl term) {
        boolean result;
        block5: {
            ATermAppl name = (ATermAppl)term.getArgument(0);
            TermDefinition tdcopy = null;
            TermDefinition td = null;
            result = false;
            if (this.contains(name)) {
                td = this.getTD(name);
                tdcopy = new TermDefinition(td);
            } else {
                tdcopy = new TermDefinition();
            }
            tdcopy.addDef(term);
            if (!tdcopy.isGCI() && tdcopy.isUnique()) {
                this.termhash.put(name, tdcopy);
                this.resetCache();
                try {
                    this.unfoldTerm(name);
                    result = true;
                }
                catch (NotUnfoldableException e) {
                    this.resetCache();
                    this.termhash.remove(name);
                    if (td == null) break block5;
                    this.termhash.put(name, td);
                }
            }
        }
        return result;
    }

    public static void printStatistics() {
        System.out.println("\nTu Statistics:");
        System.out.println("Number of resets: " + resets);
        System.out.println("Time in createSplitTBox: " + createtime);
    }

    public boolean isUnfoldable() {
        this.resetCache();
        try {
            this.unfold();
            return true;
        }
        catch (NotUnfoldableException e) {
            this.resetCache();
            return false;
        }
    }

    public void resetCache() {
        this.unfoldedcache = new HashMap();
        this.unfoldMisses = new HashSet();
        ++resets;
    }

    protected void loopConstraintWrap(ATermAppl term, Map seen, int negations) throws NotUnfoldableException {
        try {
            this.loopConstraint(term, seen, negations);
        }
        catch (NotUnfoldableException e) {
            if (this.termhash.containsKey(term) || term.getAFun().equals(ATermUtils.NOTFUN)) {
                this.unfoldMisses.add(term);
                e.addTerm(term);
            }
            throw e;
        }
    }

    protected void loopConstraint(ATermAppl term, Map seen, int negations) throws NotUnfoldableException {
        this.kb.timers.checkTimer("preprocessing");
        if (term.getArity() == 0) {
            if (seen.containsKey(term)) {
                int negationlevel = (Integer)seen.get(term);
                if ((negations - negationlevel) % 2 != 0) {
                    throw new NotUnfoldableException(term, "Term " + term + " contains a loop (negations: " + (negations - negationlevel) + ").");
                }
                if (!this.allow_even_loops) {
                    throw new NotUnfoldableException(term, "Term " + term + " contains a loop (allow_even_loops=false)");
                }
            }
        } else if (!(term.getAFun().equals(ATermUtils.MINFUN) || term.getAFun().equals(ATermUtils.MAXFUN) || term.getAFun().equals(ATermUtils.VALUEFUN))) {
            if (term.getAFun().equals(ATermUtils.NOTFUN)) {
                this.loopConstraint((ATermAppl)term.getArgument(0), seen, negations + 1);
            } else if (term.getAFun().equals(ATermUtils.SOMEFUN) || term.getAFun().equals(ATermUtils.ALLFUN)) {
                this.loopConstraint((ATermAppl)term.getArgument(1), seen, negations);
            } else if (term.getAFun().equals(ATermUtils.ANDFUN) || term.getAFun().equals(ATermUtils.ORFUN)) {
                for (int i = 0; i < term.getArity(); ++i) {
                    ATermList list;
                    ATerm arg = term.getArgument(i);
                    if (arg instanceof ATermAppl) {
                        this.loopConstraintWrap((ATermAppl)arg, seen, negations);
                        continue;
                    }
                    ATermList l = list = (ATermList)arg;
                    while (!l.isEmpty()) {
                        this.loopConstraintWrap((ATermAppl)l.getFirst(), seen, negations);
                        l = l.getNext();
                    }
                }
            } else {
                throw new RuntimeException("ATermAppl of unknown use in unfolding!: " + term);
            }
        }
    }

    protected ATermAppl unfoldTermWrap(ATermAppl term, Map seen, int negations) throws NotUnfoldableException {
        try {
            return this.unfoldTerm(term, seen, negations);
        }
        catch (NotUnfoldableException e) {
            if (this.termhash.containsKey(term) || term.getAFun().equals(ATermUtils.NOTFUN)) {
                this.unfoldMisses.add(term);
                e.addTerm(term);
            }
            throw e;
        }
    }

    public ATermAppl unfoldTerm(ATermAppl term) throws NotUnfoldableException {
        return this.unfoldTermWrap(term, new HashMap(), 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ATermAppl unfoldTerm(ATermAppl term, Map seen, int negations) throws NotUnfoldableException {
        this.kb.timers.checkTimer("preprocessing");
        ATermAppl unfoldedterm = null;
        if (DEBUG) {
            System.out.println("Unfolding " + term);
        }
        if (this.unfoldMisses.contains(term)) {
            throw new NotUnfoldableException(term, "Term already deemed not unfoldable.");
        }
        if (term.getArity() == 0) {
            if (seen.containsKey(term)) {
                this.loopConstraint(term, seen, negations);
                return term;
            }
            if (this.unfoldedcache.containsKey(term)) {
                unfoldedterm = (ATermAppl)this.unfoldedcache.get(term);
                this.loopConstraintWrap(unfoldedterm, seen, negations);
            } else if (this.termhash.containsKey(term)) {
                seen.put(term, new Integer(negations));
                TermDefinition td = (TermDefinition)this.termhash.get(term);
                if (!td.isUnique()) {
                    throw new NotUnfoldableException(term, "Term " + td + " is not unique.");
                }
                if (td.isGCI()) {
                    throw new NotUnfoldableException(term, "Term " + td + " is a GCI.");
                }
                ATermAppl termdef = td.getDef(0);
                if (termdef.getName().equals("same")) {
                    ATermAppl newterm = this.unfoldTermWrap((ATermAppl)termdef.getArgument(1), seen, negations);
                    seen.remove(term);
                    unfoldedterm = newterm;
                } else {
                    ATermAppl intersection;
                    if (!termdef.getName().equals("sub")) throw new RuntimeException(termdef.toString() + " is not a subclass or sameclass definition");
                    ATermAppl newterm = this.unfoldTermWrap((ATermAppl)termdef.getArgument(1), seen, negations);
                    seen.remove(term);
                    ATermAppl aprime = ATermUtils.makeTermAppl("prime-" + term.getName());
                    unfoldedterm = intersection = ATermUtils.makeAnd(aprime, newterm);
                }
            } else {
                unfoldedterm = term;
            }
        } else {
            if (term.getAFun().equals(ATermUtils.MINFUN)) return term;
            if (term.getAFun().equals(ATermUtils.MAXFUN)) return term;
            if (term.getAFun().equals(ATermUtils.VALUEFUN)) {
                return term;
            }
            if (term.getAFun().equals(ATermUtils.NOTFUN)) {
                ATermAppl newterm = this.unfoldTermWrap((ATermAppl)term.getArgument(0), seen, negations + 1);
                return ATermUtils.makeNot(newterm);
            }
            if (term.getAFun().equals(ATermUtils.SOMEFUN) || term.getAFun().equals(ATermUtils.ALLFUN)) {
                ATerm[] arglist = new ATerm[]{term.getArgument(0), this.unfoldTermWrap((ATermAppl)term.getArgument(1), seen, negations)};
                return factory.makeAppl(term.getAFun(), arglist);
            }
            if (!term.getAFun().equals(ATermUtils.ANDFUN)) {
                if (!term.getAFun().equals(ATermUtils.ORFUN)) throw new RuntimeException("ATermAppl of unknown use in unfolding!: " + term);
            }
            ATerm[] arglist = new ATerm[term.getArity()];
            int i = 0;
            while (i < term.getArity()) {
                ATerm arg = term.getArgument(i);
                if (arg instanceof ATermAppl) {
                    arglist[i] = this.unfoldTermWrap((ATermAppl)arg, seen, negations);
                } else {
                    ATermList list;
                    ATermList unfoldedList = ATermUtils.EMPTY_LIST;
                    ATermList l = list = (ATermList)arg;
                    while (!l.isEmpty()) {
                        unfoldedList = unfoldedList.insert(this.unfoldTermWrap((ATermAppl)l.getFirst(), seen, negations));
                        l = l.getNext();
                    }
                    arglist[i] = unfoldedList;
                }
                ++i;
            }
            ATermAppl newterm = factory.makeAppl(term.getAFun(), arglist);
            return newterm;
        }
        this.unfoldedcache.put(term, unfoldedterm);
        return unfoldedterm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfold() throws NotUnfoldableException {
        Timer currentTimer = this.kb.timers.startTimer("unfold");
        this.unfoldedMap = new HashMap();
        this.resetCache();
        try {
            Iterator i = this.termhash.values().iterator();
            while (!i.hasNext()) {
                TermDefinition td = (TermDefinition)i.next();
                ATermAppl c = td.getName();
                ATermAppl notC = ATermUtils.makeNot(c);
                ATermAppl unfolded = ATermUtils.normalize(this.unfoldTerm(c));
                this.unfoldedMap.put(c, unfolded);
                this.unfoldedMap.put(notC, ATermUtils.negate(unfolded));
            }
        }
        finally {
            currentTimer.stop();
            currentTimer = null;
        }
    }

    public class NotUnfoldableException
    extends TBox.TBoxException {
        ATerm offender;
        HashSet terms;
        ATermList termlist;

        public NotUnfoldableException() {
            this.terms = new HashSet();
            this.termlist = ATermUtils.EMPTY_LIST;
        }

        public NotUnfoldableException(String e) {
            super(e);
            this.terms = new HashSet();
            this.termlist = ATermUtils.EMPTY_LIST;
        }

        public NotUnfoldableException(ATerm term) {
            this.terms = new HashSet();
            this.termlist = ATermUtils.EMPTY_LIST;
            this.setOffender(term);
        }

        public NotUnfoldableException(ATerm term, String e) {
            super(e);
            this.terms = new HashSet();
            this.termlist = ATermUtils.EMPTY_LIST;
            this.setOffender(term);
        }

        public void setOffender(ATerm term) {
            this.offender = term;
        }

        public void addTerm(ATerm term) {
            this.terms.add(term);
            this.termlist = this.termlist.insert(term);
        }

        public String toString() {
            StringBuffer retBuffer = new StringBuffer(super.toString());
            retBuffer.append("\nPath to problem:\n");
            ATermList list = this.termlist;
            while (!list.isEmpty()) {
                retBuffer.append("  " + list.getFirst() + "\n");
                list = list.getNext();
            }
            return retBuffer.toString();
        }
    }
}

