/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Collections;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.utils.SetUtils;

public abstract class BaseAtomicDatatype
extends BaseDatatype
implements AtomicDatatype {
    private boolean derived = false;
    protected boolean negated = false;
    protected Set values = null;

    public BaseAtomicDatatype(ATermAppl name) {
        super(name);
    }

    private AtomicDatatype derive(Set values, boolean negated) {
        BaseAtomicDatatype newType = null;
        try {
            newType = (BaseAtomicDatatype)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        newType.name = null;
        newType.values = values;
        newType.negated = negated;
        newType.derived = true;
        return newType;
    }

    public AtomicDatatype not() {
        return this.derive(this.values, !this.negated);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this.getPrimitiveType().equals(dt.getPrimitiveType()) && dt instanceof BaseAtomicDatatype) {
            BaseAtomicDatatype other = (BaseAtomicDatatype)dt;
            if (this.values == null) {
                if (this.negated) {
                    return this;
                }
                return other;
            }
            if (other.values == null) {
                if (other.negated) {
                    return other;
                }
                return this;
            }
            if (this.negated) {
                if (other.negated) {
                    return this.derive(SetUtils.union(this.values, other.values), true);
                }
                return this.derive(SetUtils.difference(other.values, this.values), false);
            }
            if (!other.negated) {
                return this.derive(SetUtils.difference(this.values, other.values), false);
            }
            return this.derive(SetUtils.intersection(this.values, other.values), false);
        }
        return null;
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this.getPrimitiveType().equals(dt.getPrimitiveType())) {
            return this.not().intersection(dt.not()).not();
        }
        return null;
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this.getPrimitiveType().equals(dt.getPrimitiveType())) {
            return this.intersection(dt.not());
        }
        return null;
    }

    public long size() {
        if (this.values == null) {
            return this.negated ? 0L : Long.MAX_VALUE;
        }
        return this.negated ? Long.MAX_VALUE : (long)this.values.size();
    }

    public boolean contains(Object value) {
        return this.values == null || this.values.contains(value) == !this.negated;
    }

    public Datatype enumeration(Set values) {
        return this.derive(values, false);
    }

    public Datatype singleton(Object value) {
        return this.enumeration(Collections.singleton(value));
    }

    public boolean isDerived() {
        return this.derived;
    }
}

