/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDDateTime
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static XSDDateTime instance = new XSDDateTime();
    public SimpleDateFormat formatter;

    private XSDDateTime() {
        this(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#dateTime"), "yyyy-MM-dd'T'HH:mm:ssZ");
    }

    protected XSDDateTime(ATermAppl name, String format) {
        super(name);
        this.formatter = new SimpleDateFormat(format);
        this.formatter.setLenient(true);
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return this.formatter.parse(value.trim());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public boolean contains(Object value) {
        return value instanceof Date && super.contains(value);
    }
}

