/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import aterm.ATermAppl;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.EmptyDatatype;
import org.mindswap.pellet.datatypes.XSDDerivedDecimalType;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.IntervalList;

public class XSDDecimal
extends BaseDatatype
implements AtomicDatatype {
    public static XSDDecimal instance = new XSDDecimal();
    protected IntervalList values;
    public static final long NegInf = Long.MIN_VALUE;
    public static final long PosInf = Long.MAX_VALUE;

    private XSDDecimal() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#decimal"));
        this.setInterval(new IntervalList(-9.223372036854776E18, 9.223372036854776E18));
    }

    protected XSDDecimal(ATermAppl name, IntervalList interval) {
        super(name);
        this.setInterval(interval);
    }

    protected void setInterval(IntervalList values) {
        this.values = values;
    }

    public AtomicDatatype not() {
        return instance.difference(this);
    }

    public AtomicDatatype intersection(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        IntervalList result = new IntervalList();
        if (dt instanceof XSDDecimal) {
            XSDDecimal other = (XSDDecimal)dt;
            IntervalList original = new IntervalList(this.values);
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                IntervalList.Interval interval = (IntervalList.Interval)it.next();
                IntervalList o = new IntervalList(original);
                o.restrictToInterval(interval);
                result.addIntervalList(o);
            }
        }
        return new XSDDerivedDecimalType(result);
    }

    public AtomicDatatype union(AtomicDatatype dt) {
        if (this == dt) {
            return this;
        }
        IntervalList result = new IntervalList();
        if (dt instanceof XSDDecimal) {
            XSDDecimal other = (XSDDecimal)dt;
            result.addIntervalList(this.values);
            result.addIntervalList(other.values);
        }
        return new XSDDerivedDecimalType(result);
    }

    public AtomicDatatype difference(AtomicDatatype dt) {
        if (this == dt) {
            return EmptyDatatype.instance;
        }
        IntervalList result = new IntervalList();
        if (dt instanceof XSDDecimal) {
            XSDDecimal other = (XSDDecimal)dt;
            result.addIntervalList(this.values);
            result.removeIntervalList(other.values);
        }
        return new XSDDerivedDecimalType(result);
    }

    public Datatype enumeration(Set set) {
        IntervalList result = new IntervalList();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Number number = (Number)i.next();
            result.addInterval(number.doubleValue(), number.doubleValue());
        }
        return new XSDDerivedDecimalType(result);
    }

    public Datatype singleton(Object value) {
        IntervalList result = new IntervalList();
        if (value instanceof Number) {
            Number number = (Number)value;
            result.addInterval(number.doubleValue(), number.doubleValue());
        }
        return new XSDDerivedDecimalType(result);
    }

    public long size() {
        return this.values.count();
    }

    public boolean contains(Object value) {
        if (value instanceof Number) {
            return this.values.contains(((Number)value).longValue());
        }
        return false;
    }

    public Object getValue(String value, String datatypeURI) {
        try {
            return Long.valueOf(value.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public boolean isDerived() {
        return false;
    }

    public Datatype deriveByRestriction(String facet, String value) throws UnsupportedOperationException {
        try {
            double min = Double.NaN;
            double max = Double.NaN;
            if (facet.equalsIgnoreCase("minInclusive")) {
                min = Double.parseDouble(value);
                max = 9.223372036854776E18;
            } else if (facet.equalsIgnoreCase("minExclusive")) {
                min = Double.parseDouble(value) + 1.0;
                max = 9.223372036854776E18;
            } else if (facet.equalsIgnoreCase("maxInclusive")) {
                min = -9.223372036854776E18;
                max = Double.parseDouble(value);
            } else if (facet.equalsIgnoreCase("maxExclusive")) {
                min = -9.223372036854776E18;
                max = Double.parseDouble(value) - 1.0;
            } else if (facet.equalsIgnoreCase("totalDigits")) {
                int digits = Integer.parseInt(value);
                min = 0xA ^ digits;
                max = 0xA ^ digits + 1 - 1;
            } else {
                throw new UnsupportedOperationException("xsd:decimal does not support facet " + facet);
            }
            IntervalList interval = new IntervalList(min, max);
            XSDDerivedDecimalType restriction = new XSDDerivedDecimalType(interval);
            return this.intersection(restriction);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + facet);
        }
    }
}

