/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.datatypes;

import org.mindswap.pellet.datatypes.AtomicDatatype;
import org.mindswap.pellet.datatypes.BaseAtomicDatatype;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.datatypes.StringValue;
import org.mindswap.pellet.datatypes.XSDDerivedString;
import org.mindswap.pellet.utils.ATermUtils;

public class XSDString
extends BaseAtomicDatatype
implements AtomicDatatype {
    public static XSDString instance = new XSDString();

    XSDString() {
        super(ATermUtils.makeTermAppl("http://www.w3.org/2001/XMLSchema#string"));
    }

    public AtomicDatatype getPrimitiveType() {
        return instance;
    }

    public Object getValue(String value, String datatypeURI) {
        return new StringValue(value);
    }

    public boolean contains(Object value) {
        return value instanceof StringValue && super.contains(value);
    }

    public Datatype deriveByRestriction(String facet, String value) throws UnsupportedOperationException {
        try {
            if (facet.equalsIgnoreCase("xml:lang")) {
                return new XSDDerivedString(value);
            }
            throw new UnsupportedOperationException("xsd:string does not support facet " + facet);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("Value " + value + " is not valid for the facet " + facet);
        }
    }
}

