/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.utils.QNameProvider;

public class ClassTree {
    QNameProvider qnames;
    OWLReasoner reasoner;
    TreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer(){

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Set set = (Set)node.getUserObject();
            String label = "";
            if (set.size() > 1) {
                label = label + "[";
            }
            Iterator i = set.iterator();
            Resource first = (Resource)i.next();
            label = label + ClassTree.this.qnames.shortForm(first.getURI());
            while (i.hasNext()) {
                Resource c = (Resource)i.next();
                label = label + " = ";
                label = label + ClassTree.this.qnames.shortForm(c.getURI());
            }
            if (set.size() > 1) {
                label = label + "]";
            }
            if (!ClassTree.this.reasoner.isSatisfiable(first)) {
                this.setForeground(Color.RED);
            }
            this.setText(label);
            this.setIcon(this.getDefaultClosedIcon());
            return this;
        }
    };

    public ClassTree(String ontology) throws Exception {
        this.reasoner = new OWLReasoner();
        ModelReader reader = new ModelReader();
        System.out.print("Reading...");
        Model model = reader.read(ontology);
        System.out.println("done");
        System.out.print("Loading...");
        this.reasoner.load(model);
        System.out.println("done");
        System.out.print("Classifying...");
        this.reasoner.classify();
        System.out.println("done");
        this.qnames = new QNameProvider();
    }

    public JTree getJTree() {
        Set set = this.reasoner.getEquivalentClasses(OWL.Thing);
        set.add(OWL.Thing);
        DefaultMutableTreeNode thing = this.createTree(set);
        Set eqs = this.reasoner.getEquivalentClasses(OWL.Nothing);
        Iterator i = eqs.iterator();
        if (i.hasNext()) {
            DefaultMutableTreeNode nothing = this.createNode(OWL.Nothing);
            while (i.hasNext()) {
                Resource sub = (Resource)i.next();
                DefaultMutableTreeNode node = this.createNode(sub);
                nothing.add(node);
            }
            thing.add(nothing);
        }
        JTree classTree = new JTree(new DefaultTreeModel(thing));
        classTree.setCellRenderer(this.treeCellRenderer);
        for (int r = 0; r < classTree.getRowCount(); ++r) {
            classTree.expandRow(r);
        }
        return classTree;
    }

    DefaultMutableTreeNode createTree(Set concepts) {
        if (concepts.contains(OWL.Nothing)) {
            return null;
        }
        DefaultMutableTreeNode root = this.createNode(concepts);
        if (concepts.isEmpty()) {
            return root;
        }
        Resource c = (Resource)concepts.iterator().next();
        Set subs = this.reasoner.getSubClasses(c, true);
        Iterator i = subs.iterator();
        while (i.hasNext()) {
            Set set = (Set)i.next();
            DefaultMutableTreeNode node = this.createTree(set);
            if (node == null) continue;
            root.add(node);
        }
        return root;
    }

    DefaultMutableTreeNode createNode(Resource entity) {
        return new DefaultMutableTreeNode(Collections.singleton(entity));
    }

    DefaultMutableTreeNode createNode(Set set) {
        return new DefaultMutableTreeNode(set);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Missing ontology!");
            System.out.println("");
            System.out.println("usage: java ClassTree <ontology URI>");
            System.exit(0);
        }
        ClassTree tree = new ClassTree(args[0]);
        JFrame frame = new JFrame();
        frame.getContentPane().add(new JScrollPane(tree.getJTree()));
        frame.setSize(800, 600);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

