/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.util.Iterator;
import mx.com.hp.hpl.jena.ontology.DatatypeProperty;
import mx.com.hp.hpl.jena.ontology.EnumeratedClass;
import mx.com.hp.hpl.jena.ontology.Individual;
import mx.com.hp.hpl.jena.ontology.IntersectionClass;
import mx.com.hp.hpl.jena.ontology.ObjectProperty;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntModelSpec;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ReasonerRegistry;
import mx.com.hp.hpl.jena.reasoner.ValidityReport;
import mx.com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import mx.com.hp.hpl.jena.vocabulary.OWL;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.PelletReasoner;

public class CompareReasoners {
    public static String ns = "urn:test:";

    public static void main(String[] args) {
        PelletReasoner pellet = new PelletReasoner();
        DIGReasoner racer = ReasonerRegistry.getDIGReasoner();
        Reasoner[] reasoners = new Reasoner[]{pellet, racer};
        String[] names = new String[]{"Pellet", "Racer"};
        CompareReasoners.testPropertyAssertions(reasoners, names);
        System.out.println();
    }

    public static void testNominalReasoning(Reasoner[] reasoners, String[] names) {
        int i;
        System.out.println("Comparing Nominal Reasoning");
        System.out.println("===========================");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass Color2 = model.createClass(ns + "Color");
        Individual red = model.createIndividual(ns + "red", (Resource)Color2);
        Individual blue = model.createIndividual(ns + "blue", (Resource)Color2);
        Individual yellow = model.createIndividual(ns + "yellow", (Resource)Color2);
        ObjectProperty hasColor = model.createObjectProperty(ns + "hasColor");
        hasColor.addRange((Resource)Color2);
        EnumeratedClass PrimaryColors = model.createEnumeratedClass(ns + "PrimaryColors", model.createList(new RDFNode[]{red, blue, yellow}));
        EnumeratedClass MyFavoriteColors = model.createEnumeratedClass(ns + "MyFavoriteColors", model.createList(new RDFNode[]{red, yellow}));
        OntClass HasFourColors = model.createClass(ns + "HasFourColors");
        HasFourColors.addEquivalentClass((Resource)model.createCardinalityRestriction(null, (Property)hasColor, 4));
        OntClass OnlyHasPrimaryColors = model.createClass(ns + "OnlyHasPrimaryColors");
        OnlyHasPrimaryColors.addEquivalentClass((Resource)model.createAllValuesFromRestriction(null, (Property)hasColor, (Resource)PrimaryColors));
        IntersectionClass HasFourPrimaryColors = model.createIntersectionClass(ns + "HasFourPrimaryColors", model.createList(new RDFNode[]{HasFourColors, OnlyHasPrimaryColors}));
        OntModel[] infModels = new OntModel[reasoners.length];
        for (i = 0; i < reasoners.length; ++i) {
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
            spec.setReasoner(reasoners[i]);
            infModels[i] = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model.getBaseModel());
        }
        System.out.println("Is red a PrimaryColor?");
        for (i = 0; i < reasoners.length; ++i) {
            System.out.println(names[i] + ": " + (infModels[i].contains((Resource)red, RDF.type, (RDFNode)MyFavoriteColors) ? "Yes" : "No") + " ");
        }
        System.out.println();
        System.out.println("Is it possible to have 4 PrimaryColors?");
        for (i = 0; i < reasoners.length; ++i) {
            System.out.println(names[i] + ": " + (infModels[i].contains((Resource)HasFourPrimaryColors, RDFS.subClassOf, (RDFNode)OWL.Nothing) ? "No" : "Yes") + " ");
        }
        System.out.println();
        System.out.println("What are the sub classes of Color?");
        for (i = 0; i < names.length; ++i) {
            CompareReasoners.printIterator((Iterator)infModels[i].getOntClass(Color2.getURI()).listSubClasses(), names[i]);
        }
        System.out.println();
    }

    public static void testDatatypeProperties(Reasoner[] reasoners, String[] names) {
        int i;
        System.out.println("Comparing Datatype Properties");
        System.out.println("=============================");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        OntClass Person = model.createClass(ns + "Person");
        Individual john = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        DatatypeProperty email = model.createDatatypeProperty(ns + "email", false);
        john.addProperty((Property)email, " john.doe@unknown.org ");
        john.addProperty((Property)email, " jdoe@unknown.org ");
        OntModel[] infModels = new OntModel[reasoners.length];
        for (i = 0; i < reasoners.length; ++i) {
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
            spec.setReasoner(reasoners[i]);
            infModels[i] = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model.getBaseModel());
        }
        System.out.println("Is this ontology consistent?");
        for (i = 0; i < reasoners.length; ++i) {
            ValidityReport report = infModels[i].validate();
            System.out.println(names[i] + ": " + report.isValid());
        }
        System.out.println();
    }

    public static void testUniqueNameAssumption(Reasoner[] reasoners, String[] names) {
        int i;
        System.out.println("Comparing Unique Name Assumption");
        System.out.println("================================");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass Country = model.createClass(ns + "Country");
        Individual USA = model.createIndividual(ns + "USA", (Resource)Country);
        Individual UnitedStates = model.createIndividual(ns + "UnitedStates", (Resource)Country);
        ObjectProperty livesIn = model.createObjectProperty(ns + "livesIn");
        livesIn.convertToFunctionalProperty();
        OntClass Person = model.createClass(ns + "Person");
        Individual JohnDoe = model.createIndividual(ns + "JohnDoe", (Resource)Person);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)USA);
        JohnDoe.addProperty((Property)livesIn, (RDFNode)UnitedStates);
        OntModel[] infModels = new OntModel[reasoners.length];
        for (i = 0; i < reasoners.length; ++i) {
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
            spec.setReasoner(reasoners[i]);
            infModels[i] = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model.getBaseModel());
        }
        System.out.println("Is JohnDoe a Person?");
        for (i = 0; i < reasoners.length; ++i) {
            try {
                System.out.print(names[i] + ": ");
                System.out.println((infModels[i].contains((Resource)JohnDoe, RDF.type, (RDFNode)Person) ? "Yes" : "No") + " ");
                continue;
            }
            catch (RuntimeException e) {
                System.out.println(e);
            }
        }
        System.out.println();
        System.out.println("Is USA same as UnitedStates?");
        for (i = 0; i < reasoners.length; ++i) {
            try {
                System.out.print(names[i] + ": ");
                System.out.println((infModels[i].contains((Resource)USA, OWL.sameAs, (RDFNode)UnitedStates) ? "Yes" : "No") + " ");
                continue;
            }
            catch (RuntimeException e) {
                System.out.println(e);
            }
        }
        System.out.println();
    }

    public static void testPropertyAssertions(Reasoner[] reasoners, String[] names) {
        int i;
        System.out.println("Comparing Reasoning about Property Assertions");
        System.out.println("=============================================");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM);
        OntClass Person = model.createClass(ns + "Person");
        ObjectProperty hasChild = model.createObjectProperty(ns + "hasChild");
        ObjectProperty hasSon = model.createObjectProperty(ns + "hasSon");
        hasSon.addSuperProperty((Property)hasChild);
        OntClass PersonWithSingleSon = model.createClass(ns + "PersonWithSingleSon");
        PersonWithSingleSon.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)hasChild, 1));
        PersonWithSingleSon.addSuperClass((Resource)model.createCardinalityRestriction(null, (Property)hasSon, 1));
        Individual Bob = model.createIndividual(ns + "Bob", (Resource)PersonWithSingleSon);
        Individual John = model.createIndividual(ns + "John", (Resource)Person);
        Bob.addProperty((Property)hasChild, (RDFNode)John);
        OntModel[] infModels = new OntModel[reasoners.length];
        for (i = 0; i < reasoners.length; ++i) {
            OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
            spec.setReasoner(reasoners[i]);
            infModels[i] = ModelFactory.createOntologyModel((OntModelSpec)spec, (Model)model.getBaseModel());
        }
        System.out.println("Bob's son:");
        for (i = 0; i < reasoners.length; ++i) {
            try {
                CompareReasoners.printIterator((Iterator)infModels[i].listObjectsOfProperty((Resource)Bob, (Property)hasSon), names[i]);
                continue;
            }
            catch (RuntimeException e) {
                System.out.println(e);
            }
        }
        System.out.println();
    }

    public static void printIterator(Iterator i, String header) {
        System.out.print(header + ": ");
        System.out.print("{");
        while (i.hasNext()) {
            Object node = i.next();
            if (node instanceof Resource) {
                Resource resource = (Resource)node;
                if (resource.isAnon()) {
                    System.out.print(resource);
                } else {
                    System.out.print(resource.getLocalName());
                }
            } else {
                System.out.print(node);
            }
            if (!i.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("} ");
    }
}

