/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.pellet.jena.ModelReader;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.owlapi.Reasoner;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class IndividualsExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Results using Jena interface");
        System.out.println("----------------------------");
        IndividualsExample.runWithJena();
        System.out.println("Results using OWL-API interface");
        System.out.println("-------------------------------");
        IndividualsExample.runWithOWLAPI();
    }

    public static void runWithJena() {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        ModelReader reader = new ModelReader();
        Model model = reader.read(ont);
        OWLReasoner reasoner = new OWLReasoner();
        reasoner.load(model);
        Property Person = model.getProperty("http://xmlns.com/foaf/0.1/Person");
        Property workHomepage = model.getProperty("http://xmlns.com/foaf/0.1/workInfoHomepage");
        Property foafName = model.getProperty("http://xmlns.com/foaf/0.1/name");
        Set individuals = reasoner.getInstances((Resource)Person);
        Iterator i = individuals.iterator();
        while (i.hasNext()) {
            Resource ind = (Resource)i.next();
            String name = ((Literal)reasoner.getPropertyValue(foafName, (RDFNode)ind)).getString();
            Resource type = reasoner.getType(ind, true);
            Resource homepage = (Resource)reasoner.getPropertyValue(workHomepage, (RDFNode)ind);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getLocalName());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage);
            }
            System.out.println();
        }
    }

    public static void runWithOWLAPI() throws OWLException {
        String ont = "http://www.mindswap.org/2004/owl/mindswappers#";
        OWLOntology ontology = OntologyHelper.getOntology((URI)URI.create(ont));
        Reasoner reasoner = new Reasoner();
        reasoner.setOntology(ontology);
        OWLClass Person = reasoner.getClass(URI.create("http://xmlns.com/foaf/0.1/Person"));
        OWLObjectProperty workHomepage = reasoner.getObjectProperty(URI.create("http://xmlns.com/foaf/0.1/workInfoHomepage"));
        OWLDataProperty foafName = reasoner.getDataProperty(URI.create("http://xmlns.com/foaf/0.1/name"));
        Set individuals = reasoner.allInstancesOf(Person);
        Iterator i = individuals.iterator();
        while (i.hasNext()) {
            OWLIndividual ind = (OWLIndividual)i.next();
            String name = (String)reasoner.getPropertyValue(ind, foafName).getValue();
            OWLClass type = reasoner.typeOf(ind);
            OWLIndividual homepage = reasoner.getPropertyValue(ind, workHomepage);
            System.out.println("Name: " + name);
            System.out.println("Type: " + type.getURI().getFragment());
            if (homepage == null) {
                System.out.println("Homepage: Unknown");
            } else {
                System.out.println("Homepage: " + homepage.getURI());
            }
            System.out.println();
        }
    }
}

