/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.util.Iterator;
import mx.com.hp.hpl.jena.ontology.OntClass;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntModelSpec;
import mx.com.hp.hpl.jena.rdf.model.InfModel;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.reasoner.Reasoner;
import mx.com.hp.hpl.jena.reasoner.ValidityReport;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaReasoner {
    public static void main(String[] args) {
        JenaReasoner.usageWithDefaultModel();
        JenaReasoner.usageWithOntModel();
    }

    public static void usageWithDefaultModel() {
        System.out.println("Results with plain RDF Model");
        System.out.println("----------------------------");
        System.out.println();
        String ont = "http://protege.stanford.edu/plugins/owl/owl-library/koala.owl#";
        Reasoner reasoner = PelletReasonerFactory.theInstance().create();
        Model emptyModel = ModelFactory.createDefaultModel();
        InfModel model = ModelFactory.createInfModel((Reasoner)reasoner, (Model)emptyModel);
        model.read(ont);
        ValidityReport report = model.validate();
        JenaReasoner.printIterator(report.getReports(), "Validation Results");
        Resource c = model.getResource(ont + "MaleStudentWith3Daughters");
        JenaReasoner.printIterator((Iterator)model.listObjectsOfProperty(c, RDFS.subClassOf), "All super classes of " + c.getLocalName());
        System.out.println();
    }

    public static void usageWithOntModel() {
        System.out.println("Results with OntModel");
        System.out.println("---------------------");
        System.out.println();
        String ont = "http://protege.stanford.edu/plugins/owl/owl-library/koala.owl#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ont);
        ValidityReport report = model.validate();
        JenaReasoner.printIterator(report.getReports(), "Validation Results");
        OntClass c = model.getOntClass(ont + "MaleStudentWith3Daughters");
        JenaReasoner.printIterator((Iterator)c.listSuperClasses(), "All super classes of " + c.getLocalName());
        JenaReasoner.printIterator((Iterator)c.listSuperClasses(true), "Direct superclasses of " + c.getLocalName());
        System.out.println();
    }

    public static void printIterator(Iterator i, String header) {
        System.out.println(header);
        for (int c = 0; c < header.length(); ++c) {
            System.out.print("=");
        }
        System.out.println();
        if (i.hasNext()) {
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        } else {
            System.out.println("<EMPTY>");
        }
        System.out.println();
    }
}

