/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.io.PrintWriter;
import mx.com.hp.hpl.jena.ontology.OntModel;
import mx.com.hp.hpl.jena.ontology.OntModelSpec;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdql.Query;
import mx.com.hp.hpl.jena.rdql.QueryEngine;
import mx.com.hp.hpl.jena.rdql.QueryExecution;
import mx.com.hp.hpl.jena.rdql.QueryResults;
import mx.com.hp.hpl.jena.rdql.QueryResultsFormatter;
import org.mindswap.pellet.jena.PelletQueryEngine;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class RDQLExample {
    public static void main(String[] args) throws Exception {
        String ns = "http://www.w3.org/2001/sw/WebOnt/guide-src/food";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(ns + ".owl");
        model.setStrictMode(false);
        Resource RedMeatCourse = model.getResource(ns + "#RedMeatCourse");
        Resource PastaWithLightCreamCourse = model.getResource(ns + "#PastaWithLightCreamCourse");
        model.createIndividual(ns + "#MyLunch", PastaWithLightCreamCourse);
        model.createIndividual(ns + "#MyDinner", RedMeatCourse);
        String queryBody = "WHERE \t   (?Meal rdf:type food:MealCourse)\t   (?Meal food:hasDrink ?Wine)\t   (?Wine wine:hasColor ?WineColor)USING       food FOR <http://www.w3.org/2001/sw/WebOnt/guide-src/food#>      wine FOR <http://www.w3.org/2001/sw/WebOnt/guide-src/wine#>";
        String queryStr1 = "SELECT * " + queryBody;
        String queryStr2 = "SELECT ?Meal, ?WineColor " + queryBody;
        Query query1 = new Query(queryStr1);
        query1.setSource((Model)model);
        Query query2 = new Query(queryStr2);
        query2.setSource((Model)model);
        RDQLExample.printQueryResults("Running first query with PelletQueryEngine...", new PelletQueryEngine(query1));
        RDQLExample.printQueryResults("Running second query with PelletQueryEngine...", new PelletQueryEngine(query2));
        RDQLExample.printQueryResults("Running second query with standard Jena QueryEngine...", (QueryExecution)new QueryEngine(query1));
    }

    public static void printQueryResults(String header, QueryExecution qe) throws Exception {
        System.out.println(header);
        QueryResults results = qe.exec();
        QueryResultsFormatter formatter = new QueryResultsFormatter(results);
        formatter.printAll(new PrintWriter(System.out));
        System.out.println();
    }
}

