/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.GraphListener;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.TripleMatch;
import mx.com.hp.hpl.jena.graph.compose.MultiUnion;
import mx.com.hp.hpl.jena.reasoner.InfGraph;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import mx.com.hp.hpl.jena.util.iterator.ExtendedIterator;
import mx.com.hp.hpl.jena.util.iterator.NullIterator;

public class DisjointMultiUnion
extends MultiUnion
implements GraphListener {
    private boolean listenChanges;
    private boolean deletion = false;
    private Set changedGraphs = new HashSet();

    public DisjointMultiUnion() {
        this(false);
    }

    public DisjointMultiUnion(boolean listenChanges) {
        this.listenChanges = listenChanges;
    }

    public DisjointMultiUnion(Graph graph) {
        this(false);
        this.addGraph(graph);
    }

    public boolean isEmpty() {
        Iterator i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            if (((Graph)i.next()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ExtendedIterator graphBaseFind(TripleMatch t) {
        NullIterator i = NullIterator.instance;
        Iterator graphs = this.m_subGraphs.iterator();
        while (graphs.hasNext()) {
            ExtendedIterator newTriples = ((Graph)graphs.next()).find(t);
            i = i.andThen((ClosableIterator)newTriples);
        }
        return i;
    }

    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            if (graph instanceof MultiUnion) {
                MultiUnion union = (MultiUnion)graph;
                if (union.getBaseGraph() != null) {
                    this.addGraph(union.getBaseGraph());
                }
                Iterator i = union.getSubGraphs().iterator();
                while (i.hasNext()) {
                    this.addGraph((Graph)i.next());
                }
            } else if (graph instanceof InfGraph) {
                this.addGraph(((InfGraph)graph).getRawGraph());
            } else {
                this.m_subGraphs.add(graph);
                if (this.listenChanges) {
                    graph.getEventManager().register((GraphListener)this);
                }
            }
        }
    }

    public void releaseListeners() {
        Iterator graphs = this.m_subGraphs.iterator();
        while (graphs.hasNext()) {
            Graph graph = (Graph)graphs.next();
            graph.getEventManager().unregister((GraphListener)this);
        }
    }

    public void notifyAddTriple(Graph g, Triple t) {
        this.changedGraphs.add(g);
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        this.changedGraphs.add(g);
    }

    public void notifyAddList(Graph g, List triples) {
        this.changedGraphs.add(g);
    }

    public void notifyAddIterator(Graph g, Iterator it) {
        this.changedGraphs.add(g);
    }

    public void notifyAddGraph(Graph g, Graph added) {
        this.changedGraphs.add(g);
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.deletion = true;
    }

    public void notifyDeleteList(Graph g, List L) {
        this.deletion |= !L.isEmpty();
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.deletion |= triples.length > 0;
    }

    public void notifyDeleteIterator(Graph g, Iterator it) {
        this.deletion |= it.hasNext();
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
        this.deletion = true;
    }

    public void notifyEvent(Graph source, Object value) {
        this.deletion = true;
    }

    public boolean isStatementDeleted() {
        return this.deletion;
    }

    public void resetChanged() {
        this.deletion = false;
        this.changedGraphs.clear();
    }

    public DisjointMultiUnion minus(DisjointMultiUnion other) {
        if (!this.m_subGraphs.containsAll(other.m_subGraphs)) {
            return null;
        }
        DisjointMultiUnion diff = new DisjointMultiUnion();
        Iterator graphs = this.m_subGraphs.iterator();
        while (graphs.hasNext()) {
            Graph g = (Graph)graphs.next();
            if (other.m_subGraphs.contains(g) && !other.changedGraphs.contains(g)) continue;
            diff.addGraph(g);
        }
        return diff;
    }
}

